import React, { Component, Fragment } from "react";
import {
    View,
    Text,
    TextInput,
    ImageBackground,
    Image,
    ScrollView,
    TouchableOpacity,
    TouchableWithoutFeedback,
} from "react-native";
import { Input, TextLabel, FooterDetail, Supporticon } from "../../components";
import { pop, push, popToTop } from "../../services/NavigationService";
import ToggleSwitch from "toggle-switch-react-native";
import DatePicker from "react-native-datepicker";
import DateTimePicker from '@react-native-community/datetimepicker';
import ActionSheet from "react-native-actionsheet";
import { Images, icons, colors } from "../../assets";
import Metrics from "../../services/Metrics";
import { WithFetching } from "../../HOC";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { API_POST_CONTRACT, API_POST_SHIFT, API_PERCENTAGE } from "../../services/WebService";
import styles from "./styles";
import { compose } from "redux";
import { connect } from "react-redux";
import { getPostShiftPayload, getPostContractPayload } from "./handler";
import { POST_SHIFT_CONTRACT, DUMP, ADMIN_FEE_AMOUNT } from "../../actions/ActionTypes";
import moment from "moment";
import Utils from "../../Utils";
import Colors from "../../services/Colors";

let totalDays = 0;
class PostAShift extends Component {
    state = {
        description: "",
        hourly_pay_rate: 0,
        user_id: this.props.user.id,
        category_id: this.props.route.params.category_id,
        contract_type: this.props.route.params.data,
        shift_start_date: "",
        shift_end_date: "",
        shift_start_time: "",
        shift_end_time: "",
        isOn: false,
        showstartdate: false,
        showenddate: false,
        showstarttime: false,
        showendtime: false,
        indexOfDropdown: 0,
        latitude: 0,
        longitude: 0,
        address: "Pick location",
        maximum_radius: 0,
        cost_per_mile: 0,
        iscovid_val:'',
        contract_status: "active",
        isError: false,
        project_validity: "2 weeks",
        diffDays: 0,
        diffTime: 0,
        diffTimeA: 0,
        contractTime: "Weeks",
        contractDateErr: "",
        arrForDropdown: [
            "Select Weeks...",
            "1 week",
            "2 weeks",
            "3 weeks",
            "4 weeks",
            "5 weeks",
            "6 weeks",
            "7 weeks",
            "8 weeks",
            "9 weeks",
            "10 weeks",
            "11 weeks",
            "12 weeks",
            "cancel"
        ],
        startDateErr: "",
        endDateErr: "",
        startTimeErr: "",
        endTimeErr: "",
        percentageRate: 0,
    };

    componentDidMount() {
        this.getPercentageValue();

    }
    getPercentageValue = () => {
        this.props.cbShowLoader(true);
        this.props.generalAction(
            API_PERCENTAGE,
            null,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbSuccess,
            this.cbFailure,
            true
        );
    }
    cbSuccess = (response) => {
        this.props.cbShowLoader(false);

        const { percentage_value } = response;
        this.setState({
            percentageRate: percentage_value
        });
        this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: percentage_value });
        Utils.setAdminFee(percentage_value);
    }
    cbFailure = (response) => {
        this.props.cbShowLoader(false);
    }
    onSubmit = () => {
        const {
            contract_type,
            description,
            hourly_pay_rate,
            shift_start_date,
            shift_end_date,
            shift_start_time,
            shift_end_time,
            user_id,
            category_id,
            address,
            maximum_radius,
            cost_per_mile,
            latitude,
            longitude,
            contract_status,
            project_validity,
            isOn,
            diffTime,
            diffTimeA,
            diffDays,
            iscovid_val
        } = this.state;

        if (
            contract_type === "Shift" &&
            description &&
            hourly_pay_rate &&
            shift_start_date &&
            shift_end_date &&
            shift_start_time &&
            shift_end_time &&
            latitude &&
            longitude
        ) {
            if (
                (isOn &&
                    (!maximum_radius || !cost_per_mile || +maximum_radius > 50)) ||
                (shift_start_date == shift_end_date && shift_start_time > shift_end_time) ||
                diffTime <= 0 ||
                diffTime > 12 ||
                diffDays > 1
            ) {
                this.dateTimeValidation();
            } else if ((isOn && maximum_radius && cost_per_mile) || !isOn) {
                this.setState({ isError: false });
                let payload = getPostShiftPayload({
                    contract_type,
                    description,
                    hourly_pay_rate,
                    shift_start_date,
                    shift_end_date,
                    shift_start_time,
                    shift_end_time,
                    user_id,
                    category_id,
                    address,
                    maximum_radius,
                    cost_per_mile,
                    latitude,
                    longitude,
                    contract_status,
                    total_hours: Math.abs(diffTimeA),
                    isOn,
                    iscovid: iscovid_val? "yes" : "no"
                });

                this.requestShiftContract(payload, API_POST_SHIFT);
            }
        } else if (
            contract_type === "Contract" &&
            description &&
            hourly_pay_rate &&
            shift_start_date &&
            shift_end_date &&
            shift_start_time &&
            shift_end_time &&
            latitude &&
            longitude &&
            project_validity !== "Select Weeks..."
        ) {
            if ((shift_start_date == shift_end_date &&
                shift_start_time > shift_end_time) ||
                diffTime <= 0 || diffDays === 0) {
                this.dateTimeValidation();
            } else {
                this.setState({ isError: false });
                let payload = getPostContractPayload({
                    contract_type,
                    description,
                    hourly_pay_rate,
                    shift_start_date,
                    shift_end_date,
                    shift_start_time,
                    shift_end_time,
                    user_id,
                    category_id,
                    latitude,
                    longitude,
                    address,
                    contract_status,
                    project_validity,
                    total_hours: (diffTimeA * diffDays),
                    shift_hours: diffTimeA,
                    iscovid: iscovid_val? "yes" : "no"
                });

                this.requestShiftContract(payload, API_POST_CONTRACT);
            }
        } else {


            this.setState({ isError: true });
        }
    };

    dateTimeValidation() {
        const {
            shift_end_date,
            shift_start_date,
            shift_start_time,
            shift_end_time,
            diffTime
        } = this.state;
        this.setState({
            isError: true,
            startDateErr:
                shift_end_date <= shift_start_date || diffTime > 12
                    ? "select valid start date"
                    : "",
            endDateErr:
                shift_end_date <= shift_start_date || diffTime > 12
                    ? "select valid end date"
                    : "",
            startTimeErr:
                shift_start_time > shift_end_time || diffTime <= 0
                    ? "select valid start time"
                    : "",
            endTimeErr:
                shift_start_time > shift_end_time || diffTime <= 0
                    ? "select valid end time"
                    : ""
        });
    }

    requestShiftContract = (payload, api) => {
        this.props.cbShowLoader(true);
        this.props.generalAction(
            api,
            payload,
            POST_SHIFT_CONTRACT.SUCCESS,
            POST_SHIFT_CONTRACT.FAILURE,
            this.onPostSuccess,
            this.onPostFailure
        );
    };

    onPostSuccess = () => {
        Utils.showMessage(
            "Success",
            `${this.state.contract_type} posted successfully`,
            "success"
        );
        this.props.cbShowLoader(false);
        pop(2);
    };

    onPostFailure = err => {
        Utils.showError(err);
        this.props.cbShowLoader(false);
    };

    showActionSheet = () => {
        this.ActionSheet.show();
    };

    labelText = (label, topMargin = {}) => {
        return (
            <TextLabel
                color={colors.ActiveTabTitle}
                style={[styles.textLabel, topMargin]}
            >
                {label}
            </TextLabel>
        );
    };

    footer() {
        return (
            <FooterDetail
                clickBtn={this.onSubmit}
                style={{ position: "absolute", bottom: 0 }}
                text={"POST"}
                backgroundColor={{ backgroundColor: "#08548c" }}
                textColor={{ color: "#ffffff" }}
            />
        );
    }

    dropDown() {
        const { arrForDropdown, indexOfDropdown } = this.state;
        return (
            <React.Fragment>
                <TouchableOpacity
                    style={[
                        styles.emailAddressTextField,
                        styles.actionSheetView,
                        { width: Metrics.screenWidth - Metrics.ratio(60) }
                    ]}
                    onPress={this.showActionSheet}>

                    <Text style={styles.textInputStyle}>
                        {arrForDropdown[indexOfDropdown]}
                    </Text>
                    <Image style={styles.imageIcon} source={icons.ic_expand} />
                </TouchableOpacity>

                <ActionSheet
                    ref={o => (this.ActionSheet = o)}
                    title={"Which one do you like ?"}
                    options={arrForDropdown}
                    cancelButtonIndex={arrForDropdown.length - 1}
                    onPress={index => {
                        if (index !== this.state.arrForDropdown.length - 1) {
                            this.setState({
                                indexOfDropdown: index,
                                project_validity: arrForDropdown[index]
                            });
                        }
                    }}
                />
                {this.state.arrForDropdown[indexOfDropdown] ===
                    "Select Weeks..." &&
                    this.renderError("Schedule is required", {
                        marginTop: -25
                    })}
            </React.Fragment>
        );
    }

    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    onLocation = () => {
        push("locationPicker", { cbOnLocationPicked: this.cbOnLocationPicked });
    };

    cbOnLocationPicked = objLoc => {

        if (objLoc.address.length) {
            this.setState({
                latitude: objLoc.lat,
                longitude: objLoc.lng,
                address: objLoc.address
            });
        }
    };

    renderSeparator() {
        return (
            <View style={styles.containerSeparator}>
                <View style={styles.separator} />
            </View>
        );
    }

    descriptionCard() {
        return (
            <View elevation={15} style={styles.inputWrapper}>
                <Input
                    blurOnSubmit={true}
                    placeholder={"Description"}
                    multiline={true}
                    numberOfLines={3}
                    returnKeyType="done"
                    maxLength={60}
                   // keyboardType="email-address"
                    textFieldStyle={styles.emailAddressTextField}
                    cbOnChangeText={txt => this.setState({ description: txt })}
                    autoCapitalize="none"
                />

                {!this.state.description &&
                    this.renderError("Description is required", {
                        paddingHorizontal: 20
                    })}
            </View>
        );
    }

    locationCard() {
        return (
            <TouchableWithoutFeedback onPress={this.onLocation}>
                <View elevation={15} style={styles.locationWrapper}>
                    <Text
                    
                        style={
                            this.state.latitude === 0
                                ? styles.txtLocEmpty
                                : styles.txtLocPicked
                        }
                    >

                        {/* first dfsdfsds dsfd dsfds dffd dgh slkka iuahd uhasd dyuen jdhsj
                        dfnbdsnfb dsbhfhdsdhfg dsfgh dfhgh dfhghfd dfhgjhdf dfhghdg hjdgdhfg djgfdhg
                        fhds
                        sdjf
                        sdjfhj */}
                        {this.state.address}
                    </Text>
                    {this.renderSeparator()}
                    {this.state.latitude === 0 &&
                        this.renderError("Location is required", {
                            paddingHorizontal: 20
                        })}
                </View>
            </TouchableWithoutFeedback>
        );
    }

    contractRateCard() {
        const { contractTime, contractDateErr } = this.state;
        return (
            <Fragment>
                <TextInput
                    ref={ref => (this.contractRate = ref)}
                    value={this.state.contractTime}
                    editable={false}
                    style={[
                        contractTime == "Weeks" ? {} : styles.inputStyle,
                        styles.emailAddressTextField,
                        { width: Metrics.screenWidth - Metrics.ratio(60) }
                    ]}
                />
                {contractDateErr !== "" &&
                    this.renderError(contractDateErr, {
                        paddingHorizontal: 20
                    })}
            </Fragment>
        );
    }

    hourlyPayRateCard() {
        let heading =
            this.state.contract_type === "Contract"
                ? "Please Enter the Hourly Pay Rate"
                : "Please Enter the Hourly Pay Rate";
        return (
            <View elevation={15} style={[styles.inputWrapper, { padding: 10 }]}>
                {this.labelText(heading)}
                <Input
                    blurOnSubmit={true}
                    rightTextFieldImage={icons.ic_dollar}
                    placeholder={"8"}
                    returnKeyType="done"
                    keyboardType="numeric"
                    textFieldStyle={[
                        styles.emailAddressTextField,
                        { width: Metrics.screenWidth - Metrics.ratio(60) }
                    ]}
                    cbOnChangeText={txt =>
                        this.setState({ hourly_pay_rate: txt })
                    }
                    autoCapitalize="none"
                />
                {!this.state.hourly_pay_rate &&
                    this.renderError("Hourly Rate is required", {
                        paddingHorizontal: 20
                    })}
            </View>
        );
    }

    dateTimeCard() {
        const { data } = this.props.route.params;
        return (
            <View elevation={15} style={[styles.inputWrapper, { padding: 10 }]}>
                {this.dateColumn()}
                {this.timeColumn()}
                {data &&
                    data === "Contract" &&
                    this.labelText("Project Validity")}
                {data && data === "Contract" && this.contractRateCard()}
            </View>
        );
    }

    datePickerandorid(modeval, setDate, datavalue, formatval) {
        const { shift_start_date } = this.state;
        return (

            <View>

                <DateTimePicker
                    style={{
                        borderBottomWidth: 1,
                        borderColor: Colors.textfieldBorder,
                        width: Platform.OS ? 345 : 350

                    }}
                    date={datavalue}
                    mode={modeval}
                    dateFormat={formatval}
                    minimumDate={new Date()}
                    //minimumDate={moment().format("YYYY-MM-DD")}
                    value={new Date()}
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    is24Hour={true}
                    customStyles={{
                        dateInput: {
                            borderWidth: 0,
                            justifyContent: "flex-start",
                            alignItems: "flex-start",
                            paddingTop: 6,
                            paddingLeft: 10
                        },
                        dateText: {
                            color: "#241332"
                        }
                    }}
                    onChange={setDate}

                />

            </View>
        );
    }

    dateColumn() {
        return (
            <React.Fragment>
                {this.labelText("Shift Date")}
                <View style={{ flexDirection: "row", flex: 1 }}>
                    <View
                        style={{
                            flex: 1,
                            padding: 10,
                            flexDirection: "column"
                        }}>

                        {Utils.isPlatformAndroid ?
                            <TouchableOpacity style={styles.viewstyle}
                                onPress={showstartdate => {
                                    this.setState({ showstartdate: true });
                                }}>

                                <View style={styles.passwordContainer}>
                                    <TextInput
                                        style={styles.inputStyle}
                                        editable={false}
                                        selectTextOnFocus={false}
                                        placeholder="Start Date"
                                        value={this.state.shift_start_date}
                                    />
                                    <Image style={styles.ImageStyle}
                                        source={icons.reg_calendar}
                                        size={5}
                                    />
                                </View>
                            </TouchableOpacity> :
                            this.datePicker(
                                "Start Date",
                                icons.ic_calender,
                                "date",
                                this.setStartDate,
                                this.state.shift_start_date,
                                "YYYY-MM-DD"
                            )
                        }

                        {this.state.showstartdate == true ?
                            this.datePickerandorid("date", this.setAndroidStartDate, this.state.shift_start_date, "YYYY-MM-DD") : null}

                        {!this.state.shift_start_date &&
                            this.renderError("Start Date is required", {
                                paddingHorizontal: 5
                            })}
                        {this.state.startDateErr.length > 0 &&
                            this.renderError(this.state.startDateErr, {
                                paddingHorizontal: 5
                            })}
                    </View>
                    <View
                        style={{
                            flex: 1,
                            padding: 10,
                            flexDirection: "column"
                        }}>
                        {Utils.isPlatformAndroid ?
                            <TouchableOpacity style={styles.viewstyle}
                                onPress={showstartdate => {
                                    this.setState({ showenddate: true });
                                }}>

                                <View style={styles.passwordContainer}>
                                    <TextInput
                                        style={styles.inputStyle}
                                        editable={false}
                                        selectTextOnFocus={false}
                                        placeholder="End Date"
                                        value={this.state.shift_end_date}
                                    />
                                    <Image style={styles.ImageStyle}
                                        source={icons.reg_calendar}
                                    />
                                </View>
                            </TouchableOpacity> :
                            this.datePicker(
                                "End Date",
                                icons.ic_calender,
                                "date",
                                this.setEndtDate,
                                this.state.shift_end_date,
                                "YYYY-MM-DD"
                            )}


                        {this.state.showenddate == true ?
                            this.datePickerandorid("date", this.setAndroidEndtDate, this.state.shift_end_date, "YYYY-MM-DD") : null}

                        {!this.state.shift_end_date &&
                            this.renderError("End Date is required", {
                                paddingHorizontal: 5
                            })}
                        {this.state.endDateErr.length > 0 &&
                            this.renderError(this.state.endDateErr, {
                                paddingHorizontal: 5
                            })}

                    </View>
                </View>
            </React.Fragment>
        );
    }

    timeColumn() {
        const {
            shift_start_time,
            shift_end_time,
            shift_start_date,
            shift_end_date
        } = this.state;
        return (
            <React.Fragment>
                {this.labelText("Shift Time")}
                <View
                    style={{
                        flexDirection: "row",
                        flex: 1,
                        justifyContent: "space-between"
                    }}
                >
                    <View style={{ flex: 1, padding: 10 }}>

                        {Utils.isPlatformAndroid ?
                            <TouchableOpacity style={styles.viewstyle}
                                onPress={showstartdate => {
                                    this.setState({ showstarttime: true });
                                }}>

                                <View style={styles.passwordContainer}>
                                    <TextInput
                                        style={styles.inputStyle}
                                        editable={false}
                                        selectTextOnFocus={false}
                                        placeholder="Start Time"
                                        value={this.state.shift_start_time}
                                    />
                                    <Image style={styles.ImageStyle}
                                        source={icons.ic_time}
                                    />
                                </View>
                            </TouchableOpacity> :
                            this.datePicker(
                                "Start Time",
                                icons.ic_time,
                                "time",
                                this.setStartTime,
                                shift_start_time,
                                "HH:mm:A"
                            )}

                        {this.state.showstarttime == true ?
                            this.datePickerandorid("time", this.setAndroidStartTime, this.state.shift_start_time, 
                            "HH:mm:A"): null}

                        {!shift_start_time &&
                            this.renderError("Start Time is required", {
                                paddingHorizontal: 5
                            })}
                        {this.state.startTimeErr.length > 0 &&
                            this.renderError(this.state.startTimeErr, {
                                paddingHorizontal: 5
                            })}
                    </View>
                    <View style={{ flex: 1, padding: 10 }}>

                        {Utils.isPlatformAndroid ?
                            <TouchableOpacity style={styles.viewstyle}
                                onPress={showstartdate => {
                                    this.setState({ showendtime: true });
                                }}>

                                <View style={styles.passwordContainer}>
                                    <TextInput
                                        style={styles.inputStyle}
                                        editable={false}
                                        selectTextOnFocus={false}
                                        placeholder="End Time"
                                        value={this.state.shift_end_time}
                                    />
                                    <Image style={styles.ImageStyle}
                                        source={icons.ic_time}
                                    />
                                </View>
                            </TouchableOpacity> :
                            this.datePicker(
                                "End Time",
                                icons.ic_time,
                                "time",
                                this.setEndTime,
                                shift_end_time,
                                "HH:mm:A"
                            )}

                        {this.state.showendtime == true ?
                            this.datePickerandorid("time", this.setAndroidEndTime, this.state.shift_start_time, "HH:mm:A")
                            : null}
                        {!shift_end_time &&
                            this.renderError("End Time is required", {
                                paddingHorizontal: 5
                            })}
                        {this.state.endTimeErr.length > 0 &&
                            this.renderError(this.state.endTimeErr, {
                                paddingHorizontal: 5
                            })}
                    </View>
                </View>
                {shift_start_date == shift_end_date &&
                    shift_end_time < shift_start_time &&
                    this.renderError("select valid start and end time", {
                        paddingHorizontal: 5
                    })}
            </React.Fragment>
        );
    }

    mileageColumn() {
        const { cost_per_mile, maximum_radius } = this.state;
        return (
            <React.Fragment>
                <View style={{ flex: 1, flexDirection: "row" }}>
                    <View style={[styles.mileageColumnStyleLeft]}>
                        <Input
                            blurOnSubmit={false}
                            placeholder={"Cost per mile"}
                            returnKeyType="next"
                            cbOnChangeText={txt =>
                                this.setState({ cost_per_mile: txt })
                            }
                            value={cost_per_mile}
                            keyboardType="numeric"
                            textFieldStyle={[
                                styles.emailAddressTextField,
                                { width: "100%" }
                            ]}
                            autoCapitalize="none"
                        />
                        {!cost_per_mile &&
                            this.renderError("Cost Mile is required", {
                                paddingHorizontal: 5
                            })}
                    </View>
                    <View style={[styles.mileageColumnStyleRight]}>
                        <Input

                            blurOnSubmit={true}
                            placeholder={"Maximum Radius"}
                            returnKeyType="done"
                            ref={ref => {
                                this.location = ref;
                            }}
                            maxLength={2}
                            value={maximum_radius}
                            cbOnChangeText={txt =>
                                this.setState({ maximum_radius: +txt })
                            }
                            keyboardType="numeric"
                            textFieldStyle={[
                                styles.emailAddressTextField,
                                { width: "100%" }
                            ]}
                          //  autoCapitalize="none"
                        />
                        {!maximum_radius &&
                            this.renderError("Radius is required", {
                                paddingHorizontal: 5
                            })}
                        {+maximum_radius > 50 &&
                            this.renderError("Radius is too big", {
                                paddingHorizontal: 5
                            })}
                    </View>
                </View>
                <Text>Max "Radius" should be : 50</Text>
            </React.Fragment>
        );
    }

    mileageHeader() {
        const { cost_per_mile, maximum_radius } = this.state;
        let milPaid = maximum_radius * cost_per_mile;
        return (
            <View style={{ flex: 1, flexDirection: "row" }}>
                <View style={{ flex: 1 }}>
                    {this.labelText("Mileage Paid")}
                </View>
                <View
                    style={{
                        position: "absolute",
                        right: 0,
                        top: 0,
                        flexDirection: "row",
                        alignItems: "flex-end"
                    }}
                >
                    {this.state.isOn && (
                        <Text
                            style={[styles.rateText, { paddingHorizontal: 10 }]}
                        >
                            Total:{" "}
                            <Text style={styles.rateBold}>${milPaid.toFixed(2)}</Text>
                        </Text>
                    )}
                    <ToggleSwitch
                        isOn={this.state.isOn}
                        onColor="#7DCC38"
                        offColor="#ABABAB"
                        size="small"
                        onToggle={isOn =>
                            this.setState({ isOn: !this.state.isOn })
                        }
                    />
                </View>
            </View>
        );
    }

    mileageCard() {
        return (
            <View
                elevation={15}
                style={[
                    styles.inputWrapper,
                    { padding: 10, flexDirection: "column" }
                ]}
            >
                {this.mileageHeader()}
                {this.state.isOn && this.mileageColumn()}
            </View>
        );
    }

    totalCostCard() {
        const {
            hourly_pay_rate,
            diffTime,
            contract_type,
            project_validity,
            maximum_radius,
            cost_per_mile,
            isOn,
            percentageRate,
            diffTimeA,
            diffDays
        } = this.state;


        let totalAmount = diffDays * diffTimeA * hourly_pay_rate;

        let percentRate = 0;
        if (contract_type == "Contract") {
            percentRate = (percentageRate / 100) * +totalAmount;
        } else {

            totalAmount = diffTimeA * hourly_pay_rate

            // percentRate = (percentageRate / 100) * +hourly_pay_rate;
            if (!isOn) {
                percentRate = (percentageRate / 100) * +totalAmount;

            } else {
                totalAmount = +totalAmount + (+maximum_radius * +cost_per_mile);
            }
        }

        let totalCost = contract_type == "Contract"
            ? +totalAmount + percentRate
            : contract_type === "Shift" && isOn
                ? ((percentageRate / 100) * +totalAmount) + totalAmount
                : (+totalAmount + percentRate);

    
        return (
            <View
                elevation={15}
                style={[
                    styles.inputWrapper,
                    { padding: 10, flexDirection: "column" }
                ]}
            >
                <View style={{ flex: 1, flexDirection: "row" }}>
                    <View style={{ flex: 1 }}>
                        {this.labelText("TOTAL COST")}
                    </View>
                    <View
                        style={{
                            position: "absolute",
                            right: 0,
                            top: 0,
                            flexDirection: "row",
                            alignItems: "flex-end"
                        }}
                    >
                        <Text style={[styles.rateBold, { paddingHorizontal: 10 }]}>
                            {`$${totalCost > 0 ? totalCost.toFixed(2) : 0}`}
                        </Text>
                    </View>
                </View>
            </View>
        );
    }

    render() {
        const { item, data } = this.props.route.params;
        const { percentageRate, diffDays } = this.state;

        return (
            <ImageBackground source={Images.bgImage} style={styles.bgImage}>
                <Text style={[styles.heading, styles.boldHeading]}>
                    Post <Text style={styles.heading}>a {data}</Text>
                </Text>
                <ScrollView
                    contentContainerStyle={{ backgroundColor: "transparent" }}
                >
                    {this.descriptionCard()}
                    {this.locationCard()}
                    {this.hourlyPayRateCard()}
                    {this.dateTimeCard()}
                    {data && data === "Shift" && this.mileageCard()}
                    {this.totalCostCard()}
                    <Text
                        style={{
                            marginTop: 10,
                            color: "green"
                        }}>{`${percentageRate}% adminstration fee will be applied`}</Text>
                    {this.agreementPart()}
                </ScrollView>
                {this.footer()}

                <Supporticon style={{ bottom: 60 }}
                    clickBtn={() => push("Support")} />
            </ImageBackground>
        );
    }

    agreementPart = () => {
        return (
            <View
                style={{
                    flexDirection: "row",
                    marginBottom: 60
                }}
            >
                <TouchableOpacity
                    style={{ padding: 5, marginTop: 20 }}
                    onPress={() => {
                        this.setState({
                            iscovid_val: !this.state.iscovid_val,
                        });
                    }}
                >
                    <Image
                        source={
                            this.state.iscovid_val
                                ? icons.ic_check
                                : icons.ic_uncheck
                        }
                    />
                </TouchableOpacity>

                <Text style={[styles.otherDocument, { marginTop: 28 }]}>
                {this.state.contract_type === "Shift" ? "Covid Shift" : "Covid Contract" }
                </Text>
            </View>
        );
    };
    setStartDate = date => {
        this.setState({ showstartdate: false })
        this.validateStartDate(date, "no");
    };

    setAndroidStartDate = (event, selectedDate) => {
        this.setState({ showstartdate: false })
        // const dateset = moment(selectedDate).format("YYYY-MM-DD");


        this.validateStartDate(selectedDate, "yes");
    };

    setAndroidEndtDate = (event, selectedDate) => {
        this.setState({ showenddate: false })


        this.validateEndDate(selectedDate, "yes");
    };
    setEndtDate = date => {
        this.validateEndDate(date, "no");
    };

    validateStartDate(date, val) {

        const startdate = moment(date).format("YYYY-MM-DD");
        this.setState(
            {
                shift_start_date: val == 'yes' ? startdate : date,
                startDateErr: "",
                endDateErr: ""
            },
            () => this.calculateDiffTimeB()
        );
        this.calculateDiffDate(this.state.shift_end_date, val == 'yes' ? startdate : date);
    }

    validateEndDate(date, val) {
        const enddate = moment(date).format("YYYY-MM-DD");

        this.setState(
            {
                shift_end_date: val == 'yes' ? enddate : date,
                endDateErr: "",
                startDateErr: ""
            },
            () => this.calculateDiffTimeB()
        );
        this.calculateDiffDate(val == 'yes' ? enddate : date, this.state.shift_start_date);
    }

    calculateDiffDate(b, a) {
        const { contract_type } = this.state;
        let diffDays = moment(b, "YYYY-MM-DD").diff(
            moment(a, "YYYY-MM-DD"),
            "days");

        if (contract_type === 'Contract') {
            totalDays = ++diffDays
        } else {
            totalDays = diffDays
        }
        this.setContractTime(totalDays);
        if (totalDays <= 84) {
            this.setState({ diffDays: totalDays });
        } else {
            this.setState({ diffDays: 0 });
        }
    }

    setContractTime(diffDays) {

        if (diffDays == 0 || diffDays > 84) {
            this.setState({ contractDateErr: "Max. Contract days are 84" });
        } else {
            for (let i = 1; i <= 12; i++) {
                if (diffDays <= i * 7) {
                    this.setState({
                        contractTime: `${i} Weeks`,
                        project_validity: `${i} Weeks`,
                        contractDateErr: ""
                    });
                    break;
                }
            }
        }
    }

    setStartTime = time => {
 
       this.setState(
            {
                shift_start_time: time,
                startTimeErr: "",
                endTimeErr: "",
                showstarttime:false
            },
            () => this.calculateDiffTimeB()
        );
    };

    setAndroidStartTime = (event,time) => {

        const starttime = moment(time).format("HH:mm:A");

        this.setState(
            {
                shift_start_time: starttime,
                startTimeErr: "",
                endTimeErr: "",
                showstarttime:false
            },
            () => this.calculateDiffTimeB()
        );
    };

    setAndroidEndTime = (event,time) => {

        const endtime = moment(time).format("HH:mm:A");
        this.setState(
            {
                shift_end_time: endtime,
                startTimeErr: "",
                endTimeErr: "",
                showendtime:false

            },
            () => this.calculateDiffTimeB()
        );
    };

    setEndTime = time => {

        this.setState(
            {
                shift_end_time: time,
                startTimeErr: "",
                endTimeErr: ""
            },
            () => this.calculateDiffTimeB()
        );
    };

    calculateDiffTimeB(b, a, c) {
        const {
            shift_start_date,
            shift_end_date,
            shift_start_time,
            shift_end_time
        } = this.state;

        if (
            shift_start_date &&
            shift_end_date &&
            shift_start_time &&
            shift_end_time
        ) {
            let a = `${shift_start_date} ${shift_start_time.slice(0, 6)}00`;
            let b = `${shift_end_date} ${shift_end_time.slice(0, 6)}00`;
            let diffTime = moment(b).diff(moment(a), "hours");

            let newTimeDiff = Utils.calculateDiffTime(shift_end_time, shift_start_time);

            this.setState({
                diffTime,
                diffTimeA: newTimeDiff
            });
        }
    }

    calculateDiffTime(b, a, c) {
        let dif = moment(b, "HH:mm:a").diff(moment(a, "HH:mm:a"));
        let diffTime = moment.duration(dif).hours();
        if (diffTime > 0) {
            this.setState({ [c]: c == "shift_start_time" ? a : b });
        }
        this.setState({ diffTime });
    }

    datePicker(title, icon, dateTime, setPickedDate, dateVlue, format) {
        return (
            <View>
                <DatePicker
                    style={styles.datePickerInput}
                    date={dateVlue}
                    mode={dateTime}
                    placeholder={title}
                    format={format}
                    minDate={
                        dateTime == "time"
                            ? null
                            : moment().format("YYYY-MM-DD")
                    }
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    iconComponent={
                        <Image
                            source={icon}
                            style={{ width: 15, height: 15, top: -5 }}
                        />
                    }
                    customStyles={{
                        dateInput: styles.dateInput,
                        dateText: { color: "#241332" }
                    }}
                    onDateChange={setPickedDate}
                />
            </View>
        );
    }
}

const actions = { generalAction, generalSaveAction };

const mapStateToProps = ({ user }) => {
    return {
        user: user.data,
    };
};

const ComposePostAShift = compose(
    connect(mapStateToProps, actions)(WithFetching(PostAShift))
);

export default ComposePostAShift;

ComposePostAShift.navigationOptions = ({ navigation }) => {
    return {
        headerStyle: styles.header,
        headerTitleStyle: styles.headerTitle,
        headerLeft: (
            <TouchableOpacity onPress={() => pop()}>
                <Image
                    style={{ margin: 10 }}
                    resizeMode="contain"
                    source={Images.backArrow}
                />
            </TouchableOpacity>
        ),
        headerRight: null
    };
};
