import { StyleSheet, Platform } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
import Fonts from "../../services/Fonts";

export default StyleSheet.create({
    headerTitle: {
        color: colors.HeaderTitleColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    bgImage: {
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "column",
        flex: 1
    },
    backArrow: {
        flex: 0.45,
        alignSelf: "flex-start",
        backgroundColor: "yellow",
        marginTop: 8,
        marginLeft: 8
    },
    heading: {
        ...UIFont.font(fonts.regular, fontSize.xLarger, colors.WhiteColor),
        alignSelf: "flex-start",
        marginLeft: 15
    },
    boldHeading: {
        ...UIFont.font(fonts.semiBold, fontSize.xLarger, colors.WhiteColor)
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.4,
        shadowRadius: 2,
        shadowOffset: {
            height: 2,
            width: 2
        }
    },
    emailAddressTextField: {
        paddingTop: Platform.OS && 20,
        width: "95%",
        flexDirection: "row",
        alignItems: "center",
        borderColor: "#dddddd",
        borderBottomWidth: 1
    },
    textLabel: {
        ...UIFont.font(fonts.semiBold, fontSize.small, colors.ActiveTabTitle),
        alignSelf: "flex-start",
        lineHeight: 21,
        letterSpacing: 0
    },
    rateText: {
        ...UIFont.font(fonts.regular, fontSize.small, colors.BlackColor)
    },
    rateBold: {
        ...UIFont.font(fonts.semiBold, fontSize.small, colors.BlackColor)
    },
    actionSheetView: {
        flex: 1,
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin + Metrics.smallMargin,
        marginBottom: Metrics.baseMargin + Metrics.smallMargin
    },
    textInputStyle: {
        ...UIFont.font(fonts.regular, fontSize.small, "gray"),
        color: "gray",
        marginLeft: "1%",
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    imageIcon: {
        marginTop: Metrics.baseMargin
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    locationWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,

        marginTop: 10,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.4,
        shadowRadius: 2,
        shadowOffset: {
            height: 2,
            width: 2
        }
    },
    txtLocPicked: {
        ...UIFont.font(fonts.regular, fontSize.small, "#241332"),
        textAlign: "left",
        padding: Metrics.smallMargin,
        paddingLeft: Metrics.baseMargin,
        flex: 1,
        
        marginTop: Platform.OS && 10
    },
    txtLocEmpty: {
        ...UIFont.font(fonts.regular, fontSize.small, "#241332"),
        textAlign: "left",
        padding: Metrics.smallMargin,
        paddingLeft: Metrics.baseMargin,
        flex: 1,
        marginTop: Platform.OS && 10
    },
    containerSeparator: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center"
    },
    separator: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin * 2,
        height: 1,
        backgroundColor: colors.LightGreyColor,
        marginTop: Metrics.smallMargin,
        marginBottom: Metrics.baseMargin
    },
    datePickerInput: {
        width: "100%",
        borderBottomWidth: 1,
        borderColor: "#241332"
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        paddingLeft: 10
    },
    mileageColumnStyleRight: {
        width: "45%",
        alignSelf: "flex-end",
        right: 0
    },
    mileageColumnStyleLeft: {
        width: "45%",
        alignSelf: "flex-start",
        paddingRight: 10,
        left: 0
    },
    inputStyle: {
        ...UIFont.font(fonts.reqular, 18, "black")
    },

    passwordContainer: {
        flexDirection: 'row',
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder,
//        paddingBottom: 10,
    },
    inputStyle: {
        flex: 1,
        color:colors.BlackColor,
    },
    viewstyle: {
      //  width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
    },
    
    ImageStyle: {
        margin: 5,
        height: 20,
        width: 20,
        alignSelf:'center',
        resizeMode: 'stretch',
      
    },
});
