import React, { Component } from "react";
import {
    View,
    Text,
    ScrollView,
    Image,
    TouchableOpacity,
    AppState,
    Button
} from "react-native";
import {
    Separator,
    AppButton,
    TextLabel,
    FormHandler,
    Input,
} from "../../components";
import { compose } from "redux";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import ActionSheet from "react-native-actionsheet";
import { colors, Images, icons } from "../../assets";
import { connect } from "react-redux";
import Colors from "../../services/Colors";
import { USER, INFO_CONTENT } from "../../actions/ActionTypes";
import { pop, push, popToTop } from "../../services/NavigationService";
import {
    POST_API_RESGISTER_ABOUTUS, POST_API_RESGISTER_STEP2, API_DOCUMENTLIST,
    API_GET_CONTRACTOR
} from "../../services/WebService";
import { WithFetching, WithNetInfoListener } from "../../HOC";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { BASE_URL } from "../../services/WebService";
import styles from "./styles";
import moment from "moment";
import Utils from "../../Utils";
import categories from "../../reducers/categories";

class ProfessionalDetails extends Component {

    constructor(props) {
        super(props);

        const { user } = this.props;

        this.state = {
            appState: AppState.currentState,
            firstErr: false,
            isError: false,
            user_id: this.props.route.params.user_ID,
            categories: [
                { value: "Select...", id: 0 },
                { value: "Male", id: 1 },
                { value: "Female", id: 2 },
                { value: "cancel" },
            ],
            professional_title: '',
            qualifitcation: '',
            hourly_rate: '',
            about_me: '',
            aboutusarray: [
                { value: "Select...", id: 0 },
                { value: "Male", id: 1 },
                { value: "Female", id: 2 },
                { value: "cancel" },
            ],
            aboutus_id: "",
            indexCategory: 0,
            indexaboutus: 0,
            expiryDate: "",
            isError: false,
            licenceImagesArr: [{ uri: Images.addImage }],
            otherDocumentImagesArray: [{ uri: Images.addImage }],
            dob: '',
            status: '',
            token: '',
            selectedCategory: "",
            selectedaboutus: "",
            disabled: true,
            isDetailsEdited: false, // using this boolean to show submit button on profile edit
            handleMobileNumber: true,
            images: [],
            documentdata: user.documents
        };

    }

    componentDidMount() {
        const { categories } = this.props;

        let categoryList = [];
        categories.map(elem => {
            if (elem.child_categories_count === "0") {
                categoryList.push({
                    value: elem.parent_category.category_name,
                    id: elem.parent_category.id
                });
            }
            if (typeof elem.child_categories_count == "number") {
                elem.child_categories.map(el => {
                    categoryList.push({ value: el.category_name, id: el.id });
                });
            }
        });
        categoryList.push({ value: "cancel" });
        categoryList.unshift({ value: "Categories..." });
        this.setState({ categories: categoryList });


        this.Aboutus();
        this.Getdata();
    }

    Aboutus = () => {

        let aboutList = [];

        this.props.generalAction(
            POST_API_RESGISTER_ABOUTUS,
            {},
            INFO_CONTENT.SUCCESS,
            INFO_CONTENT.FAILURE,
            (data) => {

                aboutList = data
                aboutList.push({name: "cancel" });
                aboutList.unshift({ id: 0, name: "Select..." });

                this.setState({ aboutusarray: aboutList });

            },
            () => { },
            true
        );
    }

    Getdata = () => {

        this.props.generalAction(
            API_DOCUMENTLIST,
            {},
            USER.SUCCESS,
            USER.FAILURE,
            (data) => {
                this.setState({ addedImages: data })
                this.setimagedata();
            },
            () => { },
            true
        );

    }
    setimagedata = () => {

        const data = this.state.documentdata;
       
        let imagearray = [];
        for (var i = 0; i <= this.state.addedImages.length; i++) {

            var documentsource = this.state.addedImages[i].source;
            var documenttitle = this.state.addedImages[i].title;
            var documenterror = this.state.addedImages[i].validation;
            var documentSourceType = this.state.addedImages[i].source_type;

            for (let passdata in data) {

                if (passdata == documentsource) {

                    var documentdata = {};
                    documentdata["title"] = documenttitle;
                    documentdata["images"] = [{ uri: Images.addImage }, ...data[passdata]];
                    documentdata["key"] = documentsource + "[]";
                    documentdata["validation"] = JSON.parse(documenterror);
                    documentdata["source_type"] = documentSourceType;
                    documentdata["isError"] = false;

                    imagearray.push(documentdata);

                }


                this.setState({ images: imagearray })

            }

        }




    }
    onSubmit = () => {
        const {
            user_id,
            category_id,
            aboutus_id,
            dob,
            gender,
            qualifitcation,
            about_me,
            licenceImagesArr,
            otherDocumentImagesArray,
            expiryDate,
        } = this.state;


        const titleHandler = this.titleHandler.onSubmitForm();
        const rateHandler = this.rateHandler.onSubmitForm();
        const qualificationHandler = this.qualifitcation.onSubmitForm();

        if (titleHandler && rateHandler && qualificationHandler) {
            let payload = new FormData();
            payload.append("user_id", user_id);
            payload.append("professional_title", titleHandler.professional_title);
            payload.append("hourly_rate", rateHandler.hourly_rate);
            payload.append("category_id", category_id);
            payload.append("qualifitcation", qualificationHandler.qualifitcation);
            payload.append("about_me", this.aboutMe.getValue());
            payload.append("aboutus",aboutus_id);
            payload.append("dummy_update", "1");

            this.props.generalAction(
                POST_API_RESGISTER_STEP2,
                payload,
                USER.SUCCESS,
                USER.FAILURE,
                this.onSignUpSuccess,
                this.onSignUpFailure);

        } else {
            this.setState({
                isError: true,
            });
        }
    };

    onSignUpSuccess = user => {
       
        Utils.setUserID(user.id);
        this.props.cbShowLoader(false);

        const imagesdata = this.state.images;
        const user_ID = this.state.user_id;

        Utils.setRegisterScreen(imagesdata);

        push("documentRegister",{ user_ID });

    };

    onSignUpFailure = err => {
        this.props.cbShowLoader(false);
        Utils.showError(err);

    };
    showActionSheet = (func) => {

        func.show();

    };


    dropDown(arr, index, stateName, func, callBack) {
        return (
            <React.Fragment>
                <TouchableOpacity
                    style={[styles.categoryStyle, styles.actionSheetView]}
                    onPress={() => this.showActionSheet(func)}
                >
                    <Text
                        style={
                            index == 0
                                ? styles.zeroIndexCategoryStyle
                                : styles.textCategoryStyle
                        }>
                        {arr[index].value}
                    </Text>
                    <Image style={styles.imageIcon} source={icons.ic_expand} />
                </TouchableOpacity>
                <ActionSheet
                    ref={(o) => (func = o)}
                    options={arr.map((elem) => elem.value)}
                    cancelButtonIndex={arr.length - 1}
                    onPress={(i) => {
                        if (i !== arr.length - 1 && i !== 0) {
                            callBack(i);
                        }
                    }}
                />
                {this.state[stateName] === 0 &&
                    this.renderError(
                        `${stateName == "indexCategory" ? "Category" : "Gender"
                        } is required`,
                        { paddingHorizontal: 20 }
                    )}
            </React.Fragment>
        );
    }

    dropDownaboutus(arr, index, stateName, func, callBack) {
        return (
            <React.Fragment>
                <TouchableOpacity
                    style={[styles.categoryStyle, styles.actionSheetView]}
                    onPress={() => this.showActionSheet(func)}
                >
                    <Text
                        style={
                            index == 0
                                ? styles.zeroIndexCategoryStyle
                                : styles.textCategoryStyle
                        }>
                        {arr[index].name}
                    </Text>
                    <Image style={styles.imageIcon} source={icons.ic_expand} />
                </TouchableOpacity>
                <ActionSheet
                    ref={(o) => (func = o)}
                    options={arr.map((elem) => elem.name)}
                    cancelButtonIndex={arr.length - 1}
                    onPress={(i) => {
                        if (i !== arr.length - 1 && i !== 0) {
                            callBack(i);
                        }
                    }}
                />
                
            </React.Fragment>
        );
    }

    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }

    showSubmitButtonOnTextChange = () =>
        this.setState({ isDetailsEdited: true });

    render() {
        const {
            firstErr,
            aboutusarray,
            categories,
            professional_title,
            qualifitcation,
            hourly_rate,
            indexCategory,
            indexaboutus,
            about_me,

        } = this.state;
        return (
            <ScrollView style={{ flex: 1, margin: 10 }}>

                {this.heading("Category ")}

                {this.dropDown(
                    categories,
                    indexCategory,
                    "indexCategory",
                    this.category,
                    (i) => {
                        this.setState({
                            indexCategory: i,
                            category_id: categories[i].id,
                            isDetailsEdited: true,
                            selectedCategory: categories[i].value,
                        });
                    }
                )}
                <Separator style={styles.seperatorStyle} />
                {this.heading("Professional Title")}
                <View style={styles.eachColumn}>
                    <FormHandler ref={(ref) => (this.titleHandler = ref)}>
                        <Input
                            placeholder={"Professional Title..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Professional Title"
                            type={INPUT_TYPES.TEXT}
                            identifier="professional_title"
                            blurOnSubmit={false}
                            maxLength={25}
                            value={professional_title}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={(err) => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </FormHandler>
                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Self Introduction")}
                <View style={styles.eachColumn}>
                    <Input ref={(ref) => (this.aboutMe = ref)}

                        placeholder={"Self Introduction..."}
                        placeholderTextColor={Colors.textfieldBorder}
                        error={null}
                        type={INPUT_TYPES.TEXT}
                        identifier="about_me"
                        blurOnSubmit={false}
                        maxLength={150}
                        value={about_me}
                        multiline={true}
                        numberOfLines={3}
                        isContainerFlex={true}
                        style={styles.descriptionDocumentStyle}
                        // setError={(err) => this.setState({ firstErr: err })}
                        textFieldStyle={
                            !firstErr
                                ? { marginHorizontal: 5 }
                                : styles.textInputStyle
                        }
                        cbOnChangeText={this.showSubmitButtonOnTextChange}
                    />
                </View>

                <Separator style={styles.seperatorStyle} />
                {this.heading("Qualification")}
                <View style={styles.eachColumn}>
                    <FormHandler ref={(ref) => (this.qualifitcation = ref)}>
                        <Input
                            placeholder={"Qualification..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Qualification"
                            type={INPUT_TYPES.TEXT}
                            identifier="qualifitcation"
                            blurOnSubmit={false}
                            maxLength={25}
                            value={qualifitcation}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={(err) => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </FormHandler>
                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Hour Rate")}
                <View style={styles.eachColumn}>
                    <FormHandler ref={(ref) => (this.rateHandler = ref)}>
                        <Input
                            placeholder={"Hour Rate..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Hour Rate"
                            type={INPUT_TYPES.NUMBER}
                            identifier="hourly_rate"
                            blurOnSubmit={true}
                            maxLength={10}
                            value={hourly_rate}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={(err) => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </FormHandler>
                </View>


                <Separator
                    style={[styles.seperatorStyle]} />

                {this.heading("How did you hear about us ? ")}

                {this.dropDownaboutus(
                    aboutusarray,
                    indexaboutus,
                    "indexaboutus",
                    this.Aboutus,
                    (i) => {
                        this.setState({
                            indexaboutus: i,
                            aboutus_id: aboutusarray[i].id,
                            isDetailsEdited: true,
                            selectedaboutus: aboutusarray[i].value,
                        });
                    }
                )}

                <Separator
                    style={[styles.seperatorStyle, { marginBottom: 60 }]} />

                <View style={{
                    flexDirection: "row", alignItems: 'center', alignSelf: 'center',
                    alignContent: 'center'
                }}>
                    {/* <View style={styles.buttonStyleback}>
                        <AppButton
                            buttonTitle="Back"
                            style={{
                                backgroundColor: "#d45404",
                                width: "100%", alignItems: 'center'
                            }}
                            btnColor="#d45404"
                            onPress={() => {
                                pop();
                            }}
                        />
                    </View> */}
                    <View style={styles.buttonStyle}>
                        <AppButton
                            buttonTitle="Next"
                            style={{
                                backgroundColor: colors.ActiveTabTitle,
                                width: "100%", alignItems: 'center'
                            }}
                            btnColor={colors.cardColor}
                            onPress={() => {
                                this.onSubmit();
                            }}
                        />

                    </View>
                </View>
            </ScrollView>
        );
    }


}

const actions = { generalAction };

const mapStateToProps = ({ categories, networkInfo, user }) => {
    return {

        categories: categories.data,
        networkInfo,
        user: user.data
    };
};

const ComponentWithComposeFunc = compose(
    connect(
        mapStateToProps,
        actions
    )(WithFetching(WithNetInfoListener(ProfessionalDetails)))
);

export default ComponentWithComposeFunc;

ComponentWithComposeFunc.navigationOptions = ({ navigation }) => {
    return {
        title: "Professional Details",
        headerStyle: styles.header,
        headerTitleStyle: styles.toolbarTitle,
        headerLeft: (
            <TouchableOpacity onPress={() => popToTop()}>
                <Image
                    style={{ margin: 10 }}
                    resizeMode="contain"
                    source={Images.backArrow}
                />
            </TouchableOpacity>
        ),
        headerRight: (
            <View
                style={{
                    backgroundColor: colors.HeaderColor,
                    width: "10%"
                }}
            />
        )
    };
};

