import { StyleSheet, Platform } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";

export default StyleSheet.create({
    headerTitle: {
        color: colors.WhiteColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    container: {
        ...Platform.select({
            ios: {
                zIndex: 999
            }
        })
    },
    emailAddressTextField: {
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
        borderColor: Colors.textfieldBorder,
        borderBottomWidth: 1
    },
    actionSheetView: {
        flex: 1,
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin + Metrics.smallMargin,
        marginBottom: Metrics.baseMargin + Metrics.smallMargin
    },
    textInputStyle: {
        ...UIFont.font(fonts.reqular, fontSize.small, Colors.textfieldBorder),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    selectedDropdownText: {
        ...UIFont.font(fonts.reqular, fontSize.small, "#241332"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    toolbarTitle: {
        color: colors.WhiteColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
   
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },

    boldText: {
        ...UIFont.font(fonts.semiBold, 12, colors.BlackColor),
        marginTop: 10,
        marginBottom: -10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
   
    footerStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "50%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    },
    boldText: {
        ...UIFont.font(fonts.semiBold, 12, colors.BlackColor),
        marginTop: 10,
        marginBottom: -10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    eachColumn: {
        flexDirection: "column"
    },
    textInputStyle: {
        marginHorizontal: 10,
        color: "black"
    },
    seperatorStyle: {
        backgroundColor: "#dde3f6"
    },
    categoryStyle: {
        width: "100%",
        flexDirection: "row",
        alignItems: "center"
    },

    buttonStyle: {
        width: "40%",
        alignItems:'center',
        marginLeft:10,
        marginBottom:30
    },

    buttonStyleback: {
        width: "40%",
        alignItems:'center',
        marginRight:10,
        marginBottom:30
    },
    actionSheetView: {
        flex: 1,
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin
    },
    zeroIndexCategoryStyle: {
        ...UIFont.font(fonts.reqular, 18, Colors.textfieldBorder),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    textCategoryStyle: {
        ...UIFont.font(fonts.reqular, 18, "#606060"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin
    },
    inputStyle: {
        ...UIFont.font(fonts.reqular, 18, "#606060")
    },
    descriptionDocumentStyle: {
        ...UIFont.font(fonts.reqular, 13, "#606060"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    datePickerStyle: {
        marginHorizontal: 10,
        width: Platform.OS ? 370 : 395
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        paddingLeft: 10
    },
    dateText: {
        color: "#606060",
        fontSize: 18
    },
    locationWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        marginTop: 10,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.4,
        shadowRadius: 2,
        shadowOffset: {
            height: 2,
            width: 2
        }
    },
    txtLocPicked: {
        ...UIFont.font(fonts.regular, 18, "#606060"),
        textAlign: "left",
        padding: Metrics.smallMargin,
        paddingLeft: Metrics.baseMargin,
        flex: 1,
        marginTop: Platform.OS && 10,
        marginHorizontal: 5
    },
    txtLocEmpty: {
        ...UIFont.font(fonts.regular, 18, Colors.textfieldBorder),
        textAlign: "left",
        padding: Metrics.smallMargin,
        paddingLeft: Metrics.baseMargin,
        flex: 1,
        marginTop: Platform.OS && 10,
        marginHorizontal: 5
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    disabledColor: {
        backgroundColor: "#f8f8f8"
    }
});
