import React, { Component } from "react";
import {
    View,
    Text,
    ScrollView,
    Image,
    TouchableOpacity,
    Linking,
    TextInput,
    AppState,
} from "react-native";
import {
    Separator,
    AppButton,
    TextLabel,
    FormHandler,
    Input,
    DateTimePicker,
    CommentCard,
    FlatListHandler,
} from "../../components";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import ActionSheet from "react-native-actionsheet";
import { colors, Images, icons } from "../../assets";
import { connect } from "react-redux";
import Colors from "../../services/Colors";
import { USER } from "../../actions/ActionTypes";
import { push } from "../../services/NavigationService";
import {
    API_UPDATE_CONTRACTOR,
    API_GET_CONTRACTOR, API_DOCUMENTLIST
} from "../../services/WebService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { BASE_URL } from "../../services/WebService";
import styles from "./styles";
import moment from "moment";
import PhoneInput from "react-native-phone-input";
import Utils from "../../Utils";
import DateTime from '@react-native-community/datetimepicker';

class Contractor extends Component {


    constructor(props, context) {
        super(props, context);
        const { data } = this.props;

        this.state = {
            appState: AppState.currentState,
            firstErr: false,
            isError: false,
            full_name: props.data.full_name,
            user_id: props.data.id,
            email: props.data.email,
            image_url: props.img,
            categories: [
                { value: "Select...", id: 0 },
                { value: "Male", id: 1 },
                { value: "Female", id: 2 },
                { value: "cancel" },
            ],
            mobile_no: props.data.mobile_no,
            professional_title: props.data.professional_title,
            qualifitcation: props.data.qualifitcation,
            hourly_rate: props.data.hourly_rate,
            about_me: props.data.about_me,
            genderArr: [
                { value: "Select...", id: 0 },
                { value: "Male", id: 1 },
                { value: "Female", id: 2 },
                { value: "cancel" },
            ],
            gender: "",
            indexCategory: 0,
            indexGender: 0,
            expiryDate: "",
            isError: false,
            licenceImagesArr: [{ uri: Images.addImage }],
            otherDocumentImagesArray: [{ uri: Images.addImage }],
            dob: props.data.dob,
            status: props.data.is_personnel_file_status,
            token: props.data.token,
            selectedCategory: "",
            disabled: true,
            isDetailsEdited: false, // using this boolean to show submit button on profile edit
            handleMobileNumber: true,
            reviewComments: false,
            images: [],
            showdate: false,
            documentdata: data.documents,
        };
        this.Getdata();

    }
    Getdata = () => {
        this.props.generalAction(
            API_DOCUMENTLIST,
            {},
            USER.SUCCESS,
            USER.FAILURE,
            (data) => {
                this.setState({ addedImages: data })

                this.setimagedata();
            },
            () => { },
            true

        );
    }
    setimagedata = () => {

        const data = this.state.documentdata;

        let imagearray = [];

        for (var i = 0; i <= this.state.addedImages.length; i++) {
            var documentsource = this.state.addedImages[i].source;
            var documenttitle = this.state.addedImages[i].title;
            var documenterror = this.state.addedImages[i].validation;
            var documentSourceType = this.state.addedImages[i].source_type;

            for (let passdata in data) {

                if (passdata == documentsource) {

                    var documentdata = {};
                    documentdata["title"] = documenttitle;
                    documentdata["images"] = [{ uri: Images.addImage }, ...data[passdata]];
                    documentdata["key"] = documentsource + "[]";
                    documentdata["validation"] = JSON.parse(documenterror);
                    documentdata["source_type"] = documentSourceType;
                    documentdata["isError"] = false;

                    imagearray.push(documentdata);


                    this.setState({ images: JSON.stringify(imagearray) })

                }

            }



        }

    }

    componentDidMount() {
        AppState.addEventListener("change", this._handleAppStateChange);
        const { categories, data } = this.props;
        let arrForDropdown = [];
        categories.map((elem) => {
            if (elem.child_categories_count === "0") {
                arrForDropdown.push({
                    value: elem.parent_category.category_name,
                    id: elem.parent_category.id,
                });
            }
            if (typeof elem.child_categories_count == "number") {
                elem.child_categories.map((el) => {
                    arrForDropdown.push({ value: el.category_name, id: el.id });
                });
            }
        });
        arrForDropdown.push({ value: "cancel" });
        arrForDropdown.unshift({ value: "Categories..." });
        let genderIndex = this.state.genderArr.findIndex(
            (obj) => obj.value == data.gender
        );
        let categoryIndex = arrForDropdown.findIndex(
            (obj) => obj.id == data.category_id
        );
        this.setState(
            {
                categories: arrForDropdown,
                category_id: data.category_id,
                gender: data.gender,
                indexCategory: categoryIndex,
                indexGender: genderIndex == -1 ? 0 : genderIndex,
                selectedCategory: arrForDropdown[categoryIndex].value,
            },
            () => this.setState({ disabled: false })
        );
    }

    componentWillUnmount() {
        AppState.removeEventListener("change", this._handleAppStateChange);
    }

    _handleAppStateChange = (nextAppState) => {
        if (
            this.state.appState.match(/inactive|background/) &&
            nextAppState === "active"
        ) {
            this.cbVerified();
        }
        this.setState({ appState: nextAppState });
    };

    isMobilePhoneValid(email: string) {
        const re = /^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$/im; 

        return re.test(email);
    }

    onSubmit = () => {
        const {
            user_id,
            category_id,
            dob,
            gender,
            qualifitcation,
            about_me,
            licenceImagesArr,
            otherDocumentImagesArray,
            expiryDate,
            mobile_no,
        } = this.state;

        const nameHandler = this.nameHandler.onSubmitForm();
        const titleHandler = this.titleHandler.onSubmitForm();
        const rateHandler = this.rateHandler.onSubmitForm();

        let handleMobileNumber = this.isMobilePhoneValid(mobile_no);

        if (nameHandler && titleHandler && rateHandler && this.isMobilePhoneValid(mobile_no)) {
            let payload = new FormData();
            payload.append("user_id", user_id);
            payload.append("full_name", nameHandler.full_name);
            payload.append("mobile_no", mobile_no);
            payload.append(
                "professional_title",
                titleHandler.professional_title
            );
            payload.append("hourly_rate", rateHandler.hourly_rate);
            payload.append("category_id", category_id);
            !!dob && payload.append("dob", dob);
            payload.append("gender", gender);
            payload.append("qualifitcation", this.qualifitcation.getValue());
            payload.append("about_me", this.aboutMe.getValue());

            payload.append("medical_license_expiry_date", expiryDate);
           
            if (typeof this.props.img === "object") {

                payload.append("image_url", {
                    uri: this.props.img.uri,
                    type: "image/png",
                    name: "medical_license_card_image",
                });
            }
            this.props.onUpdateProfile(API_UPDATE_CONTRACTOR, payload);
        } else {
            this.setState({
                isError: true,
                handleMobileNumber: handleMobileNumber ? true : false,
            });
        }
    };

    showActionSheet = (func) => {
        if (this.props.editable) {
            func.show();
        }
    };

    onDocuments = () => {
        const { data, editable } = this.props;
        const imagesdata = this.state.images

        push("documents", { data, imagesdata });
    };

    onVerified = (token) => {
        let url = `${BASE_URL}user/formrequest/${token}`;
        Linking.canOpenURL(url)
            .then((supported) => {
                if (supported) {
                    Linking.openURL(`${BASE_URL}user/formrequest/${token}`);
                } else {
                    this.showMessage("Error", err);
                }
            })
            .catch((err) => {
                this.showMessage("Error", err);
            });
    };

    cbVerified = () => {
        this.props.generalAction(
            API_GET_CONTRACTOR,
            {
                user_id: this.state.user_id,
            },
            USER.SUCCESS,
            USER.FAILURE,
            (data) => {
                this.setState({ status: data.is_personnel_file_status });
            },
            () => { },
            true
        );

    };

    dropDown(arr, index, stateName, func, callBack) {
        return (
            <React.Fragment>
                <TouchableOpacity
                    style={[styles.categoryStyle, styles.actionSheetView]}
                    onPress={() => this.showActionSheet(func)}
                >
                    <Text
                        style={
                            index == 0
                                ? styles.zeroIndexCategoryStyle
                                : styles.textCategoryStyle
                        }>
                        {arr[index].value}
                    </Text>
                    <Image style={styles.imageIcon} source={icons.ic_expand} />
                </TouchableOpacity>
                <ActionSheet
                    ref={(o) => (func = o)}
                    options={arr.map((elem) => elem.value)}
                    cancelButtonIndex={arr.length - 1}
                    onPress={(i) => {
                        if (i !== arr.length - 1 && i !== 0) {
                            callBack(i);
                        }
                    }}
                />
                {this.state[stateName] === 0 &&
                    this.renderError(
                        `${stateName == "indexCategory" ? "Category" : "Gender"
                        } is required`,
                        { paddingHorizontal: 20 }
                    )}
            </React.Fragment>
        );
    }

    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }

    handleChangeAndroid = (event, selectedDate) => {

        const dateset = moment(selectedDate).format("YYYY-MM-DD");

        const age = moment().diff(moment(dateset), 'years');

        if (age > 17) {

            this.setState({ showdate: false });
            this.setState({ dob: dateset });
            this.setState({ isDetailsEdited: true });

        }
        else {

            Utils.showError("Please select 18 years above");

        }

    }

    showSubmitButtonOnTextChange = () =>
        this.setState({ isDetailsEdited: true });

    render() {
        const {
            firstErr,
            full_name,
            mobile_no,
            email,
            categories,
            professional_title,
            qualifitcation,
            genderArr,
            hourly_rate,
            indexCategory,
            indexGender,
            about_me,
            status,
            token,
            isDetailsEdited,
            selectedCategory,
            disabled,
            category_id,
            handleMobileNumber,
        } = this.state,
            { editable, isDpEdited, data } = this.props;
        const { dateInput, dateText, datePickerStyle, disabledColor } = styles;
        return (
            <ScrollView style={{ flex: 1 }}>
                {status == 0 && (
                      <Text style={{ marginLeft: 10 }}>
                      Your form has been submitted, your profile is awaiting
                      for approval (Pending)
                  </Text>
                )}
                {status === 1 && (
                    <Text style={{ marginLeft: 10 }}>
                        Your form has been submitted, your profile is awaiting
                        for approval (Pending)
                    </Text>
                )}
                {this.heading("Full Name")}
                <View style={styles.eachColumn}>
                    <FormHandler ref={(ref) => (this.nameHandler = ref)}>
                        <Input
                            placeholder={"Full Name..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Full Name"
                            type={INPUT_TYPES.TEXT}
                            identifier="full_name"
                            blurOnSubmit={false}
                            editable={editable}
                            maxLength={25}
                            value={full_name}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={(err) => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </FormHandler>
                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Mobile Number")}
                <View style={styles.eachColumn}>
                    <FormHandler ref={ref => (this.numberHandler = ref)}>
                        <Input
                            placeholder={"Mobile Number..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Mobile Number"
                            type={INPUT_TYPES.NUMBER}
                            identifier="mobile_no"
                            blurOnSubmit={true}
                            editable={editable}
                            maxLength={15}
                            value={mobile_no}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={err =>
                                this.setState({
                                    firstErr: err,
                                    handleMobileNumber: true
                                })
                            }
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </FormHandler>

                    <PhoneInput
                        style={[
                            { marginHorizontal: 16, height: 50, marginTop: 8 },
                        ]}
                        initialValue={mobile_no}
                        onChangePhoneNumber={(text) =>
                            this.setState(
                                { mobile_no: text },
                                this.showSubmitButtonOnTextChange
                            )
                        }
                        
                        disabled={!editable}
                        initialCountry={'us'}
                        ref={(ref) => {
                            this.phone = ref;
                        }}
                    />
                </View>
                {!handleMobileNumber &&
                    this.renderError("Enter the valid Mobile number", {
                        paddingHorizontal: 20,
                    })}
                <Separator style={styles.seperatorStyle} />
                {this.heading("Email")}
                <View style={styles.eachColumn}>
                    <Input
                        placeholder={"Email..."}
                        placeholderTextColor={Colors.textfieldBorder}
                        error="Enter your Email"
                        type={INPUT_TYPES.EMAIL}
                        identifier="email"
                        blurOnSubmit={false}
                        editable={false}
                        value={email}
                        isContainerFlex={true}
                        style={styles.inputStyle}
                        setError={(err) => this.setState({ firstErr: err })}
                        textFieldStyle={
                            !firstErr
                                ? { marginHorizontal: 5 }
                                : styles.textInputStyle
                        }
                        cbOnChangeText={this.showSubmitButtonOnTextChange}
                    />
                </View>
                <Separator style={styles.seperatorStyle} />
                {data.category_id !== null &&
                    data.category_name !== null &&
                    this.heading("Category ")}
                {data.category_id !== null && data.category_name !== null && (
                    <View style={styles.eachColumn}>
                        <Input
                            placeholder={selectedCategory}
                            placeholderTextColor={"#606060"}
                            error="Enter your Email"
                            type={INPUT_TYPES.EMAIL}
                            identifier="email"
                            blurOnSubmit={false}
                            editable={disabled}
                            value={selectedCategory}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={(err) => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </View>
                )}
                {data.category_id == null &&
                    data.category_name == null &&
                    this.dropDown(
                        categories,
                        indexCategory,
                        "indexCategory",
                        this.category,
                        (i) => {
                            this.setState({
                                indexCategory: i,
                                category_id: categories[i].id,
                                isDetailsEdited: true,
                                selectedCategory: categories[i].value,
                            });
                        }
                    )}
                <Separator style={styles.seperatorStyle} />
                {this.heading("Professional Title")}
                <View style={styles.eachColumn}>
                    <FormHandler ref={(ref) => (this.titleHandler = ref)}>
                        <Input
                            placeholder={"Professional Title..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Professional Title"
                            type={INPUT_TYPES.TEXT}
                            identifier="professional_title"
                            blurOnSubmit={false}
                            editable={editable}
                            maxLength={25}
                            value={professional_title}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={(err) => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </FormHandler>
                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Self Introduction")}
                <View style={styles.eachColumn}>
                    <Input
                        ref={(ref) => (this.aboutMe = ref)}
                        placeholder={"Self Introduction..."}
                        placeholderTextColor={Colors.textfieldBorder}
                        error="Enter your Self Introduction"
                        type={INPUT_TYPES.TEXT}
                        identifier="about_me"
                        blurOnSubmit={false}
                        editable={editable}
                        maxLength={150}
                        value={about_me}
                        multiline={true}
                        numberOfLines={3}
                        isContainerFlex={true}
                        style={styles.inputStyle}
                        setError={(err) => this.setState({ firstErr: err })}
                        textFieldStyle={
                            !firstErr
                                ? { marginHorizontal: 5 }
                                : styles.textInputStyle
                        }
                        cbOnChangeText={this.showSubmitButtonOnTextChange}
                    />
                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Date of Birth")}
                <View style={styles.eachColumn}>
                   
                    {Utils.isPlatformAndroid ?
                        <TouchableOpacity style={styles.viewstyle}
                            onPress={showdate => {
                                this.setState({ showdate: true });
                            }}>

                            <View style={[styles.textstyleinput  ]}>
                                <TextInput
                                    style={styles.inputStyle}
                                    editable={false}
                                    selectTextOnFocus={false}
                                    value={this.state.dob}
                                />
                              
                            </View>
                        </TouchableOpacity> :
                        <DateTimePicker
                        style={{
                            dateInput,
                            dateText,
                            datePickerStyle,
                            disabledColor,
                        }}
                        date={this.state.dob}
                        dateTime={"date"}
                        editable={!editable}
                        title={"Date of Birth..."}
                        maxDate={new Date(Date.now() + 10 * 60 * 1000)}
                        stateName={"dob"}
                        onChangeState={({ dob }) => {
                            let currentDate = moment().format("YYYY-MM-DD");
                            if (dob < currentDate) {
                                this.setState({ dob, isDetailsEdited: true });
                            }
                        }}
                    />
                    }
                    
                    {this.state.showdate == true ?
                    <DateTime
                        style={{
                            borderBottomWidth: 1,
                            borderColor: Colors.textfieldBorder,
                            width: Platform.OS ? 345 : 350

                        }}
                        date={this.state.dob}
                        mode={'date'}
                        dateFormat="YYYY-MM-DD"
                        value={new Date()}
                        maximumDate={new Date()}
                        confirmBtnText="Confirm"
                        cancelBtnText="Cancel"
                        is24Hour={true}
                        customStyles={{
                            dateInput: {
                                borderWidth: 0,
                                justifyContent: "flex-start",
                                alignItems: "flex-start",
                                paddingTop: 6,
                                paddingLeft: 10
                            },
                            dateText: {
                                color: "#241332"
                            }
                        }}
                        onChange={this.handleChangeAndroid}

                    />:null}

                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Gender ")}
                {this.dropDown(
                    genderArr,
                    indexGender,
                    "indexGender",
                    this.gender,
                    (i) =>
                        this.setState({
                            gender: genderArr[i].value,
                            indexGender: i,
                            isDetailsEdited: true,
                        })
                )}
                <Separator style={styles.seperatorStyle} />
                {this.heading("Qualification")}
                <View style={styles.eachColumn}>
                    <Input
                        ref={(ref) => (this.qualifitcation = ref)}
                        placeholder={"Qualification..."}
                        placeholderTextColor={Colors.textfieldBorder}
                        error="Enter your Qualification"
                        type={INPUT_TYPES.TEXT}
                        identifier="qualifitcation"
                        blurOnSubmit={false}
                        editable={editable}
                        maxLength={25}
                        value={qualifitcation}
                        isContainerFlex={true}
                        style={styles.inputStyle}
                        setError={(err) => this.setState({ firstErr: err })}
                        textFieldStyle={
                            !firstErr
                                ? { marginHorizontal: 5 }
                                : styles.textInputStyle
                        }
                        cbOnChangeText={this.showSubmitButtonOnTextChange}
                    />
                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Hour Rate")}
                <View style={styles.eachColumn}>
                    <FormHandler ref={(ref) => (this.rateHandler = ref)}>
                        <Input
                            placeholder={"Hour Rate..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Hour Rate"
                            type={INPUT_TYPES.NUMBER}
                            identifier="hourly_rate"
                            blurOnSubmit={true}
                            editable={editable}
                            maxLength={10}
                            value={hourly_rate}
                            isContainerFlex={true}
                            style={styles.inputStyle}
                            setError={(err) => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </FormHandler>
                </View>
                <Separator style={styles.seperatorStyle} />
                {this.heading("Documents")}
                <TouchableOpacity
                    style={[styles.categoryStyle, styles.actionSheetView]}
                    onPress={this.onDocuments}
                >
                    <Text
                        numberOfLines={2}
                        style={[
                            styles.descriptionDocumentStyle,
                            { width: "80%" },
                        ]}
                    >
                        View your documents
                    </Text>
                    <Image
                        style={styles.imageIcon}
                        source={icons.expand_farward}
                    />
                </TouchableOpacity>
                <Separator style={styles.seperatorStyle} />
                {this.reviewComments()}
                <Separator
                    style={[styles.seperatorStyle, { marginBottom: 60 }]}
                />
                {editable && (isDetailsEdited || isDpEdited) && (
                    <AppButton
                        buttonTitle="Submit"
                        style={styles.footerStyle}
                        btnColor={colors.cardColor}
                        onPress={this.onSubmit}
                    />
                )}
            </ScrollView>
        );
    }

    tapOnHeading(label, callBack) {
        return (
            <TouchableOpacity
                style={{ paddingVertical: 20 }}
                onPress={callBack}
            >
                <Text style={styles.boldText}>{label}</Text>
            </TouchableOpacity>
        );
    }

    reviewComments() {
        const { reviewComments } = this.state;
        if (this.props.commentsList.length == 0) return null;
        return (
            <View style={{ marginBottom: 15 }}>
                {this.tapOnHeading("Review Comments", () =>
                    this.setState({
                        reviewComments: !reviewComments,
                    })
                )}
                {reviewComments ? (
                    <FlatListHandler
                        data={this.props.commentsList}
                        renderItem={(item) => <CommentCard data={item} />}
                    />
                ) : null}
            </View>
        );
    }
}

const mapStateToProps = ({ categories }) => {
    return {
        categories: categories.data,
    };
};

const actions = { generalAction };

export default connect(mapStateToProps, actions)(Contractor);