import React, { Component, Fragment } from "react";
import {
    View,
    Text,
    ScrollView,
    Image,
    TouchableWithoutFeedback,
    TouchableOpacity
} from "react-native";
import {
    Separator,
    AppButton,
    TextLabel,
    FormHandler,
    Input,
    DateTimePicker,
    CommentCard,
    FlatListHandler
} from "../../components";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import { pop, push, popToTop } from "../../services/NavigationService";
import { icons, colors } from "../../assets";
import { connect } from "react-redux";
import Colors from "../../services/Colors";
import { API_UPDATE_FACILITY } from "../../services/WebService";
import styles from "./styles";
import moment from "moment";
import PhoneInput from "react-native-phone-input";

class Facility extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            firstErr: false,
            isError: false,
            full_name: props.data.full_name,
            director_full_name: props.data.director_name,
            user_id: props.data.id,
            email: props.data.email,
            image_url: props.img,
            dob: props.data.dob,
            mobile_no: props.data.mobile_no,
            ein_number: props.data.ein_number,
            latitude: props.data.latitude,
            longitude: props.data.longitude,
            address: props.data.address || "Pick location...",
            isDetailsEdited: false,
            handleMobileNumber: true,
            handleEinNumber: false,
            reviewComments: false,
            showdate: false,

        };
    }

    isMobilePhoneValid(email: string) {
       // const re = /^[+]?(1\-|1\s|1|\d{3}\-|\d{3}\s|)?((\(\d{3}\))|\d{3})(\-|\s)?(\d{3})(\-|\s)?(\d{4})$/;
       const re = /^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$/im; 
        return re.test(email);
    }

    onSubmit() {
        const { user_id, mobile_no, latitude, longitude, address } = this.state;
        const { img } = this.props;
        const nameHandler = this.nameHandler.onSubmitForm();
        // const numberHandler = this.numberHandler.onSubmitForm();
        const nameHandler2 = this.nameHandler2.onSubmitForm();
        const numberHandler2 = this.numberHandler2.onSubmitForm();
        let regexStr = /^[0-9]\d{8,8}(,\d{8,8})?$/;

        // let handleMobileNumber =
        //     numberHandler &&
        //     numberHandler.mobile_no &&
        //     this.isMobilePhoneValid(numberHandler.mobile_no);

        let handleMobileNumber = this.isMobilePhoneValid(mobile_no);

        let handleEinNumber =
            numberHandler2 &&
            numberHandler2.ein_number &&
            regexStr.test(numberHandler2.ein_number);
        if (
            nameHandler &&
            nameHandler2 &&
            numberHandler2 &&
            latitude &&
            longitude &&
            handleMobileNumber &&
            handleEinNumber
        ) {
            this.setState({ isError: false });
            let payload = new FormData();

            payload.append("full_name", nameHandler.full_name);
            payload.append("user_id", user_id);
            payload.append("mobile_no", mobile_no);
            payload.append("ein_number", numberHandler2.ein_number);
            payload.append("latitude", latitude);
            payload.append("longitude", longitude);
            payload.append("address", address);
            payload.append("director_name", nameHandler2.director_full_name);

            if (typeof img === "object") {
                payload.append("image_url", {
                    uri: img.uri,
                    type: "image/png",
                    name: "medical_license_card_image"
                });
            }
            this.props.onUpdateProfile(API_UPDATE_FACILITY, payload);
        } else {
            this.setState({
                isError: true,
                handleMobileNumber: handleMobileNumber ? true : false,
                handleEinNumber: numberHandler2 == undefined || handleEinNumber ? true : false
            });
        }
    }

    onLocation = editable => {
        if (editable) {
            push("locationPicker", {
                cbOnLocationPicked: this.cbOnLocationPicked
            });
        }
    };

    cbOnLocationPicked = objLoc => {
        if (objLoc.address.length) {
            this.setState({
                latitude: objLoc.lat,
                longitude: objLoc.lng,
                address: objLoc.address,
                isDetailsEdited: true
            });
        }
    };

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }

    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    datePicker(title, icon, dateTime, editable) {
        const { dateInput, dateText, datePickerStyle, disabledColor } = styles;
        return (
            <DateTimePicker
                style={{ dateInput, dateText, datePickerStyle, disabledColor }}
                date={this.state.dob}
                dateTime={"date"}
                editable={!editable}
                title={"Date of Birth..."}
                isError={this.state.isError && !this.state.dob}
                error={"Date of Birth is required"}
                stateName={"dob"}
                // maxDate={new Date(Date.now() + (10 * 60 * 1000))}
                onChangeState={({ dob }) => {
                    let currentDate = moment().format("YYYY-MM-DD");
                    if (dob < currentDate) {
                        this.state.isDetailsEdited = true;
                        this.setState({ dob });
                    }
                }}
            />
        );
    }

    locationCard(editable) {
        return (
            <Fragment>
                <TouchableWithoutFeedback
                    onPress={() => this.onLocation(editable)}
                >
                    <Text
                        style={
                            this.state.latitude === 0
                                ? styles.txtLocEmpty
                                : styles.txtLocPicked
                        }
                    >
                        {this.state.address}
                    </Text>
                </TouchableWithoutFeedback>
                {this.state.latitude === null &&
                    this.renderError("Location is required", {
                        paddingHorizontal: 20
                    })}
            </Fragment>
        );
    }

    showSubmitButtonOnTextChange = () =>
        this.setState({ isDetailsEdited: true });

    render() {
        const {
            firstErr,
            full_name,
            email,
            mobile_no,
            ein_number,
            isDetailsEdited,
            handleMobileNumber,
            handleEinNumber,
            director_full_name
        } = this.state,
            { editable, isDpEdited, commentsList } = this.props;

        return (
            <Fragment>
                <ScrollView style={{ flex: 1 }}>
                    {this.heading("Facility Name")}
                    <View style={styles.eachColumn}>
                        <FormHandler ref={ref => (this.nameHandler = ref)}>
                            <Input
                                placeholder={"Facility Name..."}
                                placeholderTextColor={Colors.textfieldBorder}
                                error="Enter your Name"
                                type={INPUT_TYPES.TEXT}
                                identifier="full_name"
                                blurOnSubmit
                                style={styles.inputStyle}
                                editable={editable}
                                maxLength={25}
                                value={full_name}
                                isContainerFlex={true}
                                setError={err =>
                                    this.setState({ firstErr: err })
                                }
                                textFieldStyle={
                                    !firstErr
                                        ? { marginHorizontal: 5 }
                                        : styles.textInputStyle
                                }
                                cbOnChangeText={
                                    this.showSubmitButtonOnTextChange
                                }
                            />
                        </FormHandler>
                    </View>
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("Director's Name")}
                    <View style={styles.eachColumn}>
                        <FormHandler ref={ref => (this.nameHandler2 = ref)}>
                            <Input
                                placeholder={"Director's Name..."}
                                placeholderTextColor={Colors.textfieldBorder}
                                error="Enter your Director's Name"
                                type={INPUT_TYPES.TEXT}
                                identifier="director_full_name"
                                blurOnSubmit
                                style={styles.inputStyle}
                                editable={editable}
                                maxLength={25}
                                value={director_full_name}
                                isContainerFlex={true}
                                setError={err =>
                                    this.setState({ firstErr: err })
                                }
                                textFieldStyle={
                                    !firstErr
                                        ? { marginHorizontal: 5 }
                                        : styles.textInputStyle
                                }
                                cbOnChangeText={
                                    this.showSubmitButtonOnTextChange
                                }
                            />
                        </FormHandler>
                    </View>
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("Phone Number")}
                    <View style={styles.eachColumn}>
                        {/* <FormHandler ref={ref => (this.numberHandler = ref)}>
                            <Input
                                placeholder={"Phone Number..."}
                                placeholderTextColor={Colors.textfieldBorder}
                                error="Enter your Phone Number"
                                type={INPUT_TYPES.NUMBER}
                                identifier="mobile_no"
                                blurOnSubmit={true}
                                style={styles.inputStyle}
                                editable={editable}
                                maxLength={15}
                                value={mobile_no}
                                isContainerFlex={true}
                                setError={err =>
                                    this.setState({
                                        firstErr: err,
                                        handleMobileNumber: true
                                    })
                                }
                                textFieldStyle={
                                    !firstErr
                                        ? { marginHorizontal: 5 }
                                        : styles.textInputStyle
                                }
                                cbOnChangeText={
                                    this.showSubmitButtonOnTextChange
                                }
                            />
                        </FormHandler> */}
                        <PhoneInput
                            style={[{ marginHorizontal: 16, height: 50, marginTop: 8 }]}
                            initialValue={mobile_no}
                            onChangePhoneNumber={text =>
                                this.setState({ mobile_no: text }, this.showSubmitButtonOnTextChange)
                            }
                            disabled={!editable}
                            initialCountry={'us'}
                            ref={ref => {
                                this.phone = ref;
                            }}
                        />
                    </View>
                    <Separator style={styles.seperatorStyle} />
                    {!handleMobileNumber &&
                        this.renderError("Enter the valid Phone number", {
                            paddingHorizontal: 20
                        })}

                    {this.heading("EIN Number")}
                    <View style={styles.eachColumn}>
                        <FormHandler ref={ref => (this.numberHandler2 = ref)}>
                            <Input
                                placeholder={"EIN Number..."}
                                placeholderTextColor={Colors.textfieldBorder}
                                error="Enter your EIN Number"
                                type={INPUT_TYPES.NUMBER}
                                identifier="ein_number"
                                blurOnSubmit={true}
                                style={styles.inputStyle}
                                editable={editable}
                                maxLength={15}
                                value={ein_number}
                                isContainerFlex={true}
                                setError={err =>
                                    this.setState({
                                        firstErr: err,
                                        handleEinNumber: true
                                    })
                                }
                                textFieldStyle={
                                    !firstErr
                                        ? { marginHorizontal: 5 }
                                        : styles.textInputStyle
                                }
                                cbOnChangeText={
                                    this.showSubmitButtonOnTextChange
                                }
                            />
                        </FormHandler>
                    </View>
                    {!handleEinNumber &&
                        this.renderError("Enter the valid EIN number", {
                            paddingHorizontal: 20
                        })}
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("Email")}
                    <View style={styles.eachColumn}>
                        <Input
                            placeholder={"Email..."}
                            placeholderTextColor={Colors.textfieldBorder}
                            error="Enter your Email"
                            type={INPUT_TYPES.EMAIL}
                            identifier="old_password"
                            blurOnSubmit
                            style={styles.inputStyle}
                            editable={false}
                            maxLength={25}
                            value={email}
                            isContainerFlex={true}
                            setError={err => this.setState({ firstErr: err })}
                            textFieldStyle={
                                !firstErr
                                    ? { marginHorizontal: 5 }
                                    : styles.textInputStyle
                            }
                            cbOnChangeText={this.showSubmitButtonOnTextChange}
                        />
                    </View>
                    <Separator style={styles.seperatorStyle} />
                    {/*this.heading("Date of Birth")*/}
                    {/*this.datePicker(
            "Date of Birth...",
            icons.ic_expand,
            "date",
            editable
          )*/}
                    <Separator style={styles.seperatorStyle} />
                    {this.heading("Facility Location")}
                    {this.locationCard(editable)}
                    <Separator style={styles.seperatorStyle} />
                    {this.reviewComments()}
                    <Separator
                        style={[styles.seperatorStyle, { marginBottom: 60 }]}
                    />
                </ScrollView>
                {editable && (isDetailsEdited || isDpEdited) && (
                    <AppButton
                        buttonTitle="Submit"
                        style={styles.footerStyle}
                        btnColor={colors.cardColor}
                        onPress={() => {
                            this.onSubmit();
                        }}
                    />
                )}
            </Fragment>
        );
    }

    tapOnHeading(label, callBack) {
        return (
            <TouchableOpacity
                style={{ paddingVertical: 20 }}
                onPress={callBack}
            >
                <Text style={styles.boldText}>{label}</Text>
            </TouchableOpacity>
        );
    }

    reviewComments() {
        const { reviewComments } = this.state;
        if (this.props.commentsList.length == 0) return null;
        return (
            <View style={{ marginBottom: 15 }}>
                {this.tapOnHeading("Review Comments", () =>
                    this.setState({
                        reviewComments: !reviewComments
                    })
                )}
                {reviewComments ? (
                    <FlatListHandler
                        data={this.props.commentsList}
                        renderItem={item => <CommentCard data={item} />}
                    />
                ) : null}
            </View>
        );
    }
}

mapStateToProps = state => {
    return {};
};

const actions = {};

export default connect(mapStateToProps, actions)(Facility);
