import { StyleSheet, Platform } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";

export default StyleSheet.create({
    headerTitle: {
        color: colors.WhiteColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    container: {
        ...Platform.select({
            ios: {
                zIndex: 999
            }
        })
    },
    topImageBackground: {
        height: 62.5,
        width: "100%",
        backgroundColor: "#08548c",
        zIndex: 999
    },
    imgStyle: {
        width: 100,
        height: 100,
        borderRadius: 50,
        borderColor: colors.WhiteColor,
        borderWidth: 2,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        marginTop: 10,
        alignSelf: "center",
        backgroundColor: "white",
        zIndex: 999
    },
    
    iconStyle: {
        width: 33,
        height: 33,
        borderRadius: 16.5,
        position: "absolute",
        bottom: 0,
        right: 0,
        zIndex: 999
    },
    avatarStyle: {
        position: "absolute",
        alignSelf: "center",
        ...Platform.select({
            ios: {
                zIndex: 999
            }
        })
    },
    profileSec: {
        backgroundColor: "#f8f8f8",
        flex: 1,
        paddingTop: 50
    },
    footerStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "100%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    },
    boldText: {
        ...UIFont.font(fonts.semiBold, 12, colors.BlackColor),
        marginTop: 10,
        marginBottom: -10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    eachColumn: {
        flexDirection: "column"
    },
    textInputStyle: {
        marginHorizontal: 10,
        color: "black"
    },
    seperatorStyle: {
        backgroundColor: "#dde3f6"
    },
    categoryStyle: {
        width: "100%",
        flexDirection: "row",
        alignItems: "center"
    },
    actionSheetView: {
        flex: 1,
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin
    },
    zeroIndexCategoryStyle: {
        ...UIFont.font(fonts.regular, 18, Colors.textfieldBorder),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    textCategoryStyle: {
        ...UIFont.font(fonts.regular, 18, "#606060"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin
    },
    inputStyle: {
        ...UIFont.font(fonts.regular, 18, "#606060")
    },
    descriptionDocumentStyle: {
        ...UIFont.font(fonts.regular, 13, "#606060"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    datePickerStyle: {
        marginHorizontal: 10,
        width: Platform.OS ? 370 : 395
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        paddingLeft: 10
    },
    dateText: {
        color: "#606060",
        fontSize: 18
    },
    locationWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        marginTop: 10,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.4,
        shadowRadius: 2,
        shadowOffset: {
            height: 2,
            width: 2
        }
    },
    txtLocPicked: {
        ...UIFont.font(fonts.regular, 18, "#606060"),
        textAlign: "left",
        padding: Metrics.smallMargin,
        paddingLeft: Metrics.baseMargin,
        flex: 1,
        marginTop: Platform.OS && 10,
        marginHorizontal: 5
    },
    txtLocEmpty: {
        ...UIFont.font(fonts.regular, 18, Colors.textfieldBorder),
        textAlign: "left",
        padding: Metrics.smallMargin,
        paddingLeft: Metrics.baseMargin,
        flex: 1,
        marginTop: Platform.OS && 10,
        marginHorizontal: 5
    },
    error: {
        ...UIFont.font(fonts.regular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    disabledColor: {
        backgroundColor: "#f8f8f8"
    },

    passwordContainer: {
        flexDirection: 'row',
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder,
        paddingBottom: 10,
    },
    textstyleinput: {
        marginHorizontal: 15,
    },
    viewstyle: {
        flex: 1,
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",

    },
    ImageStyle: {
        padding: 10,
        margin: 5,
        height: 30,
        width: 30,
        resizeMode: 'stretch',
        alignItems: 'center',
    },
});
