import React, { Component } from "react";
import { connect } from "react-redux";
import { WithFetching } from "../../HOC";
import {
    View,
    Text,
    StyleSheet,
    ScrollView,
    FlatList,
    TouchableOpacity,
    TextInput,
    Image as ImageRN
} from "react-native";
import { Separator, AppButton, TextLabel, Rate, Input } from "../../components";
import { pop, push, popToTop, reset } from "../../services/NavigationService";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import {
    CONTRACTOR_RATE_TO_FACILITY,
    FACILITY_RATE_TO_CONTRACTOR
} from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import Utils from "../../Utils";

class Rating extends Component {
    constructor(props) {
        super(props);

        this.state = {
            radioNo: false,
            radioYes: true,
            comment: "",
            userType: props.navigation.getParam("userType"),
            firstRating: 0,
            secondRating: 0,
            thirdRating: 0,
            fourthRating: 0,
            isError: false
        };
    }

    onSubmit = () => {
        const {
            firstRating,
            secondRating,
            thirdRating,
            fourthRating,
            comment
        } = this.state;
        if (firstRating && secondRating && thirdRating && fourthRating) {
            this.requestRate();
        } else {
            this.setState({ isError: true });
        }
    };

    requestRate = (formResponse, formResponse2, formResponse3) => {
        this.props.cbShowLoader(true);
        const {
                firstRating,
                secondRating,
                thirdRating,
                fourthRating,
                comment,
                radioYes
            } = this.state,
            { navigation } = this.props;
        let identify = navigation.getParam("userType") == "facility",
            payload = new FormData();
        payload.append("contract_id", navigation.getParam("contract_id"));
        payload.append("contractor_id", navigation.getParam("contractor_id"));
        payload.append("facility_id", navigation.getParam("facility_id"));
        payload.append(
            identify ? "punctuality_id" : "work_environment_id",
            identify ? 5 : 1
        );
        payload.append(
            identify ? "punctuality_rate_value" : "work_environment_rate_value",
            firstRating
        );
        payload.append(
            identify ? "appearance_id" : "shift_on_boarding_id",
            identify ? 6 : 2
        );
        payload.append(
            identify ? "appearance_rate_value" : "shift_on_boarding_rate_value",
            secondRating
        );
        payload.append(
            identify ? "productivity_id" : "communication_id",
            identify ? 7 : 3
        );
        payload.append(
            identify ? "productivity_rate_value" : "communication_rate_value",
            thirdRating
        );
        payload.append(
            identify ? "dependability_id" : "on_time_payment_id",
            identify ? 8 : 4
        );
        payload.append(
            identify
                ? "dependability_rate_value"
                : "on_time_payment_rate_value",
            fourthRating
        );
        payload.append("comments", comment);
        !identify &&
            payload.append("is_work_again_there", radioYes ? "yes" : "no");
        this.props.generalAction(
            identify
                ? FACILITY_RATE_TO_CONTRACTOR
                : CONTRACTOR_RATE_TO_FACILITY,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.onRequestRateSuccess,
            this.onRequestRateFailure
        );
    };

    onRequestRateSuccess = () => {
        const { navigation } = this.props;
        this.props.cbShowLoader(false);
        let identify = navigation.getParam("userType") == "facility";
        if (identify) {
            this.successMsg("");
            reset("myShiftsContracts", { tab: true });
        } else {
            this.successMsg("");
            reset("mySchedule", { tab: true });
        }
    };

    onRequestRateFailure = err => {
        Utils.showError(err);
        this.props.cbShowLoader(false);
    };

    successMsg = user => {
        Utils.showMessage(
            "Success",
            `Rating submitted successfully.`,
            "success"
        );
    };

    renderError(err) {
        if (this.state.isError) {
            return <Text style={styles.error}>{err}</Text>;
        }
    }

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }

    radioBtn(status, label, CallBack) {
        return (
            <TouchableOpacity onPress={CallBack} style={styles.imgContainer}>
                <ImageRN
                    source={status ? icons.radioCheck : icons.radioUncheck}
                />
                <Text
                    style={status ? styles.activeStyle : styles.inActiveStyle}
                >
                    {label}
                </Text>
            </TouchableOpacity>
        );
    }

    radioWithLabel() {
        const { radioYes, radioNo } = this.state;
        return (
            <View style={styles.radioWithLabelContainer}>
                <Text style={styles.labelStyle}>
                    Would you work there again?
                </Text>
                <View style={styles.radioBtnContainer}>
                    {this.radioBtn(radioYes, "Yes", () =>
                        this.setState({ radioYes: true, radioNo: false })
                    )}
                    {this.radioBtn(radioNo, "No", () =>
                        this.setState({ radioYes: false, radioNo: true })
                    )}
                    <View style={{ flex: 1 }} />
                </View>
            </View>
        );
    }

    render() {
        const {
                userType,
                firstRating,
                secondRating,
                thirdRating,
                fourthRating
            } = this.state,
            identify = userType == "facility";

        return (
            <View style={{ flex: 1 }}>
                <ScrollView
                    style={{ backgroundColor: colors.HeaderColor, flex: 1 }}
                >
                    <Rate
                        label={identify ? "Punctuality" : "Work Environment"}
                        eachRating={firstRating}
                        cbSelectedStar={firstRating =>
                            this.setState({ firstRating, isError: false })
                        }
                    />
                    <Rate
                        label={identify ? "Appearance" : "Shift On-boarding"}
                        eachRating={secondRating}
                        cbSelectedStar={secondRating =>
                            this.setState({ secondRating, isError: false })
                        }
                    />
                    <Rate
                        label={identify ? "Productivity" : "Communication"}
                        eachRating={thirdRating}
                        cbSelectedStar={thirdRating =>
                            this.setState({ thirdRating, isError: false })
                        }
                    />
                    <Rate
                        label={identify ? "Dependability" : "On time Payment "}
                        eachRating={fourthRating}
                        cbSelectedStar={fourthRating =>
                            this.setState({ fourthRating, isError: false })
                        }
                    />
                    {this.renderError("All ratings are required")}
                    {!identify ? this.radioWithLabel() : null}
                    <TextInput
                        placeholder="Add Comment"
                        multiline={true}
                        onChangeText={comment => this.setState({ comment })}
                        value={this.state.comment}
                        style={[styles.commentStyle, { marginBottom: 150 }]}
                    />
                </ScrollView>
                <AppButton
                    buttonTitle="SUBMIT"
                    style={styles.btnStyle}
                    btnColor={colors.cardColor}
                    onPress={() => {
                        this.onSubmit();
                    }}
                />
            </View>
        );
    }
}

const styles = StyleSheet.create({
    labelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor)
    },
    btnStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "100%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    },
    radioWithLabelContainer: {
        width: "100%",
        paddingHorizontal: 20,
        paddingVertical: 25
    },
    radioBtnContainer: {
        flexDirection: "row",
        marginTop: 20
    },
    imgContainer: {
        flex: 1,
        flexDirection: "row"
    },
    activeStyle: {
        ...UIFont.font(fonts.regular, 14, colors.tertiary),
        marginHorizontal: 10
    },
    inActiveStyle: {
        ...UIFont.font(fonts.regular, 14, colors.LightGreyColor),
        marginHorizontal: 10
    },
    commentStyle: {
        height: 150,
        textAlignVertical: "top",
        marginHorizontal: 20,
        padding: 10,
        marginTop: 10,
        backgroundColor: "white"
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        padding: 20,
        alignSelf: "flex-start"
    }
});

const actions = { generalAction };

export default connect(null, actions)(WithFetching(Rating));
