import React, { Component } from "react";
import { connect } from "react-redux";
import { WithFetching } from "../../HOC";
import {
    View,
    Text,
    StyleSheet,
    ScrollView,
    FlatList,
    TouchableOpacity,
    TextInput,
    Image as ImageRN
} from "react-native";
import {
    CommentCard,
    FlatListHandler,
    TextLabel,
    Rate,
    Input
} from "../../components";
import { pop, push, popToTop, reset } from "../../services/NavigationService";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import { API_GET_COMMENTS_LIST } from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import Utils from "../../Utils";

class RatingAndComments extends Component {
    constructor(props) {
        super(props);

        this.state = {
            user_id: props.navigation.getParam("user_id"),
            rating: 0,
            commentsList: [],
            isFetching: false
        };
    }

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { user_id } = this.state;

        this.setState({ isFetching: true });
        this.props.generalAction(
            API_GET_COMMENTS_LIST,
            { user_id },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            commentsList => {
                let rating = 0;
                commentsList.map(elem => {
                    rating += +elem.comment_rating;
                });

                this.setState({ commentsList, rating, isFetching: false });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }

    render() {
        const { rating, commentsList, isFetching } = this.state;

        return (
            <View style={{ backgroundColor: colors.HeaderColor, flex: 1 }}>
                <Rate
                    label={"Total Rating"}
                    eachRating={rating}
                    cbSelectedStar={() => {}}
                />
                {this.heading("Comments")}
                <FlatListHandler
                    isFetching={isFetching}
                    refreshing={isFetching}
                    onRefresh={() => this.fetchData()}
                    fetchRequest={() => this.fetchData()}
                    data={commentsList}
                    renderItem={item => <CommentCard data={item} />}
                />
            </View>
        );
    }
}

const styles = StyleSheet.create({
    boldText: {
        ...UIFont.font(fonts.regular, 18, colors.BlackColor),
        marginTop: 10,
        marginBottom: 10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    }
});

const actions = { generalAction };

export default connect(null, actions)(WithFetching(RatingAndComments));
