import React, { Component } from "react";
import { connect } from "react-redux";
import { WithFetching } from "../../HOC";
import {
    View,
    Text,
    StyleSheet,
    ScrollView,
    FlatList,
    TouchableOpacity,
    TextInput,
    TouchableWithoutFeedback,
    Image as ImageRN
} from "react-native";
import {
    DetailCard,
    Separator,
    CommentCard,
    TextLabel,
    ReusableModal,
    Rate,
    Input,
    Container,
    AppButton,Supporticon
} from "../../components";
import { InfoModal, InfoMileage } from "../../appComponents/ModalComponents";
import { pop, push, popToTop, reset } from "../../services/NavigationService";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import { API_REJECTED_INVITATION } from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import Utils from "../../Utils";
import styles from "./styles";
import moment from "moment";

class RejectedDetail extends Component {
    constructor(props) {
        super(props);
        this.state = {
            data: {},
            maxRadius: 0,
            modal: ""
        };
    }

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        const { user, navigation } = this.props,
            { contract_id, invitation_id } = navigation.route.params;

        this.setState({ isFetching: true });
        this.props.generalAction(
            API_REJECTED_INVITATION,
            {
                user_id: user.id,
                user_type: "contractor",
                contract_id,
                invitation_id
            },
            DUMP.SUCCESS,
            DUMP.FAILURE,
            data => {
                this.setState({
                    isFetching: false,
                    data: data[0],
                    maxRadius: data[0].maximum_radius
                });
            },
            () => this.setState({ isFetching: false }),
            true,
            isConcat
        );
    };

    heading(label) {
        return (
            <TextLabel
                type="medium"
                size="medium"
                color={"black"}
                style={styles.boldText}
            >
                {label}
            </TextLabel>
        );
    }

    paragraph(para, style, numberOfLines) {
        return (
            <Text style={style} numberOfLines={numberOfLines}>
                {para}
            </Text>
        );
    }

    renderBidAmount(bid_amount) {
        return (
            <View
                style={{
                    flexDirection: "row",
                    justifyContent: "space-between",
                    padding: 10,
                    borderRadius: 3,
                    borderColor: "#dde3f6",
                    borderWidth: 1,
                    margin: 20
                }}
            >
                <Text style={styles.bidText}>Bid Amount</Text>
                <Text style={styles.rateText}>${bid_amount}</Text>
            </View>
        );
    }

    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.setState({ boo: false });
        this.Modal.setModalVisible(false);
    };

    renderModal = () => {
        const { modal, boo, data, maxRadius } = this.state;
        const {
            amount,
            contract_type,
            cost_per_mile,
            shift_end_time,
            shift_start_time,
            contract_invitations,
            hourly_pay_rate,
            total_hours
        } = data;
        let rate =
            hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0,
                    data.hourly_pay_rate.indexOf(".")
                );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * total_hours;
        let totalAmount = data.cost_per_mile
            ? bidAmount + +data.cost_per_mile * maxRadius
            : bidAmount;

        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={styles.modalContainer}>
                        <View style={styles.modalInner}>
                            {modal == "info" && (
                                <InfoModal
                                    costMile={cost_per_mile}
                                    maxRadius={maxRadius}
                                />
                            )}
                            {modal == "mileage" && (
                                <InfoMileage
                                    rate={rate}
                                    contract_type={contract_type}
                                    diffTime={total_hours}
                                />
                            )}
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };
    _onPressRequestAgain = () => {
        const { data } = this.state;
        const { contract_type } = data;
        let route = contract_type === 'Contract' ? 'AddContractTiming' : 'AddShiftTiming';
        push(route, { data })
    }

    render() {
        const { data } = this.state;
        if (Object.keys(data).length <= 0) return null;

        return (
            <Container>
                <ScrollView style={{ backgroundColor: "#f8f8f8" }}>
                    <DetailCard
                        data={data}
                        pending={"Rejected"}
                        cbMileage={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("info")
                        }
                        cbTotal={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("mileage")
                        }
                    />
                    <Separator style={styles.separatorStyle} />
                    {this.heading("Description")}
                    {this.paragraph(data.description, styles.descriptionStyle, 2)}
                    {data.bid_amount !== null && data.bid_amount !== "0.00" ? (
                        <Separator style={styles.separatorStyle} />
                    ) : null}
                    {data.bid_amount !== null && data.bid_amount !== "0.00"
                        ? this.renderBidAmount(data.bid_amount)
                        : null}
                    <Separator style={styles.separatorStyle} />
                    <CommentCard data={{ item: data }} />
                    {this.renderModal()}
                </ScrollView>
               
                <Supporticon
                    clickBtn={() => push("Support")} />
            </Container>
        );
    }
}

const actions = { generalAction };

const mapStateToProps = ({ user }) => ({
    user: user.data
});

export default connect(mapStateToProps, actions)(WithFetching(RejectedDetail));
