import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import { Metrics } from "../../services";

export default StyleSheet.create({
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#f8f8f8",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    separatorStyle: {
        backgroundColor: "#dde3f6",
        marginHorizontal: 20,
        marginVertical: 10
    },
    descriptionStyle: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, colors.BlackColor),
        marginBottom: 10,
        marginHorizontal: 20,
        lineHeight: 22,
        letterSpacing: 0
    },
    boldText: {
        ...UIFont.font(fonts.regular, 18, colors.BlackColor),
        marginTop: 10,
        marginBottom: 10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    },
    locationStyle: {
        ...UIFont.font(fonts.regular, 12, "#525252"),
        marginBottom: 10,
        marginHorizontal: 20,
        lineHeight: 14,
        letterSpacing: 0
    },
    mapStyle: {
        backgroundColor: "white",
        marginTop: 15,
        marginBottom: 80,
        height: 200,
        paddingHorizontal: 20,
        justifyContent: "center",
        alignItems: "center",
        borderRadius: 6
    },
    modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
    inputWrapper: {
        flexDirection: "column",
        width: Metrics.screenWidth - Metrics.xDoubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        }
    },
    modalFooter: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        borderTopWidth: 1,
        borderColor: "#DDDDDD"
    },
    textColor: {
        ...UIFont.font(fonts.regular, fontSize.medium, "#343434")
    },
    textColor2: {
        ...UIFont.font(fonts.regular, fontSize.medium, colors.CardDate)
    },
    modalInner: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "rgba(0,0,0,0.5)"
    },
    modalFirstColumn: {
        flex: 2,
        flexDirection: "column",
        justifyContent: "center",
        alignItems: "center",
        paddingVertical: 25
    },
    tabTextStyle: {
        paddingTop: Metrics.ratio(12),
        fontFamily: "Gibson",
        fontSize: 13,
        fontWeight: "600",
        fontStyle: "normal",
        lineHeight: 15,
        letterSpacing: 0
    },
    tabUnderline: {
        backgroundColor: colors.ActiveTabTitle
    },
    cardWrapper: {
        backgroundColor: colors.TabsWrapper
    },
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    },
    acceptRejectStyle: {
        height: 80,
        width: "100%",
        flexDirection: "row",
        paddingHorizontal: 20,
        justifyContent: "space-between"
    },
    ButtonViewStyle: {
        marginTop: 15,
        height: 40,
        borderRadius: 5,
        borderWidth: 1,
        justifyContent: "center",
        alignItems: "center"
    },
    acceptText: {
        ...UIFont.font(fonts.regular, 12, "#08548c")
    },
    rejectText: {
        ...UIFont.font(fonts.regular, 12, "#d93636")
    },
    bidText: {
        ...UIFont.font(fonts.medium, 11, "#2d3057")
    },
    rateText: {
        ...UIFont.font(fonts.regular, 18, colors.BlackColor)
    },
    textStyle: {
        ...UIFont.font(fonts.reqular, 15, colors.BlackColor)
    },
    defaultStyle: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        paddingRight: 10
    },
    mileageBidLabelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor),
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    eachView: {
        borderRadius: 5,
        borderStyle: "solid",
        borderWidth: 1,
        borderColor: "#dde3f6",
        alignItems: "center",
        justifyContent: "center",
        height: 40
    },
    firstText: {
        ...UIFont.font(fonts.regular, 9, colors.CardDate),
        lineHeight: 11,
        letterSpacing: 0
    },
    txtContract: {
        ...UIFont.font(fonts.semiBold, 16, colors.CardDate)
    },
    ViewLabelButton: {
        justifyContent: "center",
        alignItems: "center"
    }
});
