import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, RequestsCard } from "../../components";
import { API_GET_REQUESTS } from "../../services/WebService";
import styles from "./styles";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_ACTIVE_REQUESTS } from "../../actions/ActionTypes";
import { push } from "../../services/NavigationService";

class InvitationReceived extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false
        };
    }

    componentDidMount() {
        this.fetchData();
    }

    componentDidUpdate(prevProps, prevState) {
        if (this.props.id !== prevProps.id) {

          
            this.fetchData();
        }

    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        this.setState({ isFetching: true });
        this.props.generalAction(
            API_GET_REQUESTS,
            { contract_id: this.props.id,
                invitation_type: "received", page },
            LIST_ACTIVE_REQUESTS.SUCCESS,
            LIST_ACTIVE_REQUESTS.FAILURE,
            () => {
                this.setState({ isFetching: false });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    renderItem = ({ item, index }) => {

        return (
            <RequestsCard
                request={"received"}
                item={item}
                goTo={(data, screen) =>
                    push("requestsDetail", { data, screen })
                }
            />
        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.activeRequests}
                    renderItem={item => this.renderItem(item)}
                />
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, activeRequests }) => ({
    user: user.data,
    activeRequests: activeRequests.data
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    InvitationReceived
);
