import React, { Component } from "react";
import { View, Text } from "react-native";
import { connect } from "react-redux";
import { FlatListHandler, RequestsCard } from "../../components";
import { API_GET_REQUESTS } from "../../services/WebService";
import { push } from "../../services/NavigationService";
import styles from "./styles";

import { generalAction } from "../../actions/GeneralActions";
import { LIST_CLOSE_REQUESTS } from "../../actions/ActionTypes";

class InvitationSent extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isFetching: false
        };
    }

    componentDidMount() {
        this.fetchData();
    }

    fetchData = (isConcat: boolean = false, page: Number = 1) => {
        this.setState({ isFetching: true });
        this.props.generalAction(
            API_GET_REQUESTS,
            { contract_id: this.props.id, invitation_type: "sent", page },
            LIST_CLOSE_REQUESTS.SUCCESS,
            LIST_CLOSE_REQUESTS.FAILURE,
            () => {
                this.setState({ isFetching: false });
            },
            () => {
                this.setState({ isFetching: false });
            },
            true,
            isConcat
        );
    };

    renderItem = ({ item }) => {
        return (
            <RequestsCard
                request={"sent"}
                item={item}
                goTo={(data, screen) =>
                    push("requestsDetail", { data, screen })
                }
            />
        );
    };

    render() {
        return (
            <View style={styles.containerActiveTab}>
                <FlatListHandler
                    isFetching={this.state.isFetching}
                    refreshing={this.state.isFetching}
                    onRefresh={this.fetchData}
                    fetchRequest={this.fetchData}
                    data={this.props.closeRequests}
                    renderItem={item => this.renderItem(item)}
                />
            </View>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, closeRequests }) => ({
    user: user.data,
    closeRequests: closeRequests.data
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    InvitationSent
);
