import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    ScrollView,
    TouchableWithoutFeedback
} from "react-native";
import { connect } from "react-redux";
import { compose } from "redux";
import { pop, push, reset } from "../../services/NavigationService";
import {
    DeleteModal,
    InfoModal,
    AllInfo,
    InfoMileage,
    AcceptModal,
    RejectModal
} from "../../appComponents/ModalComponents";
import { Images, icons, colors } from "../../assets";
import {
    DetailCard,
    Separator,
    TextLabel,
    FooterDetail,
    ReusableModal,
    RequestsCard,
    AcceptRejectBid,
    MileagePaidBidRate
} from "../../components";
import {
    API_INVITATION_ACCEPT,
    API_INVITATION_REJECT,
    API_FACILITY_INVITATION,
    API_INVITATION_CANCEL,
    API_PERCENTAGE
} from "../../services/WebService";
import { generalAction, notificationBar, generalSaveAction } from "../../actions/GeneralActions";
import { DUMP, SHOW_BAR, HIDE_BAR, ADMIN_FEE_AMOUNT } from "../../actions/ActionTypes";
import { WithFetching } from "../../HOC";
import Utils from "../../Utils";
import moment from "moment";
import styles from "./styles";

import { selectPostDetails } from "../../reduxSelectors";

class RequestsDetail extends Component {
    constructor(props) {
        super(props);

        this.state = {
            rejectReason: "",
            boo: false,
            modal: "",
            maxRadius: props.route.params.data.maximum_radius,
            percentageRate: 0
        };
    }

    componentDidMount() {
        const {
            contract_type,
            cost_per_mile
        } = this.props.route.params.data;
        this.props.navigation.setParams({
            showInfo: () => this.showModal("allInfo"),
            boo:
                contract_type == "Shift" && cost_per_mile == null
                    ? null
                    : cost_per_mile
        });
        this.getPercentageValue();
    }
    getPercentageValue = () => {
        this.props.cbShowLoader(true);
        this.props.generalAction(
            API_PERCENTAGE,
            null,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbSuccess,
            this.cbFailure,
            true
        );
    }
    cbSuccess = (response) => {
        this.props.cbShowLoader(false);
        const { percentage_value } = response;
        this.setState({
            percentageRate: percentage_value
        });
        this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: percentage_value });
        Utils.setAdminFee(percentage_value);
    }
    cbFailure = (response) => {
        this.props.cbShowLoader(false);
    }

    AcceptReject = () => {
        const { data, screen } = this.props.route.params,
            { contract_id, user_id, invitation_id } = data,
            { modal, rejectReason } = this.state,
            { user } = this.props;
        let api = "",
            payload = new FormData();
        if (modal === "reject") {
            payload.append("user_id", this.props.user.data.id);
            payload.append("id", invitation_id);
            payload.append("message", rejectReason);
            api = API_INVITATION_REJECT;
        } else if (modal === "accept") {
            api = API_INVITATION_ACCEPT;
            //invitation accept
            payload.append("id", invitation_id);
            payload.append("user_id", this.props.user.data.id);

        } else if (modal === "delete") {
            api = API_INVITATION_CANCEL;
            payload.append("id", invitation_id);
        } else if (screen === "sent") {
            api = API_FACILITY_INVITATION;
            payload.append("user_id", user_id);
            payload.append("contract_id", contract_id);
            payload.append("invitation_status", "pending");
            payload.append("invitation_type", "sent");
        }
        this.callApi(api, payload);
    };

    callApi = (api, payload) => {
        this.props.generalAction(
            api,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.AcceptRejectSuccess,
            this.AcceptRejectFailure
        );
        this.props.cbShowLoader(true);
    };

    AcceptRejectSuccess = () => {
        const { data, screen } = this.props.route.params,
            { modal } = this.state;
        this.props.cbShowLoader(false);
        this.hideModal();
        if (screen === "sent" && modal !== "delete") {
            this.invitationSent(data);
        } else if (modal === "reject" || modal === "delete") {
            pop();
        } else {
            Utils.showMessage(
                "Success",
                "Contract accepted successfully",
                "success"
            );
            reset("onboardProjects");
        }
    };

    AcceptRejectFailure = err => {
        this.hideModal();
        this.props.cbShowLoader(false);
        Utils.showError(err);
    };

    invitationSent({ image_url, full_name }) {
        let obj = {
            image_url,
            full_name,
            message: "Your request has been sent"
        };
        this.props.notificationBar(SHOW_BAR, obj);
        setTimeout(() => {
            this.props.notificationBar(HIDE_BAR);
        }, 3000);
    }

    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.setState({ boo: false });
        this.Modal.setModalVisible(false);
    };

    calculateDiffTime = (b, a) => {
        let dif = moment(b, "HH:mm:a").diff(moment(a, "HH:mm:a"));
        let diffTime = moment.duration(dif).hours();
        return +diffTime == 0 ? 1 : diffTime;
    };

    renderModal = () => {
        const { modal, boo, rejectReason, maxRadius } = this.state,
            { data } = this.props.route.params,

            {
                contract_type,
                cost_per_mile,
                hourly_pay_rate,
                contract_rate,
                shift_end_time,
                shift_start_time,
                total_hours,
                backend_calc_total_amount
            } = data;

        let finalRes = this.calculationBidMileage();
        let rate =
            hourly_pay_rate === null
                ? contract_rate &&
                contract_rate.slice(0, contract_rate.indexOf("."))
                : hourly_pay_rate &&
                hourly_pay_rate.slice(0, hourly_pay_rate.indexOf("."));
        let diffTime = this.calculateDiffTime(shift_end_time, shift_start_time);
        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={styles.modalContainer}>
                        <View style={styles.modalInner}>
                            {modal == "reject" && (
                                <RejectModal
                                    deleteContract={this.AcceptReject}
                                    hideModal={this.hideModal}
                                    onChangeText={rejectReason =>
                                        this.setState({ rejectReason })
                                    }
                                    value={rejectReason}
                                    onFocus={() => this.setState({ boo: true })}
                                    onBlur={() => this.setState({ boo: false })}
                                    boo={boo}
                                />
                            )}
                            {modal == "accept" && (
                                <AcceptModal
                                    deleteContract={this.AcceptReject}
                                    hideModal={this.hideModal}
                                    text1={"Are you sure you want to accept"}
                                    text2={`the ${contract_type}?`}
                                    total={`${(+backend_calc_total_amount).toFixed(2)}`}
                                />
                            )}
                            {modal == "delete" && (
                                <DeleteModal
                                    deleteContract={this.AcceptReject}
                                    hideModal={this.hideModal}
                                    text1={"Are you sure you want to cancel"}
                                    text2={"this invitation"}
                                />
                            )}
                            {modal == "info" && (
                                <InfoModal
                                    costMile={cost_per_mile}
                                    maxRadius={maxRadius}
                                />
                            )}
                            {modal == "allInfo" && (
                                <AllInfo note={this.props.note} />
                            )}
                            {modal == "mileage" && (
                                <InfoMileage
                                    rate={rate}
                                    contract_type={contract_type}
                                    diffTime={total_hours}
                                />
                            )}
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };

    calculationBidMileage() {
        const { modal, boo, rejectReason, maxRadius } = this.state,
            { data } = this.props.route.params,
            {
                contract_type,
                cost_per_mile,
                hourly_pay_rate,
                bid_amount,
                total_hours
            } = data;
            
        let rate =
            hourly_pay_rate === null && +bid_amount == 0
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : hourly_pay_rate === null && +bid_amount > 0
                    ? bid_amount
                    : data.hourly_pay_rate &&
                    data.hourly_pay_rate.slice(
                        0,
                        data.hourly_pay_rate.indexOf(".")
                    );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * total_hours;
        let dist = Utils.distance(
            data.latitude,
            data.longitude,
            data.invitation_latitude,
            data.invitation_longitude
        );
        let totalDistance = dist > maxRadius ? maxRadius : dist;
        let totalMileage = totalDistance * +data.cost_per_mile;
        let total =
            +bid_amount == 0 && totalMileage > 0
                ? bidAmount + +totalMileage
                : +bid_amount > 0 && +totalMileage == 0
                    ? +bid_amount
                    : +totalMileage + +bid_amount;
        let finalRes =
            contract_type == "Contract" ||
                (contract_type == "Shift" && total == 0)
                ? bidAmount
                : total;
        return finalRes;
    }

    heading(label) {
        return (
            <TextLabel
                type="medium"
                size="medium"
                color={"black"}
                style={styles.boldText}
            >
                {label}
            </TextLabel>
        );
    }

    paragraph(para, style, numberOfLines) {
        return (
            <Text style={style} numberOfLines={numberOfLines}>
                {para}
            </Text>
        );
    }

    footer() {
        let finalRes = this.calculationBidMileage();
        return (
            <FooterDetail
                style={{ justifyContent: "flex-end", paddingHorizontal: 20 }}
                text={`Total: $${finalRes}`}
                backgroundColor={{ backgroundColor: "#959dad" }}
                textColor={colors.BlackColor}
                clickBtn={() => { }}
            />
        );
    }

    labelButton(txt1, txt2, style) {
        return (
            <View style={[styles.eachView, style]}>
                <Text style={styles.firstText}>{txt1}</Text>
                <Text style={styles.txtContract}>{txt2}</Text>
            </View>
        );
    }

    mileagePaidLabelButton(data) {
        let dist = Utils.distance(
            data.invitation_latitude,
            data.invitation_longitude,
            data.latitude,
            data.longitude
        );
        let totalDistance =
            dist > data.maximum_radius ? data.maximum_radius : dist;
        // let totalMileage = data.cost_per_mile
        //     ? totalDistance * data.cost_per_mile
        //     : 0;
        let totalMileage = data.mileage_amount;
        return (
            <View style={[styles.defaultStyle, { marginTop: 10 }]}>
                <View style={{ flex: 4 }}>
                    {this.heading("Mileage Paid", [
                        styles.mileageBidLabelStyle
                    ])}
                </View>
                <View style={[styles.ViewLabelButton, { flex: 2 }]}>
                    {this.labelButton(
                        "Mileage Total",
                        `$${+totalMileage.toFixed(2)}`,
                        {
                            width: "65%"
                        }
                    )}
                </View>
            </View>
        );
    }

    mileagePaidLabelButtonWithoutBid() {
        const { data } = this.props.route.params;
        let dist = Utils.distance(
            data.latitude,
            data.longitude,
            data.invitation_latitude,
            data.invitation_longitude
        );

        let percentageRate = data.admin_percent;
        let totalDistance =
            dist > data.maximum_radius ? data.maximum_radius : dist;
        let totalMileage = data.cost_per_mile
            ? totalDistance * data.cost_per_mile
            : 0;
        let rate =
            data.hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0)
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0
                );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * data.total_hours;
            
        let bidWithMileage = (percentageRate / 100) * (+bidAmount + +totalMileage);
    
        return (
            <View style={[styles.defaultStyle, { marginVertical: 20 }]}>
                <View style={{ flex: 1.3 }}>
                    {this.heading("Rate", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View
                    style={[
                        styles.ViewLabelButton,
                        {
                            flex: 4,
                            justifyContent: "space-between",
                            flexDirection: "row"
                        }
                    ]}
                >
                    {this.labelButton("Hour Total", `$${(bidAmount).toFixed(2)}`, {
                        width: "49%"
                    })}
                    {this.labelButton(
                        "Total",
                        // `$${(+bidAmount + +totalMileage).toFixed(2)}`,
                        `$${(
                            bidWithMileage +
                            +bidAmount +
                            +totalMileage
                        ).toFixed(2)}`,
                        {
                            width: "49%"
                        }

                        
                    )}
                </View>
            </View>
        );
    }

    bidRateLabelButton() {
        const { data } = this.props.route.params;

        // const { percentageRate } = this.state;
        let percentageRate = data.admin_percent;
        let dist = Utils.distance(
            data.latitude,
            data.longitude,
            data.invitation_latitude,
            data.invitation_longitude
        );
        let totalDistance =
            dist > data.maximum_radius ? data.maximum_radius : dist;
        // let totalMileage = data.cost_per_mile
        //     ? totalDistance * data.cost_per_mile
        //     : 0;

            let totalMileage = data.mileage_amount;


        let bidWithMileage = (percentageRate / 100) * (+data.bid_amount + +totalMileage);

        return (
            <View style={[styles.defaultStyle, { marginVertical: 20 }]}>
                <View>
                    {this.heading("Bid Rate", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View
                    style={[styles.ViewLabelButton, {
                        flex: 3,
                        justifyContent: data.contract_type === "Contract" ? "flex-end" : "space-between",
                        flexDirection: "row"
                    }]}>
                    {data.contract_type === "Shift" &&
                        this.labelButton(
                            "Per Hour",
                            `$${(data.bid_amount / data.total_hours).toFixed(2)}`,
                            { width: "19%" }
                        )}
                    {data.contract_type === "Shift" &&
                        this.labelButton("Hour Total", `$${data.bid_amount}`, {
                            width: "29%"
                        })}
                    {data.contract_type === "Contract" &&
                        this.labelButton(
                            "Per Hour",
                            `$${data.bid_amount}`, { width: "45%" }
                        )}
                    {data.contract_type === "Shift" &&
                        totalMileage == 0 &&
                        this.labelButton(
                            "Total",
                            `$${((percentageRate / 100) * +data.bid_amount +
                            +data.bid_amount).toFixed(2)}`,
                            {
                                width: "45%"
                            }
                        )}
                    {data.contract_type === "Shift" &&
                        totalMileage > 0 &&
                        this.labelButton(
                            "Total ( Mileage + Bid )",
                            `$${(
                                bidWithMileage +
                                +data.bid_amount +
                                +totalMileage
                            ).toFixed(2)}`,
                            {
                                width: "49%"
                            }
                        )}
                </View>
            </View>
        );
    }

    render() {
        const { data, screen } = this.props.route.params,
            { user } = this.props;

        // const { percentageRate } = this.state
        return (
            <React.Fragment>
                <ScrollView style={{ backgroundColor: "#f8f8f8" }}>
                    <DetailCard
                        data={data}
                        user={user.data}
                        cbMileage={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("info")
                        }
                        cbTotal={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("mileage")
                        }
                        style={{ backgroundColor: "#f8f8f8" }}
                    />
                    <Separator style={styles.separatorStyle} />
                    {this.heading("Description")}
                    {this.paragraph(
                        data.description,
                        styles.descriptionStyle,
                        2
                    )}
                    <Separator style={styles.separatorStyle} />
                    <RequestsCard
                        request={"goToProfile"}
                        screen={screen}
                        item={data}
                        goTo={() =>
                            push("contractorDetail", {
                                data,
                                showFooter: false
                            })
                        }
                    />
                    {!!data.is_mileage_paid && screen !== "sent" && (
                        <Separator style={styles.separatorStyle} />
                    )}
                    {!!data.is_mileage_paid && screen !== "sent" && (
                        <MileagePaidBidRate
                            val1={data.location_address}
                            val2={data.address}
                            style={styles.textStyle}
                        />
                    )}
                    {!!data.is_mileage_paid &&
                        screen !== "sent" &&
                        this.mileagePaidLabelButton(data)}
                    {data.bid_amount == "0.00" &&
                        !!data.is_mileage_paid &&
                        screen !== "sent" &&
                        this.mileagePaidLabelButtonWithoutBid()}
                    {!!+data.bid_amount && screen !== "sent" && (
                        <Separator style={styles.separatorStyle} />
                    )}
                    {!!+data.bid_amount &&
                        screen !== "sent" &&
                        this.bidRateLabelButton()}
                    {/*data.bid_amount == "0.00" && !!data.is_mileage_paid && screen !== "sent" && this.footer()*/}
                    <Text style={{ color: "green", marginHorizontal: 20 }}>{`${data.admin_percent}% adminstration fee will be applied.`}</Text>
                    {!data.is_onboarded && (
                        <AcceptRejectBid
                            screen={"sent"}
                            bid_amount={data.bid_amount}
                            text1={screen == "sent" ? "Resend" : "Accept"}
                            text2={screen == "sent" ? "Cancel" : "Reject"}
                            cbOne={
                                screen == "sent"
                                    ? this.AcceptReject
                                    : () => this.showModal("accept")
                            }
                            cbTwo={
                                screen == "sent"
                                    ? () => this.showModal("delete")
                                    : () => this.showModal("reject")
                            }
                        />
                    )}
                </ScrollView>

                {this.renderModal()}
            </React.Fragment>
        );
    }
}

const actions = { generalAction, notificationBar, generalSaveAction };
const mapStateToProps = ({ user, infoContent }, ownProps) => {
    return {
        data: selectPostDetails(ownProps),
        user,
        note: infoContent.data.content
    };
};

const DetailComponentCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(RequestsDetail))
);

export default DetailComponentCompose;

DetailComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};
    return {
        headerStyle: styles.header,
        headerRight: (
            <View style={{ flexDirection: "row" }}>
                {params.boo && (
                    <TouchableOpacity onPress={params.showInfo}>
                        <Image
                            style={{ margin: 10 }}
                            resizeMode="contain"
                            source={icons.ic_info}
                        />
                    </TouchableOpacity>
                )}
            </View>
        )
    };
};
