import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import { Metrics } from "../../services";

export default StyleSheet.create({
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#f8f8f8",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    separatorStyle: {
        backgroundColor: "#dde3f6",
        marginHorizontal: 20,
        marginVertical: 10
    },
    descriptionStyle: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, colors.BlackColor),
        marginBottom: 10,
        marginHorizontal: 20,
        lineHeight: 22,
        letterSpacing: 0
    },
    boldText: {
        ...UIFont.font(fonts.regular, 18, colors.BlackColor),
        marginTop: 10,
        marginBottom: 10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    },
    locationStyle: {
        ...UIFont.font(fonts.regular, 12, "#525252"),
        marginBottom: 10,
        marginHorizontal: 20,
        lineHeight: 14,
        letterSpacing: 0
    },
    mapStyle: {
        backgroundColor: "white",
        marginTop: 15,
        marginBottom: 80,
        height: 200,
        paddingHorizontal: 20,
        justifyContent: "center",
        alignItems: "center",
        borderRadius: 6
    },
    modalContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
    modalInner: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "rgba(0,0,0,0.5)"
    },
    tabTextStyle: {
        paddingTop: Metrics.ratio(12),
        fontFamily: "Gibson",
        fontSize: 13,
        fontWeight: "600",
        fontStyle: "normal",
        lineHeight: 15,
        letterSpacing: 0
    },
    tabUnderline: {
        backgroundColor: colors.ActiveTabTitle
    },
    cardWrapper: {
        backgroundColor: colors.TabsWrapper
    },
    containerActiveTab: {
        width: "100%",
        height: "100%",
        backgroundColor: colors.bgLightGrey
    },
    textStyle: {
        ...UIFont.font(fonts.reqular, 15, colors.BlackColor)
    },
    defaultStyle: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        paddingRight: 10
    },
    mileageBidLabelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor),
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    eachView: {
        borderRadius: 5,
        borderStyle: "solid",
        borderWidth: 1,
        borderColor: "#dde3f6",
        alignItems: "center",
        justifyContent: "center",
        height: 40
    },
    firstText: {
        ...UIFont.font(fonts.regular, 9, colors.CardDate),
        lineHeight: 11,
        letterSpacing: 0
    },
    txtContract: {
        ...UIFont.font(fonts.semiBold, 16, colors.CardDate)
    },
    ViewLabelButton: {
        justifyContent: "center",
        alignItems: "center"
    }
});
