import React, { Component } from "react";
import {
    View,
    Text,
    StyleSheet,
    Image,
    FlatList,
    TouchableOpacity, Alert
} from "react-native";
import { Separator, Supporticon } from "../../components";
import { pop, push, popToTop } from "../../services/NavigationService";
import { Images, colors, UIFont, fonts, fontSize, icons } from "../../assets";
import axios from "axios";
import { BASE_URL, DELETE_API, API_LOGOUT } from "../../services/WebService";
import Utils from "../../Utils";
import { connect } from "react-redux";
import { generalAction, generalDispatchType } from "../../actions/GeneralActions";
import { DUMP, LOGOUT } from "../../actions/ActionTypes";

class Settings extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };

    state = {
        options: [
            {
                title: "changePassword",
                optionIcon: icons.ic_lock,
                text: "Change Password"
            },
            {
                title: "aboutUs",
                optionIcon: icons.ic_about_us,
                text: "About Us"
            },
            {
                title: "Deletemyaccount",
                optionIcon: icons.delete_icon,
                text: "Delete my account"
            },
            {
                title: "contactUs",
                optionIcon: icons.ic_info,
                text: "Contact Us"
            },
            {
                title: "termsAndConditions",
                optionIcon: icons.ic_terms_condition,
                text: "Terms and Conditions"
            }
        ]
    };

    onPress(title) {

        if (title === "Deletemyaccount") {
            Alert.alert(
                "Delete Account",
                "Are you sure want to delete my account",
                [
                    {
                        text: "Cancel",
                        onPress: () => console.log("Cancel Pressed"),
                        style: "cancel"
                    },
                    { text: "OK", onPress: () => this.deleteAccount() }
                ]
            );
        }
        else {

            push(title);

        }
    }

    deleteAccount = () => {

        var userid = this.props.user.id;

        let payload = new FormData();
        payload.append("user_id", userid);

        this.props.generalDispatchType(LOGOUT);

        axios.get(BASE_URL + DELETE_API + "?user_id=" + userid, {
            headers: {
                token: "api.Pd*!(5675",
                api_version: '1.0',
                api_client: 'android'
            }
        })
            .then(function (response) {

                const codeval = response.data.success;
                const val = response.data.message;
                // {"message": "User Deleted Successfully", "success": "200"}
                if (codeval == 200) {

                    Utils.showMessage(val)
                    push("login")

                } else {


                }

            })
            .catch(function (error) {
                console.log(error);

            })


    }

    _renderItems({ optionIcon, text, title }) {
        return (
            <TouchableOpacity onPress={() => this.onPress(title)}>
                <View style={styles.eachColumn}>
                    <Image source={optionIcon} style={styles.imgStyle} />
                    <Text style={styles.textStyle}>{text}</Text>
                </View>
                <Separator style={styles.seperatorStyle} />
            </TouchableOpacity>
        );
    }

    render() {
        return (
            <View style={styles.container}>

                <FlatList
                    data={this.state.options}
                    showsVerticalScrollIndicator={false}
                    renderItem={({ item }) => this._renderItems(item)}
                />


                <Supporticon
                    clickBtn={() => push("Support")} />
            </View>
        );
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: "#f7f7f7"
    },
    eachColumn: {
        height: 60,
        flexDirection: "row"
    },
    textStyle: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, "#313131"),
        alignSelf: "center",
        flex: 1,
        //lineHeight: 70,
        letterSpacing: 0.03
    },
    seperatorStyle: {
        backgroundColor: "#dde3f6",
        marginHorizontal: 15
    },
    imgStyle: {
        margin: 20
    }
});

const actions = { generalAction, generalDispatchType };
const mapStateToProps = ({ user }) => ({
    user: user.data,
});

export default connect(mapStateToProps, actions, null, { forwardRef: true })(
    Settings
);
