// import React, { Component, Fragment } from "react";
// import {
//     View,
//     Text,
//     Button,
//     Image,
//     StyleSheet,
//     TouchableOpacity,
//     TouchableWithoutFeedback,
//     ScrollView,
//     BackHandler, Modal
// } from "react-native";
// import { connect } from "react-redux";
// import { NavigationEvents } from "react-navigation";
// import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
// import { push } from "../../services/NavigationService";
// import { compose } from "redux";
// import { API_NOTIFICATION_COUNT, API_PERCENTAGE, API_INACTIVE, BASE_URL, GET_UPDATE, } from "../../services/WebService";
// import { DUMP, ADMIN_FEE_AMOUNT, USER, LOGOUT } from "../../actions/ActionTypes";
// import { Images, icons, colors, UIFont, fonts, fontSize, } from "../../assets";
// import Metrics from "../../services/Metrics";
// import { SquareCard, ReusableModal, NetInfoModal, Supporticon }
//     from "../../components";
// import { WithNetInfoListener } from "../../HOC";
// import Utils from "../../Utils";
// import { AppUpdate } from '../../containers';
// import axios from "axios";
// import {AppStyles} from "../../services";

// class ShiftHome extends Component {
//     state = {
//         bothWarning:
//             "Please verify your profile, enter your card details in order to post a Shift or Contract",
//         profileWarning:
//             "Please verify your profile in order to post a Shift or Contract",
//         accountDetailWarning:
//             "Please enter your card details in order to post a Shift or Contract", intervalId: '',
//         isupdate_store: false,
//         isupdate_popup: false,
//         isupdate_logout: false,
//         messageval: '',
//         updateval: '',
//         urlvalue: Utils.isPlatformAndroid()?
//         'https://play.google.com/store/apps/details?id=com.medicashifts':
//         'https://apps.apple.com/in/app/medicashift-facility/id1481440009',
//     };

//     onNavigationFocus = () => setTimeout(this.fetchNotificationCount, 1500);

//     fetchNotificationCount = () => {
//         this.props.generalAction(
//             API_NOTIFICATION_COUNT,
//             { user_id: this.props.user.id },
//             DUMP.SUCCESS,
//             DUMP.FAILURE,
//             ({ notification_count }) => {
//                 this.props.navigation.setParams({
//                     showInfo: notification_count > 0 ? true : false
//                 });
//             },
//             () => { },
//             true

//         );
//         this.loadData()
//         let intervalId = setInterval(this.loadData, 5000);
//         this.setState({ intervalId: intervalId });
//     };
//     loadData = () => {

//         this.props.generalAction(
//             API_INACTIVE,
//             { user_id: this.props.user.id },

//             DUMP.SUCCESS,
//             DUMP.FAILURE,
//             data => {

//                 data.map(item => {
//                     item.is_account_active == 0 ? (
//                         this.sendData()
//                     ) : null

//                     Utils.setLunchValue(item.Lunch_value)
//                     Utils.setHelpLine(item.help_line)
//                 })


//             },
//             () => { },
//             true
//         );


//     };
//     sendData = () => {

//         push("login")
//         Utils.showError("Your account is inactive, please contact medicashift")
//         clearInterval(this.state.intervalId)
//     }
//     componentDidMount() {
//         this.getPercentageValue();
//         this.appUpdateApi();

//     }

//     appUpdateApi = () => {

//         let self = this;

//         axios.get(BASE_URL + GET_UPDATE, {
//             headers: {
//                 token: "api.Pd*!(5675",
//                 api_version:'1.0',
//                 api_client:'android'
//             }
//         })
//             .then(function (response) {

//                 const codeval = response.data.success;
//                 const val = response.data.message;

//                 if (codeval == 200) {

//                     var codetype = response.data.code;

//                     if (codetype == "store") {

//                         self.setState({ isupdate_store: true, messageval: val })

//                     } else if (codetype == "popup") {

//                         self.setState({ isupdate_popup: true, messageval: val })

//                     } else if (codetype == "logout ") {

//                         self.setState({ isupdate_logout: true, messageval: val })

//                     }
//                     else {

//                         Utils.showError(response.data.message)
//                     }

//                 } else {


//                 }


//             })
//             .catch(function (error) {
//                 console.log(error);
//             })
//     }

//     getPercentageValue = () => {
//         this.props.generalAction(
//             API_PERCENTAGE,
//             null,
//             DUMP.SUCCESS,
//             DUMP.FAILURE,
//             this.cbSuccess,
//             this.cbFailure,
//             true
//         );
//     }

//     cbSuccess = (response) => {
//         const { percentage_value } = response;
//         this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: percentage_value });
//         Utils.setAdminFee(percentage_value);
//     }
//     cbFailure = (response) => {

//     }

//     showModal = modal => {
//         this.Modal.setModalVisible(true);
//     };

//     hideModal = () => {
//         this.Modal.setModalVisible(false);
//     };

//     modalCard = label => {
//         const { is_stripe_key, is_profile_verified } = this.props.user;
//         let aWord = label
//             .slice(label.lastIndexOf(" ") + 1, label.length)
//             .toLowerCase(),
//             goTo = aWord.charAt(0).toUpperCase() + aWord.substring(1);
//         return (
//             <TouchableOpacity
//                 elevation={15}
//                 style={[styles.inputModalWrapper]}
//                 onPress={() => {
//                     this.hideModal();
//                     setTimeout(() => {
//                         if (!is_stripe_key) {
//                             Utils.showAlert(
//                                 "Account details",
//                                 "You have to provide your card details in order to post a Shift or Contract",
//                                 () => push("paymentMethod")
//                             );
//                         } else if (is_profile_verified !== 2) {
//                             Utils.showAlert(
//                                 "Profile Verification",
//                                 "Your Profile need to be verified in order to post a Shift or Contract",
//                                 () => push("profile")
//                             );
//                         } else {
//                             push("category", { goTo });
//                         }
//                     }, 500);
//                 }}
//             >
//                 <Image
//                     style={{
//                         marginBottom: Metrics.doubleBaseMargin
//                     }}
//                     source={Images.post_add}
//                 />
//                 <Text>{label}</Text>
//                 <View
//                     style={[
//                         styles.triangleCorner,
//                         {
//                             transform: [{ rotate: "270deg" }],
//                             justifyContent: "flex-end"
//                         }
//                     ]}
//                 />
//             </TouchableOpacity>
//         );
//     };
//     renderModal = () => {
//         return (
//             <TouchableWithoutFeedback>
//                 <View
//                     style={{
//                         width: "85%"
//                     }}
//                 >
//                     <View
//                         elevation={15}
//                         style={[
//                             styles.inputWrapper,
//                             {
//                                 justifyContent: "space-between",
//                                 paddingVertical: Metrics.baseMargin
//                             }
//                         ]}
//                     >
//                         <Text
//                             style={{
//                                 marginLeft: "35%"
//                             }}
//                         >
//                             POST A JOB
//                         </Text>
//                         <TouchableOpacity
//                             style={{ padding: 10 }}
//                             onPress={this.hideModal}
//                         >
//                             <Image source={icons.ic_cross} />
//                         </TouchableOpacity>
//                     </View>
//                     <View
//                         style={{
//                             flexDirection: "row",
//                             justifyContent: "space-between"
//                         }}
//                     >
//                         {this.modalCard("POST A SHIFT")}
//                         {this.modalCard("POST A CONTRACT")}
//                     </View>
//                 </View>
//             </TouchableWithoutFeedback>
//         );
//     };

//     renderProfileWarning() {
//         const { is_stripe_key, is_profile_verified } = this.props.user;
//         return (
//             <Fragment>
//                 {!is_stripe_key &&
//                     is_profile_verified !== 2 &&
//                     this.renderWarningText("bothWarning")}
//                 {is_stripe_key &&
//                     is_profile_verified !== 2 &&
//                     this.renderWarningText("profileWarning")}
//                 {!is_stripe_key &&
//                     is_profile_verified == 2 &&
//                     this.renderWarningText("accountDetailWarning")}
//             </Fragment>
//         );
//     }

//     renderWarningText(warningText) {
//         return (
//             <View style={styles.containerWarning}>
//                 <Text style={{ color: "white" }}>
//                     {this.state[warningText]}
//                 </Text>
//             </View>
//         );
//     }

//     sendDataLogout = () => {

//         push("login")
//         this.props.generalDispatchType(LOGOUT);
//         clearInterval(this.state.intervalId)

//     } 

//     render() {
//         const { isNetworkConnected } = this.props.networkInfo;
//         const { isupdate_store,isupdate_logout ,messageval,isupdate_popup} = this.state;

//         return (
//             <View style={{ flex: 1 }}>
//                 <ScrollView style={styles.container}>
//                     <NavigationEvents onDidFocus={this.onNavigationFocus} />
//                     {this.renderProfileWarning()}
//                     <Image source={Images.bgFacilityHome} />
//                     <View style={{ width: "85%", alignSelf: "center" }}>
//                         <View
//                             style={{
//                                 flexDirection: "row",
//                                 justifyContent: "space-between"
//                             }}
//                         >
//                             <SquareCard
//                                 text="POST A SHIFT / CONTRACT"
//                                 icon={Images.PostShift}
//                                 onClick={this.showModal}
//                             />

//                             <SquareCard
//                                 text="MY SHIFT / CONTRACT"
//                                 icon={Images.MyShift}
//                                 onClick={() => push("myShiftsContracts")}
//                             />
//                         </View>
//                         <View
//                             elevation={15}
//                             style={[
//                                 styles.inputWrapper,
//                                 {
//                                     marginBottom: 40
//                                 }
//                             ]}
//                         >
//                             <TouchableOpacity
//                                 onPress={() => push("onboardProjects")}
//                                 style={{
//                                     flex: 1,
//                                     flexDirection: "row",
//                                     justifyContent: "center",
//                                     alignItems: "center",
//                                     paddingVertical: Metrics.doubleBaseMargin
//                                 }}
//                             >
//                                 <Image source={Images.on_board_job} />
//                                 <Text>ON BOARD SHIFTS</Text>
//                             </TouchableOpacity>
//                         </View>
//                     </View>
//                     <ReusableModal ref={ref => (this.Modal = ref)}>
//                         <TouchableWithoutFeedback onPress={this.hideModal}>
//                             <View blurRadius={1} style={styles.modaContainer}>
//                                 <View
//                                     style={{
//                                         flex: 1,
//                                         justifyContent: "center",
//                                         alignItems: "center"
//                                     }}
//                                 >
//                                     {this.renderModal()}
//                                 </View>
//                             </View>
//                         </TouchableWithoutFeedback>
//                     </ReusableModal>

//                     {isupdate_store ?
//                         <Modal transparent >
//                             <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
//                                 <View style={{
//                                     backgroundColor: "white",
//                                     paddingVertical: Metrics.ratio(50),
//                                     paddingHorizontal: Metrics.baseMargin,
//                                     borderRadius: Metrics.baseMargin,
//                                     ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
//                                 }}>
//                                     <AppUpdate {...this.props} valueset={this.state.urlvalue} />

//                                 </View>
//                             </View>
//                         </Modal> : null}

//                     {isupdate_logout ?
//                         <Modal transparent >
//                             <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
//                                 <View style={{
//                                     backgroundColor: "white",
//                                     paddingVertical: Metrics.ratio(50),
//                                     paddingHorizontal: Metrics.baseMargin,
//                                     borderRadius: Metrics.baseMargin,
//                                     ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
//                                 }}>
//                                     <View style={styles.updateview} >
//                                         <Text style={{
//                                             padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.semiBold, fontSize.xLarge, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'center'
//                                         }}>Reason for Logout</Text>

//                                         <Text style={{
//                                             color: 'black', padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.regular, fontSize.medium, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'baseline'
//                                         }}>
//                                             {messageval}
//                                         </Text>

//                                         <TouchableOpacity
//                                             activeOpacity={1.0}
//                                             style={styles.modalverifyFooter}
//                                             onPress={() =>
//                                                 this.sendDataLogout()
//                                             } >

//                                             <Text style={{
//                                                 color: '#ffff',
//                                                 textAlign: 'center',
//                                                 ...UIFont.font(fonts.semiBold, fontSize.medium, colors.WhiteColor),
//                                                 padding: 10,
//                                             }}>
//                                                 OK
//                                             </Text>

//                                         </TouchableOpacity>
//                                     </View>

//                                 </View>
//                             </View>
//                         </Modal> : null}

//                     {isupdate_popup ?
//                         <Modal transparent >
//                             <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
//                                 <View style={{
//                                     backgroundColor: "white",
//                                     paddingVertical: Metrics.ratio(50),
//                                     paddingHorizontal: Metrics.baseMargin,
//                                     borderRadius: Metrics.baseMargin,
//                                     ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
//                                 }}>
//                                     <View style={styles.updateview} >
//                                         <Text style={{
//                                             padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.semiBold, fontSize.xLarge, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'center'
//                                         }}>Reason for Maintenance</Text>

//                                         <Text style={{
//                                             color: 'black', padding: 10, fontFamily: 'Gibson',
//                                             ...UIFont.font(fonts.regular, fontSize.medium, colors.BlackColor),
//                                             fontSize: 20, alignSelf: 'baseline'
//                                         }}>
//                                             {messageval}
//                                         </Text>

//                                         <TouchableOpacity
//                                             activeOpacity={1.0}
//                                             style={styles.modalverifyFooter}
//                                             onPress={() => BackHandler.exitApp()} >

//                                             <Text style={{
//                                                 color: '#ffff',
//                                                 textAlign: 'center',
//                                                 ...UIFont.font(fonts.semiBold, fontSize.medium, colors.WhiteColor),
//                                                 padding: 10,
//                                             }}>
//                                                 OK
//                                             </Text>

//                                         </TouchableOpacity>
//                                     </View>

//                                 </View>
//                             </View>
//                         </Modal> : null}

//                     <NetInfoModal isNetworkConnected={isNetworkConnected} />


//                 </ScrollView>

//                 <Supporticon
//                     clickBtn={() => push("Support")} />

//             </View>

//         );
//     }
// }

// const actions = { generalAction, generalSaveAction };
// const mapStateToProps = ({ user, networkInfo }) => {
//     return {
//         user: user.data,
//         networkInfo
//     };
// };

// const composeShiftHome = compose(
//     connect(mapStateToProps, actions)(WithNetInfoListener(ShiftHome))
// );

// export default composeShiftHome;

// composeShiftHome.navigationOptions = ({ navigation }) => {
//     const { state } = navigation;
//     const params = state.params || {};
//     return {
//         headerRight: (
//             <TouchableOpacity onPress={() => push("notifications")}>
//                 <Image
//                     style={{ margin: 10 }}
//                     resizeMode="contain"
//                     source={!params.showInfo ? icons.bell : icons.notification}
//                 />
//             </TouchableOpacity>
//         )
//     };
// };

// const styles = StyleSheet.create({
//     container: {
//         flex: 1
//     },
//     modaContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
//     image: {
//         width: "100%",
//         height: "100%",
//         resizeMode: "contain"
//     },
//     containerWarning: {
//         height: 40,
//         width: "100%",
//         backgroundColor: "red",
//         justifyContent: "center",
//         alignItems: "center",
//         paddingHorizontal: 20
//     },
//     triangleCorner: {
//         backgroundColor: "transparent",
//         borderStyle: "solid",
//         borderRightWidth: 20,
//         borderTopWidth: 20,
//         borderRightColor: "transparent",
//         borderTopColor: "#e0535e",
//         position: "absolute",
//         left: 0,
//         bottom: 0
//     },
//     inputWrapper: {
//         width: "100%",
//         alignItems: "center",
//         flexDirection: "row",
//         marginTop: Metrics.doubleBaseMargin,
//         backgroundColor: colors.WhiteColor,
//         borderRadius: 6,
//         shadowColor: colors.BlackColor,
//         shadowOpacity: 0.8,
//         shadowRadius: 20,
//         shadowOffset: {
//             height: 5,
//             width: 5
//         },

//         justifyContent: "space-around"
//     },
//     inputModalWrapper: {
//         width: "48.5%",
//         alignItems: "center",
//         marginTop: Metrics.baseMargin,
//         backgroundColor: colors.WhiteColor,
//         borderRadius: 6,
//         shadowColor: colors.BlackColor,
//         shadowOpacity: 0.8,
//         shadowRadius: 20,
//         shadowOffset: {
//             height: 5,
//             width: 5
//         },

//         paddingVertical: Metrics.xDoubleBaseMargin
//     },
//     updateview: {
//         justifyContent: 'flex-end',
//         width: "85%",
//         backgroundColor: "white",
//         padding: 5,
//         borderTopLeftRadius: 5,
//         borderTopRightRadius: 5,    
//     },
//     modalverifyFooter: {
//         backgroundColor: "#bb050c",
//         borderRadius: 5,
//         margin:30,
//     },
// });
import React, { Component, Fragment } from "react";
import {
  View,
  Text,
  Image,
  StyleSheet,
  TouchableOpacity,
  TouchableWithoutFeedback,
  ScrollView,
  BackHandler,
  Modal,
} from "react-native";
import { connect } from "react-redux";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { compose } from "redux";
import {
  API_NOTIFICATION_COUNT,
  API_PERCENTAGE,
  API_INACTIVE,
  BASE_URL,
  GET_UPDATE,
} from "../../services/WebService";
import { DUMP, ADMIN_FEE_AMOUNT, LOGOUT } from "../../actions/ActionTypes";
import { Images, icons, colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import {
  SquareCard,
  ReusableModal,
  NetInfoModal,
  Supporticon,
} from "../../components";
import { WithNetInfoListener } from "../../HOC";
import Utils from "../../Utils";
import { AppUpdate } from "../../containers";
import axios from "axios";
import { AppStyles } from "../../services";
import * as NavService from "../../services/NavigationService";
import { useFocusEffect } from "@react-navigation/native";

class ShiftHome extends Component {
  state = {
    bothWarning:
      "Please verify your profile, enter your card details in order to post a Shift or Contract",
    profileWarning:
      "Please verify your profile in order to post a Shift or Contract",
    accountDetailWarning:
      "Please enter your card details in order to post a Shift or Contract",
    intervalId: "",
    isupdate_store: false,
    isupdate_popup: false,
    isupdate_logout: false,
    messageval: "",
    updateval: "",
    urlvalue: Utils.isPlatformAndroid()
      ? "https://play.google.com/store/apps/details?id=com.medicashifts"
      : "https://apps.apple.com/in/app/medicashift-facility/id1481440009",
  };

  componentDidMount() {
    this.getPercentageValue();
    this.appUpdateApi();

    // ✅ Replace NavigationEvents with focus listener
    this.unsubscribe = this.props.navigation.addListener("focus", () => {
      setTimeout(this.fetchNotificationCount, 1500);
    });
  }

  componentWillUnmount() {
    if (this.unsubscribe) this.unsubscribe();
    if (this.state.intervalId) clearInterval(this.state.intervalId);
  }

  fetchNotificationCount = () => {
    this.props.generalAction(
      API_NOTIFICATION_COUNT,
      { user_id: this.props.user.id },
      DUMP.SUCCESS,
      DUMP.FAILURE,
      ({ notification_count }) => {
        this.props.navigation.setParams({
          showInfo: notification_count > 0 ? true : false,
        });
      },
      () => {},
      true
    );
    this.loadData();
    const intervalId = setInterval(this.loadData, 5000);
    this.setState({ intervalId });
  };

  loadData = () => {
    this.props.generalAction(
      API_INACTIVE,
      { user_id: this.props.user.id },
      DUMP.SUCCESS,
      DUMP.FAILURE,
      (data) => {
        data.map((item) => {
          if (item.is_account_active == 0) {
            this.sendData();
          }
          Utils.setLunchValue(item.Lunch_value);
          Utils.setHelpLine(item.help_line);
        });
      },
      () => {},
      true
    );
  };

  sendData = () => {
    NavService.navigate("Login");
    Utils.showError("Your account is inactive, please contact Medicashift");
    clearInterval(this.state.intervalId);
  };

  appUpdateApi = () => {
    axios
      .get(BASE_URL + GET_UPDATE, {
        headers: {
          token: "api.Pd*!(5675",
          api_version: "1.0",
          api_client: "android",
        },
      })
      .then((response) => {
        const codeval = response.data.success;
        const val = response.data.message;
        if (codeval == 200) {
          const codetype = response.data.code;
          if (codetype == "store") {
            this.setState({ isupdate_store: true, messageval: val });
          } else if (codetype == "popup") {
            this.setState({ isupdate_popup: true, messageval: val });
          } else if (codetype == "logout") {
            this.setState({ isupdate_logout: true, messageval: val });
          }
        }
      })
      .catch((error) => console.log(error));
  };

  getPercentageValue = () => {
    this.props.generalAction(
      API_PERCENTAGE,
      null,
      DUMP.SUCCESS,
      DUMP.FAILURE,
      this.cbSuccess,
      this.cbFailure,
      true
    );
  };

  cbSuccess = (response) => {
    const { percentage_value } = response;
    this.props.generalSaveAction(ADMIN_FEE_AMOUNT, { amount: percentage_value });
    Utils.setAdminFee(percentage_value);
  };

  cbFailure = () => {};

  showModal = () => this.Modal.setModalVisible(true);
  hideModal = () => this.Modal.setModalVisible(false);

  modalCard = (label) => {
    const { is_stripe_key, is_profile_verified } = this.props.user;
    let aWord = label.slice(label.lastIndexOf(" ") + 1).toLowerCase();
    let goTo = aWord.charAt(0).toUpperCase() + aWord.substring(1);

    return (
      <TouchableOpacity
        elevation={15}
        style={styles.inputModalWrapper}
        onPress={() => {
          this.hideModal();
          setTimeout(() => {
            if (!is_stripe_key) {
              Utils.showAlert(
                "Account details",
                "You have to provide your card details in order to post a Shift or Contract",
                () => NavService.navigate("PaymentMethod")
              );
            } else if (is_profile_verified !== 2) {
              Utils.showAlert(
                "Profile Verification",
                "Your Profile need to be verified in order to post a Shift or Contract",
                () => NavService.navigate("Profile")
              );
            } else {
              NavService.navigate("Category", { goTo });
            }
          }, 500);
        }}
      >
        <Image
          style={{ marginBottom: Metrics.doubleBaseMargin }}
          source={Images.post_add}
        />
        <Text>{label}</Text>
        <View style={[styles.triangleCorner, { transform: [{ rotate: "270deg" }] }]} />
      </TouchableOpacity>
    );
  };

  renderModal = () => (
    <TouchableWithoutFeedback>
      <View style={{ width: "85%" }}>
        <View
          elevation={15}
          style={[styles.inputWrapper, { justifyContent: "space-between", paddingVertical: Metrics.baseMargin }]}
        >
          <Text style={{ marginLeft: "35%" }}>POST A JOB</Text>
          <TouchableOpacity style={{ padding: 10 }} onPress={this.hideModal}>
            <Image source={icons.ic_cross} />
          </TouchableOpacity>
        </View>
        <View style={{ flexDirection: "row", justifyContent: "space-between" }}>
          {this.modalCard("POST A SHIFT")}
          {this.modalCard("POST A CONTRACT")}
        </View>
      </View>
    </TouchableWithoutFeedback>
  );

  renderProfileWarning() {
    const { is_stripe_key, is_profile_verified } = this.props.user;
    return (
      <Fragment>
        {!is_stripe_key &&
          is_profile_verified !== 2 &&
          this.renderWarningText("bothWarning")}
        {is_stripe_key &&
          is_profile_verified !== 2 &&
          this.renderWarningText("profileWarning")}
        {!is_stripe_key &&
          is_profile_verified == 2 &&
          this.renderWarningText("accountDetailWarning")}
      </Fragment>
    );
  }

  renderWarningText(warningText) {
    return (
      <View style={styles.containerWarning}>
        <Text style={{ color: "white" }}>{this.state[warningText]}</Text>
      </View>
    );
  }

  sendDataLogout = () => {
    NavService.navigate("Login");
    this.props.generalDispatchType(LOGOUT);
    clearInterval(this.state.intervalId);
  };

  render() {
    const { isNetworkConnected } = this.props.networkInfo;
    const { isupdate_store, isupdate_logout, messageval, isupdate_popup } =
      this.state;

    return (
      <View style={{ flex: 1 }}>
        <ScrollView style={styles.container}>
          {this.renderProfileWarning()}
          <Image source={Images.bgFacilityHome} />
          <View style={{ width: "85%", alignSelf: "center" }}>
            <View style={{ flexDirection: "row", justifyContent: "space-between" }}>
              <SquareCard
                text="POST A SHIFT / CONTRACT"
                icon={Images.PostShift}
                onClick={this.showModal}
              />
              <SquareCard
                text="MY SHIFT / CONTRACT"
                icon={Images.MyShift}
                onClick={() => NavService.navigate("MyShiftsContracts")}
              />
            </View>

            <View elevation={15} style={[styles.inputWrapper, { marginBottom: 40 }]}>
              <TouchableOpacity
                onPress={() => NavService.navigate("OnboardProjects")}
                style={{
                  flex: 1,
                  flexDirection: "row",
                  justifyContent: "center",
                  alignItems: "center",
                  paddingVertical: Metrics.doubleBaseMargin,
                }}
              >
                <Image source={Images.on_board_job} />
                <Text>ON BOARD SHIFTS</Text>
              </TouchableOpacity>
            </View>
          </View>

          <ReusableModal ref={(ref) => (this.Modal = ref)}>
            <TouchableWithoutFeedback onPress={this.hideModal}>
              <View blurRadius={1} style={styles.modaContainer}>
                <View style={{ flex: 1, justifyContent: "center", alignItems: "center" }}>
                  {this.renderModal()}
                </View>
              </View>
            </TouchableWithoutFeedback>
          </ReusableModal>

          {/* Store Update Modal */}
          {isupdate_store && (
            <Modal transparent>
              <View
                style={{
                  flex: 1,
                  ...AppStyles.centerAligned,
                  backgroundColor: "rgba(0,0,0,0.2)",
                }}
              >
                <View
                  style={{
                    backgroundColor: "white",
                    paddingVertical: Metrics.ratio(50),
                    paddingHorizontal: Metrics.baseMargin,
                    borderRadius: Metrics.baseMargin,
                    ...AppStyles.centerAligned,
                    marginHorizontal: Metrics.doubleBaseMargin,
                  }}
                >
                  <AppUpdate {...this.props} valueset={this.state.urlvalue} />
                </View>
              </View>
            </Modal>
          )}

          {/* Logout & Popup Modals */}
          {isupdate_logout && this.renderUpdateModal("Reason for Logout", messageval, this.sendDataLogout)}
          {isupdate_popup &&
            this.renderUpdateModal("Reason for Maintenance", messageval, () => BackHandler.exitApp())}

          <NetInfoModal isNetworkConnected={isNetworkConnected} />
        </ScrollView>

        <Supporticon clickBtn={() => NavService.navigate("Support")} />
      </View>
    );
  }

  renderUpdateModal(title, message, onPress) {
    return (
      <Modal transparent>
        <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }}>
          <View
            style={{
              backgroundColor: "white",
              paddingVertical: Metrics.ratio(50),
              paddingHorizontal: Metrics.baseMargin,
              borderRadius: Metrics.baseMargin,
              ...AppStyles.centerAligned,
              marginHorizontal: Metrics.doubleBaseMargin,
            }}
          >
            <View style={styles.updateview}>
              <Text
                style={{
                  padding: 10,
                  fontFamily: "Gibson",
                  ...UIFont.font(fonts.semiBold, fontSize.xLarge, colors.BlackColor),
                  fontSize: 20,
                  alignSelf: "center",
                }}
              >
                {title}
              </Text>

              <Text
                style={{
                  color: "black",
                  padding: 10,
                  fontFamily: "Gibson",
                  ...UIFont.font(fonts.regular, fontSize.medium, colors.BlackColor),
                  fontSize: 20,
                  alignSelf: "baseline",
                }}
              >
                {message}
              </Text>

              <TouchableOpacity
                activeOpacity={1.0}
                style={styles.modalverifyFooter}
                onPress={onPress}
              >
                <Text
                  style={{
                    color: "#fff",
                    textAlign: "center",
                    ...UIFont.font(fonts.semiBold, fontSize.medium, colors.WhiteColor),
                    padding: 10,
                  }}
                >
                  OK
                </Text>
              </TouchableOpacity>
            </View>
          </View>
        </View>
      </Modal>
    );
  }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, networkInfo }) => ({
  user: user.data,
  networkInfo,
});

const composeShiftHome = compose(
  connect(mapStateToProps, actions)(WithNetInfoListener(ShiftHome))
);

export default composeShiftHome;

const styles = StyleSheet.create({
  container: { flex: 1 },
  modaContainer: { flex: 1, backgroundColor: "rgba(0,0,0,0.5)" },
  containerWarning: {
    height: 40,
    width: "100%",
    backgroundColor: "red",
    justifyContent: "center",
    alignItems: "center",
    paddingHorizontal: 20,
  },
  triangleCorner: {
    backgroundColor: "transparent",
    borderStyle: "solid",
    borderRightWidth: 20,
    borderTopWidth: 20,
    borderRightColor: "transparent",
    borderTopColor: "#e0535e",
    position: "absolute",
    left: 0,
    bottom: 0,
  },
  inputWrapper: {
    width: "100%",
    alignItems: "center",
    flexDirection: "row",
    marginTop: Metrics.doubleBaseMargin,
    backgroundColor: colors.WhiteColor,
    borderRadius: 6,
    shadowColor: colors.BlackColor,
    shadowOpacity: 0.8,
    shadowRadius: 20,
    shadowOffset: { height: 5, width: 5 },
    justifyContent: "space-around",
  },
  inputModalWrapper: {
    width: "48.5%",
    alignItems: "center",
    marginTop: Metrics.baseMargin,
    backgroundColor: colors.WhiteColor,
    borderRadius: 6,
    shadowColor: colors.BlackColor,
    shadowOpacity: 0.8,
    shadowRadius: 20,
    shadowOffset: { height: 5, width: 5 },
    paddingVertical: Metrics.xDoubleBaseMargin,
  },
  updateview: {
    justifyContent: "flex-end",
    width: "85%",
    backgroundColor: "white",
    padding: 5,
    borderTopLeftRadius: 5,
    borderTopRightRadius: 5,
  },
  modalverifyFooter: {
    backgroundColor: "#bb050c",
    borderRadius: 5,
    margin: 30,
  },
});
