import React, { PureComponent } from "react";
import { Text, TouchableWithoutFeedback, View } from "react-native";
import { Modal } from "../../components";

const addresses = [
  "lorem ipsum",
  "lorem ipsum",
  "lorem ipsum",
  "lorem ipsum",
  "lorem ipsum",
  "lorem ipsum",
  "lorem ipsum"
];

class PostTypeSelection extends PureComponent {
  setModalVisibility = isModalVisible =>
    this.modal.setModalVisibility(isModalVisible);

  hideModal = () => this.modal.setModalVisibility(false);

  onAddressSelected = address => ev => {
    const { cbOnAddressSelected } = this.props;
    cbOnAddressSelected(address);
    this.hideModal();
  };

  render() {
    const { children } = this.props;
    return <Modal ref={ref => (this.modal = ref)}>{children}</Modal>;
  }
}

const styles = {
  container: { backgroundColor: "red", flex: 1 }
};

export default PostTypeSelection;
