import React, { Component, Fragment } from "react";
import {
    View,
    Text,
    ImageBackground,
    TouchableOpacity,
    Image,
    TextInput,
    ScrollView,
    Platform
} from "react-native";
import {
    TextFieldBorder,
    AppButton,
    TextLabel,
    ButtonView,
    FormHandler,
    Input,
    NetInfoModal, Supporticon
} from "../../components";
import _ from "lodash";
import { pop, push, popToTop } from "../../services/NavigationService";
import { Images, icons, colors } from "../../assets";
import ActionSheet from "react-native-actionsheet";
import MediaPicker from "../../services/MediaPicker";
import Metrics from "../../services/Metrics";
import { connect } from "react-redux";
import { compose } from "redux";
import DateTimePicker from '@react-native-community/datetimepicker';
import DatePicker from "react-native-datepicker";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import { API_SIGN_UP_CONTRACTOR, IMAGE_BASE_URL, POST_API_RESGISTER_STEP1 } from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { USER } from "../../actions/ActionTypes";
import { WithFetching, WithNetInfoListener } from "../../HOC";
import Notification from "../../services/Notification";
import Utils from "../../Utils";
import Colors from "../../services/Colors";
import moment from "moment";
import styles from "./styles";
import PhoneInput from "react-native-phone-input";

class SignUpContractor extends Component {


    state = {
        email: this.props.route.params.data_gmail == undefined ? '' :
            this.props.route.params.data_gmail.email,

        categoryList: ["Apple", "Banana", "cancel"],
        showpaswd: this.props.route.params.data_gmail == undefined ? false :
            true,
        indexOfDropdown: 0,
        userName: this.props.route.params.data_gmail == undefined ? '' :
            this.props.route.params.data_gmail.name,

        licenceImagesArr: [{ uri: Images.addImage }],
        otherDocumentImagesArray: [{ uri: Images.addImage }],
        otherDocumentText:
            "Upload Documents such as CPR Cards/ First Aid, Certificates/License, Driver’s License etc.",
        category_id: 0,
        dobDate: "",
        isError: false,
        showdate: false,
        agreeWith: false,
        mobilePhone: '',
        image_url: Images.cardImage,

        fcmToken: '',
        dob: '',
        genderArr: [
            { value: "Select...", id: 0 },
            { value: "Male", id: 1 },
            { value: "Female", id: 2 },
            { value: "cancel" },
        ],
        gender: "",
        isDetailsEdited: false,
        indexGender: 0,


    };


    componentDidMount() {

        //    var data_get  ;

        // this.props.route.params.data_gmail == undefined ?{}:

        //    data_get = this.props.route.params.data_gmail.email
        //    this.setState({email: data_get });

        const { categories } = this.props;
        let categoryList = [];
        categories.map(elem => {
            if (elem.child_categories_count === "0") {
                categoryList.push({
                    value: elem.parent_category.category_name,
                    id: elem.parent_category.id
                });
            }
            if (typeof elem.child_categories_count == "number") {
                elem.child_categories.map(el => {
                    categoryList.push({ value: el.category_name, id: el.id });
                });
            }
        });
        categoryList.push({ value: "cancel" });
        categoryList.unshift({ value: "Categories..." });
        this.setState({ categoryList, category_id: categoryList[0].id });

        //set fcm token
        Notification.fcmToken(token => {
            this.setState({
                fcmToken: token
            });
        });


    }

    onSignUp = () => {
        const { dobDate, } = this.state;

        const formData = this.formHandlerUser.onSubmitForm();
    
        if (formData) {
            this.signUpRequest(formData, dobDate)
        }
        else {

            this.setState({ isError: true });

        }

    };

    signUpRequest = (formData, dobDate) => {
        const {
            gender, image_url,
            fcmToken,
            mobilePhone
        } = this.state;

        if (mobilePhone) {

            let payload = new FormData();
            payload.append("full_name", formData.userName);
            payload.append("email", formData.email);
            payload.append("mobile_no", mobilePhone);
            payload.append("password", !this.state.showpaswd ? formData.password : "");
            payload.append("dob", dobDate);
            payload.append("gender", gender);
            payload.append("login_type", 1);
            payload.append("user_type", "Contractor");
            payload.append("account_status", "inactive");
            payload.append("device_type", Utils.isPlatformAndroid() ? "android" : "ios");
            payload.append("device_token", fcmToken);
            Number.isInteger(image_url) ? payload.append("image_url", "") :
                payload.append("image_url", {
                    uri: image_url,
                    type: "image/png",
                    name: "medical_license_card_image",
                });

            this.props.cbShowLoader(true);

            this.props.generalAction(
                POST_API_RESGISTER_STEP1,
                payload,
                USER.SUCCESS,
                USER.FAILURE,
                this.onSignUpSuccess,
                this.onSignUpFailure
            );


        } else {

            this.setState({ isError: true });
        }

    };

    onSignUpSuccess = user => {
        Utils.setUserID(user.id);
        this.props.cbShowLoader(false);
        console.log(user)
        var user_ID = user.id;
        push("professionalDetails", { user_ID });
    };

    onSignUpFailure = err => {
        this.props.cbShowLoader(false);
        Utils.showError(err);
    };

    avatar = () => {
        const { image_url } = this.state;

        return (
            <View style={styles.avatarStyle}>
                <Image
                    source={
                        typeof image_url === "string"
                            ? { uri: image_url }
                            : image_url
                    }
                    style={styles.imgStyle}
                    zIndex={999}
                />
                <TouchableOpacity
                    style={styles.iconStyle}
                    onPress={this.onImageAddimage}
                >
                    <Image resizeMode="contain" source={icons.add_image} />
                </TouchableOpacity>
            </View>
        );
    };


    onImagePicked = (uri, imageObj, str) => {
        this.onImageResize(uri, str);
    };

    onImageResize = (uri, str) => {
        MediaPicker.resizeImage(uri)
            .then(imageObj =>
                this.setState({
                    [str]: [...this.state[str], { ...imageObj }]
                })
            )
            .catch(err => console.log("err : ", err));
    };

    onImageAdd = str => ev => {
        MediaPicker.showPicker((uri, imageObj) =>
            this.onImagePicked(uri, imageObj, str)
        );
    };

    onImagePickedimage = (uri, imageObj) => {
        this.onImageResizeimage(uri);

    };

    onImageResizeimage = uri => {

        MediaPicker.resizeImage(uri)
            .then(imageObj =>
                this.setState({
                    image_url: uri,
                    isDpEdited: true
                })
            )
            .catch(err => console.log("err : ", err));

    };

    onImageAddimage = ev => {

        MediaPicker.showPicker((uri, imageObj) =>
            this.onImagePickedimage(uri, imageObj)
        );

    };
    renderError(err, obj) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }
    render() {
        const { isNetworkConnected } = this.props.networkInfo;

        const { dateInput, dateText, datePickerStyle, disabledColor } = styles;

        return (
            <ImageBackground style={styles.bgImage}>
                {/* <View style={styles.divForUpperSpace} />
                <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
                    <Text style={[styles.heading, styles.boldHeading]}>
                        Sign up{" "}
                    </Text>
                    <Text style={styles.heading}>as a</Text>
                </View>
                <Text style={[styles.heading, { marginLeft: 25 }]}>
                    Staff
                </Text>
                <View style={styles.divForMidSpace} /> */}
                {this.formWrapper()}

                <Supporticon
                    clickBtn={() => push("SupportLogin")} />
                <NetInfoModal isNetworkConnected={isNetworkConnected} />


            </ImageBackground>
        );
    }

    dropDown() {
        const { genderArr, indexOfDropdown, category_id } = this.state;
        return (
            <React.Fragment>
                <TouchableOpacity
                    style={[
                        styles.emailAddressTextField,
                        styles.actionSheetView
                    ]}
                    onPress={this.showActionSheet}
                >
                    <Text
                        style={
                            !indexOfDropdown
                                ? styles.textInputStyle
                                : styles.selectedDropdownText
                        }
                    >
                        {genderArr[indexOfDropdown].value}
                    </Text>
                    <Image style={styles.imageIcon} source={icons.ic_expand} />
                </TouchableOpacity>
                <ActionSheet
                    ref={o => (this.ActionSheet = o)}
                    options={genderArr.map(elem => elem.value)}
                    cancelButtonIndex={genderArr.length - 1}
                    onPress={index => {
                        if (index !== genderArr.length - 1) {
                            this.setState({
                                indexOfDropdown: index,
                                category_id: genderArr[index].id,
                                gender: genderArr[index].value,
                                //  isError: false
                            });
                        }
                    }}
                />
                {/* {(genderArr[indexOfDropdown].value == "Select..." ||
                    category_id == 0) &&
                    this.renderError("Gender is required", {
                        marginTop: -25
                    })} */}

            </React.Fragment>
        );
    }



    showActionSheet = () => {
        this.ActionSheet.show();
    };
    // showActionSheet = (func) => {

    //         func.show();

    // };
    onImageRemove = (index, str) => ev => {
        let images = [...this.state[str]];
        images.splice(index, 1);
        this.setState({ [str]: images });
    };

    labelText = (label, topMargin = {}) => {
        return (
            <TextLabel color={"black"} style={[styles.textLabelgender, topMargin]}>
                {label}
            </TextLabel>
        );
    };

    formHandler = () => {
        const { mobilePhone, email, userName } = this.state;

        return (
            <FormHandler ref={ref => (this.formHandlerUser = ref)}>
                <Input
                    placeholder="Full Name"
                    error="Name is required"
                    type={INPUT_TYPES.TEXT}
                    identifier="userName"
                    blurOnSubmit={false}
                    maxLength={25}
                    value={userName}
                    textFieldStyle={styles.emailAddressTextField}
                    rightTextFieldImage={icons.person}
                />
                <Input
                    placeholder="Email"
                    error="Email is required"
                    type={INPUT_TYPES.EMAIL}
                    identifier="email"
                    blurOnSubmit={false}
                    value={email}
                    textFieldStyle={styles.emailAddressTextField}
                    rightTextFieldImage={icons.email}
                />

                {!this.state.showpaswd ?
                    <Input
                        placeholder="Password"
                        error="Password is required"
                        type={INPUT_TYPES.PASSWORD}
                        identifier="password"
                        blurOnSubmit={true}
                        textFieldStyle={styles.passwordTextField}
                        rightTextFieldImage={icons.key}
                    /> : null}

            </FormHandler>
        );
    };

    formHandler2 = () => {
        return (
            <FormHandler ref={ref => (this.formHandlerUser2 = ref)}>
                <Input
                    placeholder="Expiry Date"
                    error="Expiry Date is required"
                    type={INPUT_TYPES.TEXT}
                    identifier="expiryDate"
                    blurOnSubmit={false}
                    textFieldStyle={styles.emailAddressTextField}
                    value={""}
                />
            </FormHandler>
        );
    };

    renderError(err, obj) {

        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }

    }


    phoneview = () => {

        const { mobilePhone } = this.state;

        return (
            <View>
                <PhoneInput
                    style={[styles.emailAddressTextField, { height: 50 }]}
                    initialValue={mobilePhone}

                    onChangePhoneNumber={text =>
                        this.setState({ mobilePhone: text })
                    }
                    initialCountry={'us'}
                    // ref={ref => {
                    //     this.phone = ref;
                    // }}
                />
                {!mobilePhone && this.renderError(`Mobile Number is required`)}
            </View>
        )
    }

    formPassword = () => {
        const { mobilePhone, email, showpaswd } = this.state;

        return (
            <FormHandler ref={ref => (this.formHandlerUser = ref)}>
                {!showpaswd ?
                    <Input
                        placeholder="Password"
                        error="Password is required"
                        type={INPUT_TYPES.PASSWORD}
                        identifier="password"
                        blurOnSubmit={true}
                        textFieldStyle={styles.passwordTextField}
                        rightTextFieldImage={icons.key}
                    /> : null}

            </FormHandler>
        );
    };

    formWrapper() {

        return (
            <View style={{ flex: 6 }}>
                <ScrollView   showsHorizontalScrollIndicator={false}
                        keyboardShouldPersistTaps="always"
                    contentContainerStyle={styles.inputWrapper}>

                    {this.avatar()}

                    {this.formHandler()}

                    {this.phoneview()}

                    {/* {this.formPassword()} */}

                    {this.labelText("Gender ")}

                    {this.dropDown()}

                    {Utils.isPlatformAndroid() ?
                        <TouchableOpacity style={styles.viewstyle}
                            onPress={showdate => {
                                this.setState({ showdate: true });
                            }}>

                            <View style={styles.passwordContainer}>
                                <TextInput
                                    style={styles.inputStyle}
                                    editable={false}
                                    selectTextOnFocus={false}
                                    placeholder="Date of Birth"
                                    value={this.state.dobDate}
                                />
                                <Image style={styles.ImageStyle}
                                    source={icons.reg_calendar}
                                    size={10}
                                />
                            </View>
                        </TouchableOpacity> :
                        this.datePickermodel("Date of Birth",
                            icons.ic_calender, "date")
                    }

                    {this.state.showdate == true ?
                        this.datePickerandorid() : null}

                    {(!this.state.dobDate || this.state.dobDate >= moment().format("YYYY-MM-DD")) &&
                        this.renderError(
                            !this.state.dobDate
                                ? "Date of Birth is required"
                                : "The date is not valid",
                            {}
                        )}
                    <View style={styles.divForButtonSpace} />
                    <AppButton
                        buttonTitle="Next"
                        style={{
                            backgroundColor: colors.ActiveTabTitle,
                            width: "50%"
                        }}
                        btnColor={colors.cardColor}
                        onPress={() => {
                            this.onSignUp();
                        }}
                    />


                </ScrollView>
            </View>
        );
    }

    datePickerandorid() {
        const { dobDate } = this.state;
        return (

            <View>

                <DateTimePicker
                    style={{
                        borderBottomWidth: 1,
                        borderColor: Colors.textfieldBorder,
                        width: Platform.OS ? 345 : 350

                    }}
                    date={dobDate}
                    mode={'date'}
                    dateFormat="YYYY-MM-DD"
                    maximumDate={new Date()}
                    // maximumDate={new Date(moment().subtract(20, "years"))}
                    value={new Date()}
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"

                    is24Hour={true}
                    customStyles={{
                        dateInput: {
                            borderWidth: 0,
                            justifyContent: "flex-start",
                            alignItems: "flex-start",
                            paddingTop: 6,
                            paddingLeft: 10
                        },
                        dateText: {
                            color: "#241332"
                        }
                    }}
                    onChange={this.handleChangeAndroid}

                />

            </View>
        );
    }
    agreementPart = () => {
        return (
            <Fragment>
                <View style={{ flexDirection: "row" }}>
                    <TouchableOpacity
                        style={{ padding: 5, marginTop: 20 }}
                        onPress={() => {
                            this.setState({
                                agreeWith: !this.state.agreeWith
                            });
                        }}
                    >
                        <Image
                            source={
                                this.state.agreeWith
                                    ? icons.ic_check
                                    : icons.ic_uncheck
                            }
                        />
                    </TouchableOpacity>
                    <TouchableOpacity onPress={() => push("termsNCondtions")}>
                        <Text style={[styles.otherDocument, { marginTop: 28 }]}>
                            I agree to the{" "}
                            <Text style={{ color: "blue" }}>
                                terms and conditions{" "}
                            </Text>
                            of the contract
                        </Text>
                    </TouchableOpacity>
                </View>
                {!this.state.agreeWith &&
                    this.renderError(
                        "You must agree to the terms and conditions of the contract before you sign up.",
                        {}
                    )}



            </Fragment>
        );
    };

    handleChangeAndroid = (event, selectedDate) => {

        const dateset = moment(selectedDate).format("YYYY-MM-DD");


        const age = moment().diff(moment(dateset), 'years');

        // "type": "dismissed" set

        const typeval = event.type;

        typeval == "set" ?

            age > 17 ? this.setState({ showdate: false, dobDate: dateset })

                : Utils.showError("Please select 18 years above")

            : this.setState({ showdate: false });


    }

    handleChange = (date) => {


        const age = moment().diff(moment(date), 'years');


        if (age > 17) {
            this.setState({ dobDate: date });
        }
        else {
            Utils.showError("Please select 18 years above");
        }


    }

    datePickermodel(title, icon, dateTime) {
        const { dobDate } = this.state;
        return (
            <View>
                <DatePicker
                    style={{
                        borderBottomWidth: 1,
                        borderColor: Colors.textfieldBorder,
                        width: Platform.OS ? 345 : 350

                    }}
                    date={dobDate}
                    mode={dateTime}
                    placeholder={title}
                    placeholderText={Colors.textfieldBorder}
                    format="YYYY-MM-DD"
                    // maxDate={new Date(moment().subtract(20, "years"))}
                    maxDate={moment().format("YYYY-MM-DD")}
                    // maxDate="2026-12-25"
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    showIcon={true}
                    customStyles={{
                        dateInput: {
                            borderWidth: 0,
                            justifyContent: "flex-start",
                            alignItems: "flex-start",
                            paddingTop: 6,
                            paddingLeft: 10
                        },
                        dateText: {
                            color: "#241332"
                        }
                    }}
                    onDateChange={this.handleChange}
                />

                {(!dobDate || dobDate >= moment().format("YYYY-MM-DD")) &&
                    this.renderError(
                        !dobDate
                            ? "Date of Birth is required"
                            : "The date is not valid",
                        {}
                    )}



            </View>
        );
    }
}



const actions = { generalAction };
const mapStateToProps = ({ categories, networkInfo }) => {
    return {
        categories: categories.data,
        networkInfo
    };
};

const ComponentWithComposeFunc = compose(
    connect(
        mapStateToProps,
        actions
    )(WithFetching(WithNetInfoListener(SignUpContractor)))
);

export default ComponentWithComposeFunc;

ComponentWithComposeFunc.navigationOptions = ({ navigation }) => {
    return {
        title: "Personal Details",
        headerStyle: styles.header,
        headerTitleStyle: styles.toolbarTitle,
        headerLeft: (
            <TouchableOpacity onPress={() => popToTop()}>
                <Image
                    style={{ margin: 10 }}
                    resizeMode="contain"
                    source={Images.backArrow}
                />
            </TouchableOpacity>
        ),
        headerRight: (
            <View
                style={{
                    backgroundColor: colors.HeaderColor,
                    width: "10%"
                }}
            />
        )
    };
};
