import { StyleSheet, Platform } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
import Fonts from "../../services/Fonts";

const centerAligned = { alignItems: "center", justifyContent: "center" };

export default StyleSheet.create({
    headerTitle: {
        color: colors.HeaderTitleColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    toolbarTitle: {
        color: colors.WhiteColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 2,
        fontWeight: "bold",
    },
    passwordContainer: {
        flexDirection: 'row',
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder,
        paddingBottom: 10,
    },
    inputStyle: {
        flex: 1,
        color:colors.BlackColor,
    },
    viewstyle: {
        flex: 1,
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",

    },
    ImageStyle: {
        padding: 10,
        margin: 5,
        height: 30,
        width: 30,
        resizeMode: 'stretch',
        alignItems: 'center',
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        textAlign: "center",
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    bgImage: {
        justifyContent: "space-between",
        alignItems: "center",
        flexDirection: "column",
        flex: 1
    },
    imageIcon: {
        marginTop: Metrics.baseMargin
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        paddingBottom: Metrics.xDoubleBaseMargin,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        padding: 20
    },
    divForButtonSpace: {
        margin: Metrics.baseMargin
    },
    iconStyle: {
        width: 33,
        height: 33,
        borderRadius: 16.5,
        position: "absolute",
        bottom: 0,
        right: 0,
        zIndex: 999
    },
    avatarStyle: {
        position: "relative",
        alignSelf: "center",
        ...Platform.select({
            ios: {
                zIndex: 999
            }
        })
    },
    imgStyle: {
        width: 100,
        height: 100,
        borderRadius: 50,
        borderColor: colors.BlueColor,
        borderWidth: 3,
        shadowColor: colors.BlackColor,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        marginTop: 10,
        backgroundColor: "white",
        zIndex: 999
    },
    boldHeading: {
        ...UIFont.font(fonts.semiBold, fontSize.huge, colors.WhiteColor),
        alignSelf: "flex-start",
        marginLeft: 25
    },
    heading: {
        ...UIFont.font(fonts.regular, fontSize.huge, colors.WhiteColor),
        alignSelf: "flex-start"
    },
    divForUpperSpace: { flex: 0.2 },
    divForMidSpace: { flex: 0.2 },
    bottomText: {
        color: colors.LoginBottomText,
        fontSize: 16
    },
    registerText: {
        color: colors.BlackColor
    },
    emailAddressTextField: {
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
        borderColor: Colors.textfieldBorder,
        borderBottomWidth: 1
    },
    passwordTextField: {
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
        borderColor: Colors.textfieldBorder,
        borderBottomWidth: 1,
       // marginTop: 10
    },
    textInputStyle: {
        ...UIFont.font(fonts.reqular, fontSize.small, Colors.textfieldBorder),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    selectedDropdownText: {
        ...UIFont.font(fonts.reqular, fontSize.small, "#241332"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    actionSheetView: {
        flex: 1,
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin + Metrics.smallMargin,
        marginBottom: Metrics.baseMargin + Metrics.smallMargin
    },
    heading2: {
        fontSize: 15,
        marginLeft: 25,
        color: colors.WhiteColor,
        fontWeight: "normal"
    },
    backArrow: {
        flex: 0.45,
        alignSelf: "flex-start",
        marginTop: 8,
        marginLeft: 8
    },
    container: {
        flex: 1,
        backgroundColor: Colors.background.primary,
        alignSelf: "flex-start",
        paddingTop: Metrics.baseMargin
    },
    rowContainer: {
        flexDirection: "row",
        flexWrap: "wrap"
    },
    leftAlign: {
        position: "absolute",
        left: Metrics.ratio(6),
        top: Metrics.ratio(4)
    },
    rightAlign: {
        position: "absolute",
        right: Metrics.ratio(6),
        top: Metrics.ratio(4)
    },
    imageAdderContainer: {
        width: "100%",
        height: "100%",
        marginTop: 10,
        ...centerAligned,
        borderRadius: Metrics.smallMargin
    },
    imageAlignmentWrapper: {
        width: Metrics.halfScreenWidth - Metrics.xDoubleBaseMargin,
        height: 100,
        padding: Metrics.smallMargin
    },
    pickedImage: {
        width: "100%",
        height: "100%"
    },
    removeImageWrapper: {
        ...centerAligned,
        position: "absolute",
        top: 0,
        zIndex: 2,
        right: 0
    },
    textLabel: {
        ...UIFont.font(fonts.bold, fontSize.medium, colors.BlackColor),
        alignSelf: "flex-start",
        lineHeight: 21,
        letterSpacing: 0
    },

    textLabelgender: {
        ...UIFont.font(fonts.semiBold, fontSize.medium, colors.BlackColor),
        alignSelf: "flex-start",
        lineHeight: 21,
        marginTop: 10,
        letterSpacing: 0
    },
    imageContainer: {
        width: "100%",
        height: "100%",
        marginTop: 10
    },
    otherDocument: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, colors.BlackColor),
        lineHeight: 16,
        letterSpacing: 0,
        textAlign: "left",
        marginTop: 20
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    }
});
