import React, { Component } from "react";
import {
  View,
  Text,
  ImageBackground,
  TouchableOpacity,
  Image,
  ScrollView
} from "react-native";
import { connect } from "react-redux";
import { compose } from "redux";
import {
  TextFieldBorder,
  AppButton,
  FormHandler,
  Input,
  NetInfoModal,Supporticon
} from "../../components";
import { pop, push, popToTop } from "../../services/NavigationService";
import { Images, icons, colors } from "../../assets";
import { INPUT_TYPES } from "../../components/FormHandler/Constants";
import { API_SIGN_UP_FACILITY } from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { USER } from "../../actions/ActionTypes";
import { WithFetching, WithNetInfoListener } from "../../HOC";
import Notification from "../../services/Notification";
import Utils from "../../Utils";
import styles from "./styles";
import PhoneInput from "react-native-phone-input";

class SignUpFacility extends Component {
  state = {
    email: "",
    mobilePhone: '',
    isError: false,
    fcmToken: ''
  };

  componentDidMount() {
    Notification.fcmToken(token => {
      this.setState({
        fcmToken: token
      });
    });
  }

  onSignUp = () => {
    const formData = this.formHandlerUser.onSubmitForm();
    formData && this.signUpRequest(formData);
  };

  signUpRequest = formData => {
    const { mobilePhone, fcmToken } = this.state;
    if (mobilePhone) {
      this.props.cbShowLoader(true);

      let payload = new FormData();
      payload.append("full_name", formData.userName);
      payload.append("email", formData.email);
      payload.append("mobile_no", mobilePhone);
      payload.append("password", formData.password);
      payload.append("user_type", "Facility");
      payload.append("device_type", Utils.isPlatformAndroid() ? "android" : "ios");
      payload.append("device_token", fcmToken);

      this.props.generalAction(
        API_SIGN_UP_FACILITY,
        payload,
        USER.SUCCESS,
        USER.FAILURE,
        this.onSignUpSuccess,
        this.onSignUpFailure
      );

    } else {
      this.setState({ isError: true });
    }
  };

  onSignUpSuccess = user => {
    Utils.setUserToken(user.token);
    Utils.setUserType(user.user_type);
    Utils.setUserLoggedIn(true);

    // Use setTimeout to ensure Redux state is updated before hiding loader
    setTimeout(() => {
      this.props.cbShowLoader(false);
    }, 100);
  };
  onSignUpFailure = err => {
    this.props.cbShowLoader(false);
    Utils.showError(err);
  };

  render() {
    const { isNetworkConnected } = this.props.networkInfo;
    return (
      <ImageBackground source={Images.bgImage} style={styles.bgImage}>
        <View style={styles.divForUpperSpace} />
        <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
          <Text style={[styles.heading, styles.boldHeading]}>Sign up</Text>
          <Text style={styles.heading}> as a</Text>
        </View>
        <Text style={[styles.heading, { marginLeft: 25 }]}>
          Facility <Text style={styles.heading2}> (Post an Opening) </Text>
        </Text>
        <View style={styles.divForMidSpace} />
        {this.formWrapper()}
        <View style={styles.divForAnotherSpace} />
        <View style={styles.divForBottomSpace} />
        <NetInfoModal isNetworkConnected={isNetworkConnected} />

        <Supporticon
                 clickBtn={() =>push("SupportLogin")}/>
      </ImageBackground>
    );
  }
  renderError(err, obj = { marginTop: 4 }) {
    if (this.state.isError) {
      return <Text style={[styles.error, obj]}>{err}</Text>;
    }
  }
  formWrapper() {
    const { mobilePhone } = this.state;
    return (
      <ScrollView elevation={15}    contentContainerStyle={styles.inputWrapper}>
        <FormHandler ref={ref => (this.formHandlerUser = ref)}>
          
          <Input
            placeholder="Facility Name"
            error="Name is required"
            type={INPUT_TYPES.TEXT}
            identifier="userName"
            blurOnSubmit={false}
            value={""}
            textFieldStyle={styles.emailAddressTextField}
            rightTextFieldImage={icons.person}
          />
          <Input
            placeholder="Email"
            error="Email is required"
            type={INPUT_TYPES.EMAIL}
            identifier="email"
            blurOnSubmit={false}
            value={""}
            textFieldStyle={styles.emailAddressTextField}
            rightTextFieldImage={icons.email}
          />
          {/* <Input
            placeholder="Mobile number"
            error="Mobile Number is required"
            type={INPUT_TYPES.PHONE}
            identifier="mobile_no"
            blurOnSubmit={false}
            value={""}
            textFieldStyle={styles.emailAddressTextField}
            rightTextFieldImage={icons.phone}
          /> */}

          <PhoneInput
            style={[styles.emailAddressTextField, { height: 50 }]}
            initialValue={mobilePhone}
            onChangePhoneNumber={text =>
              this.setState({ mobilePhone: text })
            }
            initialCountry={'us'}
            ref={ref => {
              this.phone = ref;
            }}
          />
          {!mobilePhone && this.renderError(`Mobile Number is required`)}
          <Input
            placeholder="Password"
            error="Passowrd is required"
            type={INPUT_TYPES.PASSWORD}
            identifier="password"
            blurOnSubmit={true}
            textFieldStyle={styles.emailAddressTextField}
            rightTextFieldImage={icons.key}
            value={""}
          />
        </FormHandler>

       
        <View style={styles.divForButtonSpace} />
        <AppButton
          buttonTitle="Sign up"
          style={{ backgroundColor: colors.ActiveTabTitle, width: "100%" }}
          btnColor={colors.cardColor}
          onPress={() => {
            this.onSignUp();
          }}
        />
 

      </ScrollView>
    );
  }
}

const actions = { generalAction };
const mapStateToProps = ({ networkInfo }) => ({ networkInfo });
const ComponentWithComposeFunc = compose(
  connect(
    mapStateToProps,
    actions
  )(WithFetching(WithNetInfoListener(SignUpFacility)))
);

export default ComponentWithComposeFunc;

ComponentWithComposeFunc.navigationOptions = ({ navigation }) => {
  return {
    headerStyle: styles.header,
    headerTitleStyle: styles.headerTitle,
    headerLeft: (
      <TouchableOpacity onPress={() => pop()}>
        <Image
          style={{ margin: 10 }}
          resizeMode="contain"
          source={Images.backArrow}
        />
      </TouchableOpacity>
    ),
    headerRight: null
  };
};
