import { StyleSheet } from "react-native";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
import { colors, UIFont, fonts, fontSize } from "../../assets";

export default StyleSheet.create({
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    headerTitle: {
        color: colors.HeaderTitleColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: "#08548c",
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    bgImage: {
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "column",
        flex: 1
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        paddingBottom: Metrics.xDoubleBaseMargin,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        padding: 20
    },
    divForButtonSpace: {
        margin: Metrics.baseMargin
    },
    heading: {
        ...UIFont.font(fonts.regular, fontSize.huge, colors.WhiteColor),
        lineHeight: 39,
        letterSpacing: 0,
        alignSelf: "flex-start"
    },
    boldHeading: {
        ...UIFont.font(fonts.semiBold, fontSize.huge, colors.WhiteColor),
        marginLeft: 25
    },
    divForUpperSpace: {
        flex: 2
    },
    divForMidSpace: {
        flex: 1
    },
    bottomText: {
        color: colors.LoginBottomText,
        fontSize: 16
    },
    registerText: {
        color: colors.BlackColor
    },
    divForAnotherSpace: {
        flex: 1.5
    },
    divForBottomSpace: {
        flex: 0.5
    },
    emailAddressTextField: {
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
        borderColor: Colors.textfieldBorder,
        borderBottomWidth: 1
    },
    heading2: {
        ...UIFont.font(fonts.regular, fontSize.small, colors.WhiteColor),
        marginLeft: 25
    },
    backArrow: {
        flex: 0.45,
        alignSelf: "flex-start",
        marginTop: 8,
        marginLeft: 8
    }
});
