import React, { Component } from "react";
import { connect } from "react-redux";
import { StyleSheet, View, Image } from "react-native";
import { AppButton } from "../../components";
import {  GoogleSignin,
    GoogleSigninButton,
    statusCodes, } from "@react-native-google-signin/google-signin";
 import Notification from "../../services/Notification";
import { API_SOCIAL_LOGIN, API_LOGIN } from "../../services/WebService";
import { generalAction } from "../../actions/GeneralActions";
import { USER } from "../../actions/ActionTypes";
import Utils from "../../Utils";
import { icons } from "../../assets";
import Metrics from "../../services/Metrics";

GoogleSignin.configure({
    offlineAccess: true,
    scopes: ['https://www.googleapis.com/auth/userinfo.profile'],

    webClientId:
        // "628442394809-5prc2qaptnqiik48bh6507nhjg06qpae.apps.googleusercontent.com"
        "628442394809-5prc2qaptnqiik48bh6507nhjg06qpae.apps.googleusercontent.com"
});

class GoogleLogin extends Component {
    requestSocialLogin = ({ user }) => {
        Notification.fcmToken(token => {
            let payload = new FormData();
            payload.append("email", user.email);
            payload.append("social_id", user.id);
            payload.append("social_type", "google_plus");
            payload.append("device_token", token);
            payload.append("device_type", Utils.getDeviceType());
            payload.append("name", "retrocube");

            this.props.cbShowLoader(true);
            this.props.generalAction(
                API_LOGIN,
                payload,
                USER.SUCCESS,
                USER.FAILURE,
                () => console.log("google login"),
                () => this.props.cbShowLoader(false)
            );
        });
    };

    onGoogleSignIn = async () => {
        try {
            await GoogleSignin.hasPlayServices();
            const userInfo = await GoogleSignin.signIn();
            if (userInfo.user) {
                this.props.socialLogin(userInfo);
                await GoogleSignin.signOut();
            } else {
                Utils.showMessage("Alert", "Failed to login");
            }
        } catch (error) {
            Utils.showMessage("Alert", "Failed to login");

        }
    };

    render() {
        return (
            <View style={styles.containerGoogleSignIn}>
                <AppButton
                    buttonTitle="Google Login"
                    onPress={this.onGoogleSignIn}
                    style={styles.googleSignInContainer}
                    btnColor="white"
                />
                <Image source={icons.icGoogle} style={styles.icGoogle} />
            </View>
        );
    }
}

const actions = { generalAction };

export default connect(null, actions)(GoogleLogin);

const styles = StyleSheet.create({
    containerGoogleSignIn: {
        marginTop: Metrics.smallMargin,
        justifyContent: "center"
    },
    googleSignInContainer: { backgroundColor: "#d32f2f" },
    icGoogle: {
        marginLeft: Metrics.baseMargin,
        position: "absolute",
        width: 26,
        height: 26,
        resizeMode: "contain"
    }
});
