import React from "react";
import {
    StyleSheet,
    View,
    Dimensions,
    Text,
    Clipboard,
    Button,
    Image,
    ActivityIndicator,
    StatusBar,
    WebView,
} from "react-native";
import { AppButton } from "../../components";
import { icons } from "../../assets";
import { Metrics } from "../../services";
import LinkedInModal from "react-native-linkedin";
import { from } from "seamless-immutable";

const BasicProfile = "https://api.linkedin.com/v2/me";
const EmailAddress =
    "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
const LOGOUT_URL = "https://www.linkedin.com/m/logout";

export default class AppContainer extends React.Component {
    constructor(props) {
        super(props);
        this.modal = React.createRef();
        StatusBar.setHidden(true);
        this.state = {
            access_token: undefined,
            refreshing: false,
            logout: false,
        };
    }

    getUser = async (data) => {
        const { access_token, authentication_code } = data;
        if (!authentication_code) {
            this.setState({ refreshing: true });
            const basicProfileOfUser = await this.callLinkdInApi(
                BasicProfile,
                access_token
            );
            const emailAddressOfUser = await this.callLinkdInApi(
                EmailAddress,
                access_token
            );
            const payload = await basicProfileOfUser.json();
            const payload2 = await emailAddressOfUser.json();
            const params = {
                name:
                    payload.localizedFirstName +
                    " " +
                    payload.localizedLastName,
                email: payload2.elements[0]["handle~"].emailAddress,
                id: payload.id,
                social_type: "linkdIn",
            };

            this.setState({ ...payload, refreshing: false });
            this.props.cbOnLinkedInLogin(params);
            this.setState({ logout: true });
        } else {
        }
    };

    async callLinkdInApi(url, access_token) {
        const response = await fetch(url, {
            method: "GET",
            headers: {
                Authorization: "Bearer " + access_token,
            },
        });
        return response;
    }

    renderButton = () => {
        return (
            <View style={styles.container}>
                <AppButton
                    onPress={() => this.modal.current.open()}
                    buttonTitle="LinkedIn Login"
                    style={styles.appButtonContainer}
                    btnColor="white"
                />
                <Image source={icons.linked_in} style={styles.icGoogle} />
            </View>
        );
    };

    render() {
        const {
            emailAddress,
            pictureUrls,
            refreshing,
            firstName,
            lastName,
            headline,
            logout,
        } = this.state;
        return (
            <View style={styles.container}>
                <View style={styles.linkedInContainer}>
                    <LinkedInModal
                        ref={this.modal}
                        // shouldGetAccessToken={false}
                        clientID={"78kfyz2fayrdbf"}
                        clientSecret={"7vT3R7hU3bXCWcNx"}
                        // redirectUri="https://360cubes.com/medical_shift_staging/public/user/login1/linkedin/callback"
                        redirectUri="http://medicalshifts.com/user/login1/linkedin/callback"
                        onSuccess={(data) => this.getUser(data)}
                        // onSignIn={this.onSignIn}
                        renderButton={this.renderButton}
                        permissions={["r_liteprofile", "r_emailaddress"]}
                        linkText="Login with LinkdIn"
                    />
                    {logout && (
                        <View style={{ width: 1, height: 1 }}>
                            <WebView
                                source={{ uri: LOGOUT_URL }}
                                javaScriptEnabled
                                domStorageEnabled
                                sharedCookiesEnabled
                                onLoadEnd={() =>
                                    this.setState({ logout: false })
                                }
                            />
                        </View>
                    )}
                </View>

                {/*refreshing && <ActivityIndicator size="large" />*/}

                {/*emailAddress && (
          <View style={styles.userContainer}>
            <Image
              style={styles.picture}
              source={{ uri: pictureUrls.values[0] }}
            />
            {this.renderItem("Email", emailAddress)}
            {this.renderItem("First name", firstName)}
            {this.renderItem("Last name", lastName)}
            {this.renderItem("Headline", headline)}
          </View>
        )*/}
            </View>
        );
    }
}

const styles = {
    container: {
        marginTop: Metrics.smallMargin / 2,
        justifyContent: "center",
    },
    appButtonContainer: { backgroundColor: "#2C77B6" },
    icGoogle: {
        left: Metrics.baseMargin,
        position: "absolute",
        width: 26,
        height: 26,
        resizeMode: "contain",
    },
};
