import React, { Component } from "react";
import { View } from "react-native";

import LinkdInLogin from "./LinkdInLogin";
import GoogleLogin from "./GoogleLogin";
// import FbLogin from "./FbLogin"; // Disabled - Facebook Login not in use
import AppleLogin from "./AppleLogin";

import { API_LOGIN } from "../../services/WebService";

import { USER } from "../../actions/ActionTypes";

import Utils from "../../Utils";

class SocialLogin extends Component {
    cbOnSocialLogin = (socialObj) =>
        this.props.socialLogin({ user: socialObj });

    render() {
        const { socialLogin, cbShowLoader } = this.props;
        return (
            <View
                style={{
                    width: "100%",
                }}>
                <GoogleLogin
                    socialLogin={socialLogin}
                    cbShowLoader={cbShowLoader}
                />
                {/* <FbLogin cbOnFbLogin={this.cbOnSocialLogin} /> */}
                <LinkdInLogin cbOnLinkedInLogin={this.cbOnSocialLogin} />
                {Utils.isPlatformAndroid  ? null :
                <AppleLogin cbOnAppleLogin={this.cbOnSocialLogin} />}
            </View>
        );
    }
}

export default SocialLogin;
