import React, { Component } from "react";
import {
    View,
    StyleSheet,
    TouchableOpacity,
    Image,
    ImageBackground,
    Text,
    Linking, TextInput, Button,
    Modal
} from "react-native";
import { AppButton} from "../../components";
import { ListItem, Icon } from "react-native-elements";
import { connect } from "react-redux";
import { pop } from "../../services/NavigationService";
import { Images, UIFont, fonts, fontSize, colors } from "../../assets";
import Metrics from "../../services/Metrics";
import Utils from "../../Utils";
import { generalAction } from "../../actions/GeneralActions";
import { Overlay } from 'react-native-elements';
import { AppStyles } from "../../services";


class Support extends Component {


    static navigationOptions = ({ navigation }) => {
        return {
            title: "Support Request",
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={Images.backArrow}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };


    state = {
        isFetching: false,
        ismodal: false,
        Modal: "",
        text_message: '',
        totalProjects: 0,
        number_sms: '',
        message_sms: 'Please follow us on https://reactnativecode.com',
        totalPayment: 0,
        number_val: Utils.getHelpLine(),
        listdata: [{
            name: 'Video',
            avatar_url: 'video',
            subtitle: 'You will see us, but we wont see you'
        },
        {
            name: 'Audio',
            avatar_url: 'microphone',
            subtitle: 'Speak through your computer!'
        },
        {
            name: 'Phone',
            avatar_url: 'mobile',
            subtitle: 'Enter your number and we will call you'
        },
        {
            name: 'Chat',
            avatar_url: 'comment',
            subtitle: 'For the texter in all of us!'
        }]
    };


    componentDidMount() {

    }


    onEnterText = (text_message) => {


        this.setState({ text_message: text_message });

    }


    gotoCall() {

        Linking.openURL(`tel:` + this.state.number_val);

    };
    hideModal() {

        this.setState({ Modal: false })

    }
    showModal() {

        this.setState({ Modal: true })

    };

    sendSms_fun = async () => {

        const url = (Platform.OS === 'android')
            ? 'sms:' + this.state.number_val + '?body=' + this.state.text_message
            : 'sms:' + this.state.number_val
        Linking.canOpenURL(url).then(supported => {
            if (!supported) {


                Linking.openURL(url).then(supported => {

                    this.hideModal();

                }).catch(err => Utils.showError(err))


            } else {

                this.hideModal();
                return Linking.openURL(url)

            }
        }).catch(err => Utils.showError(err))
    }

    render() {
        return (

            <ImageBackground source={Images.bgImage} style={styles.bgImage}>

                <View style={styles.loginForm}>

                    <ImageBackground blurRadius={1}
                        source={Images.support} style={styles.backgroundImage} />

                    <Text style={{
                        color: 'white', padding: 20,
                        fontSize: 20, alignSelf: 'center'
                    }}

                    >How Would you like to talk?</Text>

                    <ListItem onPress={() => this.gotoCall()}>
                        <Icon
                            name="mobile"
                            type='foundation'
                        />
                        <ListItem.Content >
                            <ListItem.Title style={{ color: 'black', fontWeight: 'bold' }}>
                                Phone
                            </ListItem.Title>
                            <ListItem.Subtitle style={{ color: 'black' }}>
                                Enter your number and we will call you
                            </ListItem.Subtitle>
                        </ListItem.Content>
                    </ListItem >

                    <ListItem onPress={() => this.showModal()}>
                        <Icon
                            name="comment"
                            type='foundation'
                        />
                        <ListItem.Content >
                            <ListItem.Title style={{ color: 'black', fontWeight: 'bold' }}>
                                Chat
                            </ListItem.Title>
                            <ListItem.Subtitle style={{ color: 'black' }}>
                                For the texter in all of us!
                            </ListItem.Subtitle>
                        </ListItem.Content>
                    </ListItem>
                </View>

                <View style={styles.centeredView}>

                    <Modal transparent visible={this.state.Modal} >
                        <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
                            <View style={{
                                backgroundColor: "white",
                                paddingVertical: Metrics.ratio(50),
                                paddingHorizontal: Metrics.baseMargin,
                                borderRadius: Metrics.baseMargin,
                                ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
                            }}>

                                <TouchableOpacity
                                    activeOpacity={1}
                                    onPressOut={() => this.setState({ Modal: false })}>

                                    <View style={styles.modalView} >

                                        <TextInput
                                            mode='outlined'
                                            multiline
                                            numberOfLines={4}
                                            textAlignVertical="top"
                                            placeholder="Enter a Message"
                                            onChangeText={text_message => this.setState({ text_message })}
                                            theme={{ colors: { primary: '#06C73D', underlineColor: 'transparent', } }}
                                            style={styles.inputStyle} />

                                        <View style={{
                                            flexDirection: "row", alignItems: 'center', alignSelf: 'center',
                                            alignContent: 'center'
                                        }}>
                                            <View style={styles.buttonStyleback}>
                                                <AppButton
                                                    buttonTitle="CANCEL"
                                                    style={{
                                                        backgroundColor: "#d45404", height: 50,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor="#d45404"
                                                    onPress={() => {
                                                        this.setState({ Modal: false })
                                                    }}
                                                />
                                            </View>
                                            <View style={styles.buttonStyle}>
                                                <AppButton
                                                    buttonTitle="VERIFY"
                                                    enable={this.state.isbutton}
                                                    style={{
                                                        backgroundColor: !this.state.isbutton ?
                                                            colors.ActiveTabTitle : colors.LightGreyColor,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor={colors.cardColor}
                                                    onPress={() => this.sendSms_fun()}

                                                />

                                            </View>
                                        </View>

                                    </View>
                                </TouchableOpacity>

                            </View>
                        </View>
                    </Modal>





                </View>

            </ImageBackground>


        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ user, closeContracts }) => ({
    user: user.data,
    closeContracts: closeContracts.data
});

export default connect(mapStateToProps, actions)(Support);

const styles = StyleSheet.create({
    input: {
        height: 40,
        margin: 12,
        borderWidth: 1,
        padding: 10,
    },
    centeredView: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        marginTop: 10
    },
    modalView: {
        alignItems: "center",
        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: 2
        },
        shadowOpacity: 0.25,
        shadowRadius: 4,
        elevation: 5
    },
    backgroundImage: {
        flex: 0.5,
    },
    loginForm: {
        flex: 1,
        position: 'absolute',
        top: 0,
        bottom: 0,
        left: 0,
        right: 0
    },
    inputStyle: {
        fontSize: 16,
        padding: 10,
        height: 100,
        marginTop: 5,
        borderLeftColor: "rgb(8, 84, 140)",
        borderRightColor: "rgb(8, 84, 140)",
        borderTopColor: "rgb(8, 84, 140)",
        borderTopWidth: 2,
        borderLeftWidth: 2,
        borderRightWidth: 2,
        borderBottomWidth: 2,
        borderColor: "rgb(8, 84, 140)",
        borderRadius: 10,
        marginBottom: 5,
        width: 250

    },
    bgImage: {
        width: "100%",
        height: "100%",
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "column",
        flex: 1
    },
    headerTitle: {
        color: colors.cardColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.ActiveTabTitle,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    },
    buttonStyleback: {
        width: "40%",
        alignItems: 'center',
        marginRight: 10,
        marginBottom: 30,
        marginTop:20
    },
    buttonStyle: {
        width: "40%",
        alignItems: 'center',
        marginLeft: 10,
        marginBottom: 30,
        marginTop:20

    },
});