import React, { Component } from "react";
import {
    View,
    Text,
    ImageBackground,
    TouchableOpacity,
    Image
} from "react-native";
import { connect } from "react-redux";
import { Images, icons } from "../../assets";
import { pop, push, popToTop } from "../../services/NavigationService";
import styles from "./styles";
import { generalSaveAction } from "../../actions/GeneralActions";
import { Supporticon} from "../../components";

class UserType extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={Images.backArrow}
                    />
                </TouchableOpacity>
            ),
            headerRight: null
        };
    };

    componentDidMount() {
        // this.props.generalSaveAction(USER.SUCCESS, { userLoggedIn: true });
    }

    onPress(goTo) {
        const {
            cbOnSelectUser,
            selectUser
        } = this.props.route.params;
        selectUser ? this.popBack(cbOnSelectUser, goTo) : push(goTo);
    }

    popBack(cbOnSelectUser, goTo) {
        cbOnSelectUser(goTo === "signUpContractor" ? "Contractor" : "Facility");
    }

    renderBg = icon => <Image source={icon} />;

    cardGap = obj => <View style={obj} />;

    heading = () => {
        return (
            <View style={{ flex: 1.8 }}>
                <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
                    <Text style={[styles.heading, styles.boldHeading]}>
                        Please
                    </Text>
                    <Text style={styles.heading}> select a </Text>
                </View>
                <Text style={[styles.heading, { marginLeft: 25 }]}>
                    User type
                </Text>
            </View>
        );
    };

    categoryCard = (text1, text2) => {
        return (
            <React.Fragment>
                <Text style={styles.heading2}>{text1}</Text>
                <Text style={styles.boldHeading2}>{text2}</Text>
                <View
                    style={[styles.backArrow, { marginLeft: 0, marginTop: 15 }]}
                >
                    {this.renderBg(icons.ic_trending_flat)}
                </View>
            </React.Fragment>
        );
    };

    footer = () => {
        return (
            <View style={styles.footer}>
                <Text style={styles.bottomText} numberOfLines={2}>
                    Lorem ipsum dolor sit amet, consectetuer adipiscing elit,
                    sed diam nonummy nibh euismod{" "}
                </Text>
            </View>
        );
    };

    facilityContractorImg = (viewStyle, img, goTo) => {
        return (
            <TouchableOpacity
                onPress={() => this.onPress(goTo)}
                elevation={15}
                style={viewStyle}
            >
                {this.renderBg(img)}
            </TouchableOpacity>
        );
    };

    contractorPart = () => {
        return (
            <View style={styles.upperDiv}>
                {this.cardGap(styles.emptySpace)}
                <View style={styles.middleDiv}>
                    {this.heading()}
                    <View style={styles.innerDiv}>
                        <TouchableOpacity
                            onPress={() => this.onPress("signUpContractor")}
                            elevation={10}
                            style={styles.inputWrapper}
                        >
                            {this.categoryCard("Sign up as a", "Staff")}
                        </TouchableOpacity>
                    </View>
                </View>
                {this.facilityContractorImg(
                    styles.contractorImg,
                    Images.bgContractor,
                    "signUpContractor"
                )}
            </View>
        );
    };

    facilityPart = () => {
        return (
            <View style={styles.upperDiv}>
                <View style={{ flex: 5.7 }}>
                    {this.cardGap(styles.innerDiv)}
                    <View style={styles.innerDiv}>
                        <TouchableOpacity
                            onPress={() => this.onPress("signUpFacility")}
                            elevation={10}
                            style={[
                                styles.inputWrapper,
                                { flexDirection: "row" }
                            ]}
                        >
                            {this.cardGap({ flex: 3.5 })}
                            <View style={styles.innerDiv}>
                                {this.categoryCard(
                                  "Sign up as a", "Facility"
                                )}
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
                {this.cardGap(styles.emptySpace)}
                {this.facilityContractorImg(
                    styles.facilityImg,
                    Images.bgFacility,
                    "signUpFacility"
                )}
            </View>
        );
    };

    render() {
        return (
            <ImageBackground source={Images.bgImage} style={styles.bgImage}>
                {this.contractorPart()}
                {this.facilityPart()}
                {/* {this.footer()} */}
                {this.cardGap({ flex: 0.6 })}
                <Supporticon
                 clickBtn={() =>push("SupportLogin")}/>

                 
            </ImageBackground>
        );
    }
}

const actions = { generalSaveAction };

export default connect(null, actions)(UserType);
