import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";

export default StyleSheet.create({
  headerTitle: {
    color: colors.HeaderTitleColor,
    alignSelf: 'center',
    textAlign: "center",
    justifyContent: 'center',
    flex: 1,
    fontWeight: 'bold',
    textAlignVertical: 'center'
  },
  header: {
    borderBottomWidth: 0,
    backgroundColor: "#08548c",
    shadowColor: 'transparent',
    elevation: 0,
    shadowRadius: 0,
    shadowOffset: {
        height: 0,
    } 
  },
  bgImage: {
    flexDirection: "column",
    flex: 1
  },
  backArrow: {
    flex: 0.45,
    justifyContent: "center",
    marginLeft: 10
  },
  upperDiv: {
    flex: 4
  },
  faciltyPart: {
    flex: 4,
    backgroundColor: "orange"
  },
  emptySpace: {
    flex: 1
  },
  middleDiv: {
    flex: 4
  },
  footer: {
    flex: 1,
    paddingHorizontal: 30
  },
  innerDiv: {
    flex: 2
  },
  heading: {
    ...UIFont.font(fonts.regular, fontSize.huge, colors.WhiteColor),
    lineHeight: 39,
    letterSpacing: 0,
    alignSelf: "flex-start",
  },
  boldHeading: {
    ...UIFont.font(fonts.semiBold, fontSize.huge, colors.WhiteColor),
    marginLeft: 25,
  },
  inputWrapper: {
    width: "92%",
    height: "100%",
    backgroundColor: colors.WhiteColor,
    borderRadius: 6,
    shadowColor: colors.BlackColor,
    shadowOpacity: 0.8,
    shadowRadius: 20,
    shadowOffset: {
      height: 5,
      width: 5
    },
    padding: 10,
    alignSelf: "center"
  },
  heading2: {
    ...UIFont.font(fonts.regular, fontSize.large, colors.BlackColor),
    lineHeight: 24,
    letterSpacing: 0
  },
  boldHeading2: {
    ...UIFont.font(fonts.semiBold, fontSize.large, colors.ActiveTabTitle),
    lineHeight: 24,
    letterSpacing: 0
  },
  bottomText: {
    ...UIFont.font(fonts.regular, fontSize.xSmall, colors.LoginBottomText),
    alignSelf: "center",
    textAlign: "center",
    lineHeight: 16,
    letterSpacing: 0,
  },
  contractorImg: {
    position: "absolute", 
    right: 0, bottom: 0
  },
  facilityImg: {
    position: "absolute", 
    left: 5, top: 0
  }
});
