import React, { Component } from "react";
import { View, Text, ScrollView, StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import { BASE_URL } from "../../services/WebService";
import Metrics from "../../services/Metrics";
import { pop, push, popToTop } from "../../services/NavigationService";
import { WebView } from "../../components";

class Verification extends Component {
    constructor(props) {
        super(props);
        this.state = {
            done: false
        };
    }

    _onLoad(state) {
        const { cbVerified } = this.props.route.params;
        if (state.url.indexOf(BASE_URL + "user/formrequestthankyou") != -1) {
            if (!this.state.done) {
                this.setState({ done: true });
                cbVerified();
                pop();
            }
        }
    }

    render() {
        const { token } = this.props.route.params;
        return (
            <WebView
                source={{
                    uri: `${BASE_URL}user/formrequest/${token}`
                }}
                style={{ backgroundColor: colors.HeaderColor }}
                onNavigationStateChange={r => this._onLoad(r)}
                javaScriptEnabled
            />
        );
    }
}

export default Verification;
const Styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: "white",
        padding: Metrics.doubleBaseMargin,
        alignItems: "center"
    },
    textStyle: {
        ...UIFont.font(fonts.regular, 17, colors.BlackColor),
        lineHeight: 20
    }
});
