import React, { Component } from "react";
import { connect } from "react-redux";
import { WithFetching } from "../../HOC";
import {
    StyleSheet,
    Image as ImageRN
} from "react-native";
import {
    DocumentImages,
    TextLabel,

} from "../../components";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { generalAction } from "../../actions/GeneralActions";

class ViewDocuments extends Component {
    constructor(props) {
        super(props);
        const { data } = props.route.params;

        this.state = {
            rating: 0,
            expiryDate: data.medical_license_expiry_date,
            isError: false,
            images: JSON.parse(props.route.params.images),
        };
    }

    heading(label) {
        return (
            <TextLabel color={"black"} style={styles.boldText}>
                {label}
            </TextLabel>
        );
    }

    render() {
        const { images, expiryDate, isError } = this.state;
        const { data } = this.props.route.params;
        const {
            is_background_check_status,
            accepted_invitations_count,
            background_check_pdf_file
        } = data;

        return (
            <DocumentImages
                data={{
                    expiryDate,
                    isError,
                    images
                }}
                onChangeState={this.onChangeState}
                cbOnDateChange={this.cbOnDateChange}
                showLicenceAndDeleteIcons={false}
                downLoadClinicianDocuments={
                    is_background_check_status && accepted_invitations_count > 0
                        ? background_check_pdf_file
                        : false
                }
            />
        );
    }
}

const styles = StyleSheet.create({
    boldText: {
        ...UIFont.font(fonts.regular, 18, colors.BlackColor),
        marginTop: 10,
        marginBottom: 10,
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    }
});

const actions = { generalAction };

export default connect(null, actions)(WithFetching(ViewDocuments));
