import React, { Component } from "react";
import {
    View,
    Text,
    TouchableOpacity,
    Image,
    ScrollView,
    TouchableWithoutFeedback
} from "react-native";
import { connect } from "react-redux";
import PostTypeSelection from "../ShiftHome/postTypeSelection";
import { compose } from "redux";
import { pop, push } from "../../services/NavigationService";
import { Images, icons, colors } from "../../assets";
import {
    DetailCard,
    Separator,
    TextLabel,
    FooterDetail,
    ReusableModal,
    AcceptRejectBid,
    MileagePaidBidRate,
    Supporticon
} from "../../components";
import {
    InfoModal,
    AllInfo,
    InfoMileage,
    Options,
    DeleteModal
} from "../../appComponents/ModalComponents";
import {
    API_FACILITY_INVITATION,
    API_INVITATION_CANCEL
} from "../../services/WebService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { DUMP } from "../../actions/ActionTypes";
import { WithFetching } from "../../HOC";
import Utils from "../../Utils";
import moment from "moment";
import styles from "./styles";

import { selectPostDetails } from "../../reduxSelectors";

class contractorInvitationDetail extends Component {
    constructor(props) {
        super(props);
        this.state = {
            boo: false,
            modal: "",
            maxRadius: props.route.params.data.maximum_radius,
            enableFir: true,
            enableSec: false,
            bidRate: 0
        };
    }

    componentDidMount() {
        const {
            contract_type,
            cost_per_mile
        } = this.props.route.params.data;
        this.props.navigation.setParams({
            showInfo: () => this.showModal("allInfo"),
            boo:
                contract_type == "Shift" && cost_per_mile == null
                    ? null
                    : cost_per_mile
        });
    }

    goTo = (data, boo) => {
        const { user } = this.props,
            { bidRate, enableFir, modal } = this.state;
        let api = "",
            payload = new FormData();
        if (modal === "options" || boo) {
            api = API_FACILITY_INVITATION;
            this.props.cbShowLoader(true);
            payload.append("user_id", user.id);
            payload.append("contract_id", data.contract_id);
            payload.append("invitation_status", "pending");
            payload.append("invitation_type", "received");
            payload.append("latitude", data.invitation_latitude);
            payload.append("longitude", data.invitation_longitude);
            payload.append(
                "bid_amount",
                enableFir
                    ? data.bid_amount
                    : data.contract_type == "Contract"
                        ? bidRate
                        : data.total_hours * bidRate
            );
            payload.append("address", data.address);
        } else if (modal === "delete") {
            api = API_INVITATION_CANCEL;
            payload.append("id", data.invitation_id);
        }
        this.callApi(api, payload);
    };

    callApi = (api, payload) => {
        this.props.generalAction(
            api,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            () => {
                pop();
                this.hideModal();
                this.props.cbShowLoader(false);
            },
            () => {
                this.props.cbShowLoader(false);
                this.hideModal();
            }
        );
    };

    showModal = modal => {
        this.setState({ modal });
        this.Modal.setModalVisible(true);
    };

    hideModal = () => {
        this.setState({ boo: false });
        this.Modal.setModalVisible(false);
    };

    renderModal = () => {
        const { modal, maxRadius, enableFir, enableSec, bidRate } = this.state;
        const { data } = this.props.route.params;
        let rate =
            data.hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0,
                    data.hourly_pay_rate.indexOf(".")
                );
        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={styles.modalContainer}>
                        <View style={styles.modalInner}>
                            {modal == "info" && (
                                <InfoModal
                                    costMile={data.cost_per_mile}
                                    maxRadius={maxRadius}
                                />
                            )}
                            {modal == "allInfo" && (
                                <AllInfo note={this.props.note} />
                            )}
                            {modal == "mileage" && (
                                <InfoMileage
                                    rate={rate}
                                    contract_type={data.contract_type}
                                    diffTime={data.total_hours}
                                />
                            )}
                            {modal == "options" && (
                                <Options
                                    type={data.contract_type}
                                    hourTotal={data.bid_amount}
                                    perHour={
                                        data.total_hours == 0
                                            ? data.bid_amount
                                            : data.bid_amount / data.total_hours
                                    }
                                    onClickFirst={() =>
                                        this.setState({
                                            enableFir: true,
                                            enableSec: false
                                        })
                                    }
                                    onClickSec={() =>
                                        this.setState({
                                            enableFir: false,
                                            enableSec: true
                                        })
                                    }
                                    enableFir={enableFir}
                                    enableSec={enableSec}
                                    onChangeText={bidRate =>
                                        this.setState({ bidRate })
                                    }
                                    bidRate={bidRate}
                                    onPress={() => this.goTo(data)}
                                />
                            )}
                            {modal == "delete" && (
                                <DeleteModal
                                    deleteContract={() => this.goTo(data)}
                                    hideModal={this.hideModal}
                                    text1={"Are you sure you want to cancel"}
                                    text2={"this invitation"}
                                />
                            )}
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };

    heading(label) {
        return (
            <TextLabel
                type="medium"
                size="medium"
                color={"black"}
                style={styles.boldText}
            >
                {label}
            </TextLabel>
        );
    }

    footer() {
        return (
            <FooterDetail
                style={{ position: "absolute", bottom: 0 }}
                text={"BID NOW"}
                backgroundColor={{ backgroundColor: "#08548c" }}
                textColor={{ color: "#ffffff" }}
                clickBtn={() => push("inviteContractors")}
            />
        );
    }

    paragraph(para, style, numberOfLines) {
        return (
            <Text style={style} numberOfLines={numberOfLines}>
                {para}
            </Text>
        );
    }

    labelButton(txt1, txt2, style) {
        return (
            <View style={[styles.eachView, style]}>
                <Text style={styles.firstText}>{txt1}</Text>
                <Text style={styles.txtContract}>{txt2}</Text>
            </View>
        );
    }

    mileagePaidLabelButton(data) {
        return (
            <View style={[styles.defaultStyle, { marginTop: 10 }]}>
                <View style={{ flex: 4 }}>
                    {this.heading("Mileage Paid", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View style={[styles.ViewLabelButton, { flex: 2 }]}>
                    {/* {this.labelButton(
                        "Mileage Total",
                        `$${(
                            Utils.distance(
                                data.latitude,
                                data.longitude,
                                data.invitation_latitude,
                                data.invitation_longitude
                            ) * data.cost_per_mile
                        ).toFixed(2)}`,
                        {
                            width: "65%"
                        }
                    )} */}
                    {this.labelButton(
                        "Mileage Total",
                        `$${data.mileage_amount.toFixed(2)}`,
                        {
                            width: "65%"
                        }
                    )}


                </View>
            </View>
        );
    }

    bidRateLabelButton() {
        const { data } = this.props.route.params;
        // let totalMileage =
        //     Utils.distance(
        //         data.latitude,
        //         data.longitude,
        //         data.invitation_latitude,
        //         data.invitation_longitude
        //     ) * +data.cost_per_mile;

        let totalMileage = data.mileage_amount;
        return (
            <View style={[styles.defaultStyle, { marginVertical: 20 }]}>
                <View>
                    {this.heading("Bid Rate", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View
                    style={[
                        styles.ViewLabelButton,
                        {
                            flex: 3,
                            justifyContent:
                                data.contract_type === "Contract"
                                    ? "flex-end"
                                    : "space-between",
                            flexDirection: "row"
                        }
                    ]}
                >
                    {data.contract_type === "Shift" &&
                        this.labelButton(
                            "Per Hour",
                            `$${data.total_hours == 0
                                ? data.bid_amount
                                : data.bid_amount / data.total_hours
                            }`,
                            { width: "19%" }
                        )}
                    {data.contract_type === "Shift" &&
                        this.labelButton("Hour Total", `$${data.bid_amount}`, {
                            width: "29%"
                        })}
                    {(data.contract_type === "Contract" ||
                        (data.contract_type === "Shift" &&
                            totalMileage == 0)) &&
                        this.labelButton("Total", `$${data.bid_amount}`, {
                            width: "45%"
                        })}
                    {data.contract_type === "Shift" &&
                        totalMileage > 0 &&
                        this.labelButton(
                            "Total ( Mileage + Bid )",
                            `$${+data.bid_amount + +totalMileage}`,
                            {
                                width: "49%"
                            }
                        )}
                </View>
            </View>
        );
    }

    mileagePaidLabelButtonWithoutBid() {
        const { data } = this.props.route.params;
        let dist = Utils.distance(
            data.latitude,
            data.longitude,
            data.invitation_latitude,
            data.invitation_longitude
        );
        let totalDistance =
            dist > data.maximum_radius ? data.maximum_radius : dist;
        let totalMileage = data.cost_per_mile
            ? totalDistance * data.cost_per_mile
            : 0;
        let rate =
            data.hourly_pay_rate === null
                ? data.contract_rate &&
                data.contract_rate.slice(0, data.contract_rate.indexOf("."))
                : data.hourly_pay_rate &&
                data.hourly_pay_rate.slice(
                    0,
                    data.hourly_pay_rate.indexOf(".")
                );
        let bidAmount =
            data.contract_type === "Contract" ? rate : +rate * data.total_hours;
        return (
            <View style={[styles.defaultStyle, { marginVertical: 20 }]}>
                <View style={{ flex: 1.3 }}>
                    {this.heading("Rate", [
                        styles.mileageBidLabelStyle,
                        { marginBottom: -5 }
                    ])}
                </View>
                <View
                    style={[
                        styles.ViewLabelButton,
                        {
                            flex: 4,
                            justifyContent: "space-between",
                            flexDirection: "row"
                        }
                    ]}
                >
                    {this.labelButton("Hour Total", `$${bidAmount}`, {
                        width: "49%"
                    })}
                    {this.labelButton(
                        "Total",
                        `$${(+bidAmount + +totalMileage).toFixed(2)}`,
                        {
                            width: "49%"
                        }
                    )}
                </View>
            </View>
        );
    }

    render() {
        const { data } = this.props.route.params;
        return (
            <React.Fragment>
                <ScrollView style={{ backgroundColor: "#f8f8f8" }}>
                    <DetailCard
                        data={data}
                        pending={"Pending..."}
                        cbMileage={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("info")
                        }
                        cbTotal={() =>
                            data.contract_type === "Contract"
                                ? null
                                : this.showModal("mileage")
                        }
                    />
                    {!!data.is_mileage_paid && (
                        <Separator style={styles.separatorStyle} />
                    )}
                    {!!data.is_mileage_paid && (
                        <MileagePaidBidRate
                            val1={data.location_address}
                            val2={data.address}
                            style={styles.textStyle}
                        />
                    )}
                    {!!data.is_mileage_paid &&
                        this.mileagePaidLabelButton(data)}
                    {data.bid_amount == "0.00" &&
                        !!data.is_mileage_paid &&
                        this.mileagePaidLabelButtonWithoutBid()}
                    {!!+data.bid_amount && (
                        <Separator style={styles.separatorStyle} />
                    )}
                    {!!+data.bid_amount && this.bidRateLabelButton()}
                    <Separator style={styles.separatorStyle} />
                    {this.heading("Description")}
                    {this.paragraph(
                        data.description,
                        styles.descriptionStyle,
                        2
                    )}
                    <Separator style={styles.separatorStyle} />
                    <AcceptRejectBid
                        screen={"sent"}
                        bid_amount={data.bid_amount}
                        text1={"Resend"}
                        text2={"Cancel"}
                        cbOne={
                            !!+data.bid_amount
                                ? () => this.showModal("options")
                                : () => this.goTo(data, true)
                        }
                        cbTwo={() => this.showModal("delete")}
                    />
                </ScrollView>
                {this.renderModal()}

                <Supporticon
                    clickBtn={() => push("Support")} />
            </React.Fragment>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, infoContent }, ownProps) => {
    return {
        user: user.data,
        data: selectPostDetails(ownProps),
        note: infoContent.data.content
    };
};

const DetailComponentCompose = compose(
    connect(mapStateToProps, actions)(WithFetching(contractorInvitationDetail))
);

export default DetailComponentCompose;

DetailComponentCompose.navigationOptions = ({ navigation }) => {
    const { state } = navigation;
    const params = state.params || {};
    return {
        headerStyle: styles.header,
        headerRight: (
            <View style={{ flexDirection: "row" }}>
                {params.boo && (
                    <TouchableOpacity onPress={params.showInfo}>
                        <Image
                            style={{ margin: 10 }}
                            resizeMode="contain"
                            source={icons.ic_info}
                        />
                    </TouchableOpacity>
                )}
            </View>
        )
    };
};
