import { Component } from 'react';
import { Provider, connect } from 'react-redux';
import { PersistGate } from 'redux-persist/integration/react';
import { MessageBar, NotificationBar } from './components';
import { store, persistor } from './store';
import RootNavigator from './navigator';
import Notification from './services/Notification';
import {
  helperOnNotificationInitialized,
  helperOnNotificationOpened,
} from './services/NotificationHandler';
import { generalAction } from '../src/actions/GeneralActions';
import { DUMP, USER } from '../src/actions/ActionTypes';
import {
  API_GET_EACH_CONTRACT,
  API_GET_CONTRACTOR,
} from '../src/services/WebService';
import { push } from '../src/services/NavigationService';
import Utils from './Utils';
import _ from 'lodash';

// Facebook SDK initialization removed - not using Facebook Login

class AppContainer extends Component {
  constructor(props) {
    super(props);

    this.state = {
      isReduxLoaded: false,
      data: [],
      isupdate: '',
      urlvalue: '',
    };

  }

  componentDidMount() {
    // Set Redux loaded after component mounts
    this.setState({ isReduxLoaded: true });

    try {

      Notification.notificationPermission()
        .then((isNotificationAllowed) => {
          if (isNotificationAllowed) {

          }
        })
        .catch(() => {
        });
      Notification.notificationInitialize((notification) => {


        helperOnNotificationInitialized(
          notification,
          this.notificationRouting
        );
      });

      Notification.notificationBackground((notification)=>{

        if (Utils.isPlatformAndroid()) {
          helperOnNotificationOpened(
            notification,
            this.notificationRouting
          );
        } else {
          const { _data } = notification;
          helperOnNotificationOpened(
            {
              _data: JSON.parse(
                _data["gcm.notification.custom_data"]
              ),
            },
            this.notificationRouting
          );
        }

      })

      Notification.notificationForeground((notification)=>{

        if (Utils.isPlatformAndroid()) {
          helperOnNotificationOpened(
            notification,
            this.notificationRouting
          );
        } else {
          const { _data } = notification;
          helperOnNotificationOpened(
            {
              _data: JSON.parse(
                _data["gcm.notification.custom_data"]
              ),
            },
            this.notificationRouting
          );
        }

      })
      Notification.onNotificationOpened((notification) => {

        if (Utils.isPlatformAndroid()) {
          helperOnNotificationOpened(
            notification,
            this.notificationRouting
          );
        } else {
          const { _data } = notification;
          helperOnNotificationOpened(
            {
              _data: JSON.parse(
                _data["gcm.notification.custom_data"]
              ),
            },
            this.notificationRouting
          );
        }
      });




    } catch (error) {
      return error;
    }
    // this._foregroundNotification(); // Commented out - firebase.notifications() API is deprecated


  }



  notificationRouting = (id, identifier, invitation_id) => {

    if (
      identifier == 'profile_verified' ||
      identifier == 'facility_profile_verified'
    ) {
      this.updateUserAfterProfileVerification();
    } else if (identifier == 'contractor_invitation_reject') {
      push('rejectedDetail', {
        contract_id: id,
        invitation_id: invitation_id,
      });
    } else if (
      identifier !== 'contractor_invitation_reject' &&
      identifier !== 'facility_invitation_reject'
    ) {
      store.dispatch(
        generalAction(
          API_GET_EACH_CONTRACT,
          {
            id,
            invitation_id,
            identifier,
          },
          DUMP.SUCCESS,
          DUMP.FAILURE,
          dataArr => {
            let data = dataArr[0];

            if (
              identifier == 'contract_accepted_contractor' ||
              identifier == 'mark_complete_as_clinician'
            ) {
              setTimeout(() => push('onboardProjectsDetail', { data }), 1000);
            } else if (
              identifier == 'contract_accepted_facility' ||
              identifier == 'update_onboarded_contract_history'
            ) {
              push('myScheduleDetail', {
                data,
                isClosedItem: data.contract_status == 'active' ? false : true,
              });
            } else if (
              identifier == 'facility_invitation' &&
              !_.isUndefined(data.contract_invitations[0])
            ) {
              push('requestsDetail', {
                data: data.contract_invitations[0],
                screen: 'received',
              });
            } else if (
              identifier == 'contractor_invitation' &&
              !_.isUndefined(data.contract_invitations[0])
            ) {
              push('availableJobsDetail', {
                data: data.contract_invitations[0],
                screen: 'received',
              });
            } else {
            }
          },
          err => {
            console.log(err);
          },
          true,
        ),
      );
    }
  };

  updateUserAfterProfileVerification() {
    const { user } = store.getState();
    store.dispatch(
      generalAction(
        API_GET_CONTRACTOR,
        { user_id: user.data.id },
        USER.SUCCESS,
        USER.FAILURE,
        () => {
          push('profile');
        },
        err => {
          console.log(err);
        },
        true,
      ),
    );
  }

  // _foregroundNotification method commented out - firebase.notifications() API is deprecated
  // To implement foreground notifications with the new Firebase version, use @notifee/react-native
  // or react-native-push-notification along with @react-native-firebase/messaging

  // _foregroundNotification = () => {
  //   Notification.notificationForeground((notification) => {
  //     const channelId = new firebase.notifications.Android.Channel(
  //       "Default",
  //       "Default",
  //       firebase.notifications.Android.Importance.High
  //     );
  //     firebase.notifications().android.createChannel(channelId);

  //     let notification_to_be_displayed;
  //     if (Utils.isPlatformAndroid()) {
  //       notification_to_be_displayed = new firebase.notifications.Notification(
  //         {
  //           data: notification.data,
  //           sound: "default",
  //           show_in_foreground: true,
  //           title: JSON.parse(notification.data.custom_data).title,
  //           body: notification._body,
  //         }
  //       );
  //     } else {
  //       const { _body, _data } = notification;

  //       notification_to_be_displayed = new firebase.notifications.Notification(
  //         {
  //           data: _data,
  //           sound: "default",
  //           show_in_foreground: true,
  //           title: JSON.parse(_data["gcm.notification.custom_data"])
  //             .title,
  //           body: _body,
  //         }
  //       );

  //     }

  //     if (Platform.OS == "android") {
  //       notification_to_be_displayed.android
  //         .setPriority(firebase.notifications.Android.Priority.High)
  //         .android.setChannelId("Default")
  //         .android.setAutoCancel(true)
  //         .setSound("default")
  //         .android.setSmallIcon("ic_launcher");
  //     }

  //     firebase
  //       .notifications()
  //       .displayNotification(notification_to_be_displayed)
  //       .then((msg) => {
  //       })
  //       .catch((err) => {
  //       });
  //   });
  // };


  render() {
    const { user } = this.props;
    const User = user?.data || {};
    const isUserLoggedIn = Object.keys(User).length > 0;
    const userType = User.user_type;

    console.log('AppContainer render - isUserLoggedIn:', isUserLoggedIn, 'userType:', userType);

    return (
      <>
        {this.state.isReduxLoaded && (
          <RootNavigator
            isUserLoggedIn={isUserLoggedIn}
            userType={userType}
          />
        )}
        <MessageBar />
        <NotificationBar />
      </>
    );
  }
}

const mapStateToProps = ({ user }) => {
  console.log('mapStateToProps - user state:', user);
  return { user };
};

const ConnectedAppContainer = connect(mapStateToProps)(AppContainer);

export default class App extends Component {
  render() {
    return (
      <Provider store={store}>
        <PersistGate
          onBeforeLift={() => {
            // This callback is handled in ConnectedAppContainer
          }}
          persistor={persistor}
        >
          <ConnectedAppContainer />
        </PersistGate>
      </Provider>
    );
  }
}


