import { StyleSheet, Platform } from "react-native";
import Metrics from "../services/Metrics";
import Fonts from "../services/Fonts";
import { colors } from "../../src/assets";
import Colors from "../services/Colors";
export default StyleSheet.create({
    container: {
        flex: 1
    },
    headerTitle: {
        color: colors.HeaderTitleColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.HeaderColor
    },
    headerDashBoard: {
        backgroundColor: Colors.navbar.background,
        elevation: 1,
        borderBottomWidth: 1,
        borderBottomColor: Colors.background.separator
    },
    transparentHeader: { backgroundColor: Colors.transparent },
    title: {
        fontSize: Fonts.size.large,
        fontFamily: Fonts.type.book,
        color: Colors.navbar.text,
        fontWeight: "normal",
        opacity: 0.9,
        fontStyle: "normal",
        letterSpacing: 0
    },
    groov: {
        height: 30,
        resizeMode: "contain"
    },
    iconStyle: {
        width: Metrics.icons.large,
        height: Metrics.icons.large
    },
    tabBarStyle: {
        borderTopColor: Colors.border,
        borderTopWidth: Metrics.horizontalLineHeight,
        backgroundColor: Colors.navbar.background
    },
    indicatorStyle: {
        opacity: 0
    },
    rightButton: {
        flex: 1,
        paddingLeft: Metrics.baseMargin,
        paddingRight: Metrics.baseMargin
    },
    rightTitle: {
        paddingLeft: Metrics.smallMargin,
        marginRight: Metrics.smallMargin,
        color: Colors.text.secondary,
        fontFamily: Fonts.type.medium,
        fontSize: Fonts.size.normal
    },
    rightButtonStyle: {
        marginRight: Metrics.baseMargin
    },
    leftButtonStyle: {
        marginLeft: Metrics.baseMargin
    }
});
