// @flow
import Immutable from "seamless-immutable";
import * as types from "../actions/ActionTypes";

const initialState = Immutable({
    amount: 0
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case types.ADMIN_FEE_AMOUNT:
            return Immutable.merge(state, {
                amount: action.data.amount
            });
        default:
            return state;
    }
};
