import Immutable from "seamless-immutable";
import { CATEGORIES } from "../actions/ActionTypes";

const initialState = Immutable({
    failure: false,
    errMessage: "",
    data: []
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case CATEGORIES.SUCCESS:
            return Immutable.merge(state, {
                failure: false,
                errMessage: "",
                data: action.data
            });

        case CATEGORIES.FAILURE:
            return Immutable.merge(state, {
                failure: true,
                errMessage: action.message
            });

        default:
            return state;
    }
};
