import Immutable from "seamless-immutable";
import { CONTRACTORS } from "../actions/ActionTypes";

const initialState = Immutable({
    failure: false,
    errMessage: "",
    data: []
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case CONTRACTORS.SUCCESS:
            return Immutable.merge(state, {
                failure: false,
                errMessage: "",
                data: action.data
            });

        case CONTRACTORS.FAILURE:
            return Immutable.merge(state, {
                failure: true,
                errMessage: action.message
            });

        default:
            return state;
    }
};
