import Immutable from "seamless-immutable";
import { DUMP } from "../actions/ActionTypes";

const initialState = Immutable({
    failure: false,
    errMessage: "",
    data: []
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case DUMP.SUCCESS:
            return Immutable.merge(state, {
                failure: false,
                errMessage: "",
                data: action.data
            });

        case DUMP.FAILURE:
            return Immutable.merge(state, {
                failure: true,
                errMessage: action.message
            });

        default:
            return state;
    }
};
