import { combineReducers } from "redux";
import user from "./user";
import networkInfo from "./networkInfo";
import categories from "./categories";
import activeContracts from "./activeContracts";
import activeRequests from "./activeRequests";
import closeContracts from "./closeContracts";
import closeRequests from "./closeRequests";
import rejectRequests from "./rejectRequests";
import contractors from "./contractors";
import allContracts from "./allContracts";
import notificationBar from "./notificationBar";
import notifications from "./notifications";
import dump from "./dump";
import infoContent from "./infoContent";
import termsNConditions from "./termsNConditions";
import { LOGOUT } from "../actions/ActionTypes";
import AdminFeeAmount from "./AdminFeeAmount";
import staffData from "./docData";

const appReducer = combineReducers({
    AdminFeeAmount,
    staffData,
    user,
    networkInfo,
    categories,
    activeContracts,
    activeRequests,
    closeContracts,
    rejectRequests,
    contractors,
    notificationBar,
    closeRequests,
    allContracts,
    notifications,
    infoContent,
    dump
});

const rootReducer = (state, action) => {
    if (action.type === LOGOUT) {
        const { user, ...rest } = state;
        state = { ...rest, user: undefined };
    }
    return appReducer(state, action);
};

export default rootReducer;
