import Immutable from "seamless-immutable";
import { INFO_CONTENT } from "../actions/ActionTypes";

const initialState = Immutable({
    failure: false,
    errMessage: "",
    data: {}
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case INFO_CONTENT.SUCCESS:
            return Immutable.merge(state, {
                failure: false,
                errMessage: "",
                data: action.data
            });

        case INFO_CONTENT.FAILURE:
            return Immutable.merge(state, {
                failure: true,
                errMessage: action.message
            });

        default:
            return state;
    }
};
