import Immutable from "seamless-immutable";
import * as types from "../actions/ActionTypes";

const initialState = Immutable({
    showBar: false,
    data: {}
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case types.SHOW_BAR:
            return Immutable.merge(state, {
                showBar: true,
                data: action.data
            });
        case types.HIDE_BAR:
            return Immutable.merge(state, {
                showBar: false,
                data: action.data
            });
        default:
            return state;
    }
};
