import Immutable from "seamless-immutable";
import { LIST_NOTIFICATIONS } from "../actions/ActionTypes";

const initialState = Immutable({
    failure: false,
    errMessage: "",
    data: []
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case LIST_NOTIFICATIONS.SUCCESS: {
            if (action.isConcat) {
                return Immutable.merge(state, {
                    data: _.concat(state.data, action.data),
                    failure: false,
                    errMessage: ""
                });
            }
            return Immutable.merge(state, {
                data: action.data,
                failure: false,
                errMessage: ""
            });
        }

        case LIST_NOTIFICATIONS.FAILURE: {
            return Immutable.merge(state, {
                failure: true,
                errMessage: action.message
            });
        }

        default:
            return state;
    }
};
