import Immutable from "seamless-immutable";
import { TERMS_CONDITIONS } from "../actions/ActionTypes";

const initialState = Immutable({
    showBar: false,
    data: {}
});

export default (state: Object = initialState, action: Object) => {
    switch (action.type) {
        case TERMS_CONDITIONS.SUCCESS:
            return Immutable.merge(state, {
                failure: false,
                errMessage: "",
                data: action.data
            });

        case TERMS_CONDITIONS.FAILURE:
            return Immutable.merge(state, {
                failure: true,
                errMessage: action.message
            });

        default:
            return state;
    }
};
