import Immutable from "seamless-immutable";
import * as types from "../actions/ActionTypes";

const initialState = Immutable({
    failure: false,
    isFetching: false,
    errorMessage: "",
    data: {}
});

export default (state: Object = initialState, action: Object) => {
    // Log all actions that come through this reducer
    if (action.type && action.type.includes('USER')) {
        console.log('=== USER REDUCER: Action received ===', action.type);
    }

    switch (action.type) {
        case types.USER.REQUEST:
            console.log('USER.REQUEST reducer hit');
            return Immutable.merge(state, {
                isFetching: true
            });
        case types.USER.SUCCESS:
            console.log('USER.SUCCESS reducer hit, data:', action.data);
            return Immutable.merge(state, {
                failure: false,
                isFetching: false,
                errorMessage: "",
                data: action.data
            });
        case types.USER.FAILURE:
            console.log('USER.FAILURE reducer hit, error:', action.errorMessage);
            return Immutable.merge(state, {
                failure: true,
                isFetching: false,
                errorMessage: action.errorMessage
            });
        default:
            return state;
    }
};
