import { colors } from "../assets";

const selectPostDetails = ownProps => {
  const { params } = ownProps.navigation.state;
  const { data } = params;
  return {
    cardTitle: data.category_name ? data.category_name : "",
    hospitalName: data.full_name ? data.full_name : "",
    desText: data.description ? data.description : "",
    cardText: "",
    label: params.isClosed ? "Closed" : "Active",
    buttonColor: params.isClosed ? colors.LightGreyColor : colors.btnActive,
    postDate: data.created_at ? data.created_at : "",
    postTime:
      data.shift_start_time && data.shift_end_time
        ? `${data.shift_start_time} to ${data.shift_end_time}`
        : "",
    img: data.image_url
      ? `https://360cubes.com/medical_shift_staging/public${data.image_url}`
      : "",
    contract_type: data.contract_type ? data.contract_type : "",
    locationText: "Illinois 60523, USA"
  };
};

export { selectPostDetails };
