import { call, put, select, takeEvery } from "redux-saga/effects";
import ApiSauce from "../services/ApiSauce";
import { GENERAL } from "../actions/ActionTypes";
import { generalSaveAction } from "../actions/GeneralActions";
import { selectUser } from "../sagaSelectors";

function callRequest(url, data, user, isGetRequest) {
    const header = {};
    if (user.token) {
        header["user-token"] = user.token;
    }
    if (isGetRequest) {
        return ApiSauce.get(url, data, header);
    } else {
        return ApiSauce.post(url, data, header);
    }
}

function* watchRequest(action) {
    const {
        url,
        payload,
        successType,
        failureType,
        successCb,
        failureCb,
        isGetRequest,
        isConcat
    } = action;
    try {
        // make request
        const user = yield select(selectUser);
        const response = yield call(
            callRequest,
            url,
            payload,
            user,
            isGetRequest
        );

        // handle response
        successCb && successCb(response.data, response.message, isConcat);
        yield put(generalSaveAction(successType, response.data, isConcat));
    } catch (err) {
        let errMessage;
        if (err && err.data && err.data.length) errMessage = err.data[0];
        failureCb && failureCb(errMessage);
        yield put(generalSaveAction(failureType, errMessage));
    }
}

export default function* root() {
    yield takeEvery(GENERAL, watchRequest);
}



// import { call, put, select, takeEvery } from "redux-saga/effects";
// import ApiSauce from "../services/ApiSauce";
// import { GENERAL } from "../actions/ActionTypes";
// import { generalSaveAction } from "../actions/GeneralActions";
// import { getUser } from "./selectors";

// function callRequest(url, data, user, isGetRequest) {
//     const header = {};
//     // user is the entire user state object with { data, isFetching, etc }
//     // The actual user data is in user.data
//     if (user && user.data && user.data.token) {
//         header["user-token"] = user.data.token;
//     }
//     if (isGetRequest) {
//         return ApiSauce.get(url, data, header);
//     } else {
//         return ApiSauce.post(url, data, header);
//     }
// }

// function* watchRequest(action) {
//     console.log('=== SAGA: watchRequest triggered ===');
//     console.log('Action received:', action.type);
//     console.log('URL:', action.url);
//     console.log('Has successCb?', !!action.successCb);
//     console.log('Has failureCb?', !!action.failureCb);

//     const {
//         url,
//         payload,
//         successType,
//         failureType,
//         successCb,
//         failureCb,
//         isGetRequest,
//         isConcat
//     } = action;

//     try {
//         // make request
//         const user = yield select(getUser);
//         console.log('User from Redux state:', user);
//         console.log('Making API call to:', url);

//         const response = yield call(
//             callRequest,
//             url,
//             payload,
//             user,
//             isGetRequest
//         );

//         console.log('=== SAGA: API SUCCESS ===');
//         console.log('Response received:', response);
//         console.log('Calling success callback...');

//         // handle response
//         if (successCb) {
//             successCb(response.data, response.message, isConcat);
//             console.log('Success callback executed');
//         } else {
//             console.log('WARNING: No success callback provided!');
//         }

//         yield put(generalSaveAction(successType, response.data, isConcat));
//         console.log('Success action dispatched:', successType);

//     } catch (err) {
//         console.log('=== SAGA: API FAILURE ===');
//         console.log('Error caught:', err);

//         let errMessage;

//         // Handle different error response structures
//         if (err && err.data) {
//             if (Array.isArray(err.data) && err.data.length > 0) {
//                 errMessage = err.data[0];
//             } else if (typeof err.data === 'object') {
//                 errMessage = err.data;
//             } else if (typeof err.data === 'string') {
//                 errMessage = err.data;
//             }
//         } else if (err && err.message) {
//             errMessage = err.message;
//         } else {
//             errMessage = "An error occurred. Please try again.";
//         }

//         console.log('Error message extracted:', errMessage);
//         console.log('Calling failure callback...');

//         if (failureCb) {
//             failureCb(errMessage);
//             console.log('Failure callback executed');
//         } else {
//             console.log('WARNING: No failure callback provided!');
//         }

//         yield put(generalSaveAction(failureType, errMessage));
//         console.log('Failure action dispatched:', failureType);
//     }
// }

// export default function* root() {
//     console.log('=== SAGA GENERAL: Root saga initialized ===');
//     console.log('Listening for action type:', GENERAL);
//     yield takeEvery(GENERAL, watchRequest);
//     console.log('=== SAGA GENERAL: takeEvery registered ===');
// }
