import { take, fork, select } from "redux-saga/effects";
import { REHYDRATE } from "redux-persist/lib/constants";
import { getUser, getAdminFee } from "./selectors";
import Utils from "../Utils";

function* watchReduxLoadFromDisk() {
  while (true) {
    yield take(REHYDRATE);
    try {
      const { data } = yield select(getUser);
      const { amount } = yield select(getAdminFee);
     
      if (Object.keys(data).length > 0) {
        Utils.setUserLoggedIn(true);
        Utils.setUserType(data.user_type);

        Utils.setAdminFee(amount);
      }
    } catch (err) {
      console.warn("saga watchReduxLoadFromDisk error: ", err);
    }
  }
}

export default function* root() {
  yield fork(watchReduxLoadFromDisk);
}
