import { create } from "apisauce";

import {
  API_LOG,
  BASE_URL,
  API_TIMEOUT,
  APPLICATION_TOKEN,
  ERROR_CLIENT,
  ERROR_REQUEST_CANCEL,
  ERROR_REQUEST_TIMEOUT,
  ERROR_SERVER_CONNECTION,
  ERROR_SOMETHING_WENT_WRONG,
  ERROR_NETWORK_NOT_AVAILABLE
} from "./WebService";
import axios from "axios";

const api = create({
  baseURL: BASE_URL,
  headers: {
    token: APPLICATION_TOKEN,
    // DO NOT set Content-Type here - let axios/apisauce handle it automatically
    // for FormData requests (it needs to set the boundary parameter)
  },
  timeout: API_TIMEOUT
});

class ApiSauce {
  async post(url, data, headers) {
    console.log("=== API POST REQUEST START ===");
    console.log("URL:", url);
    console.log("Full URL:", `${BASE_URL}${url}`);
    console.log("Headers:", JSON.stringify(headers));
    console.log("Data type:", data?.constructor?.name);
    console.log("Base URL from config:", BASE_URL);
    console.log("Timeout:", API_TIMEOUT);

    try {
      const startTime = Date.now();
      console.log("Making API call...");

      // Add a timeout race to detect hanging requests
      const timeoutPromise = new Promise((_, reject) => {
        setTimeout(() => {
          console.error("=== REQUEST TIMEOUT - No response after 30 seconds ===");
          reject({
            problem: "TIMEOUT_ERROR",
            ok: false,
            status: 408,
            data: ERROR_REQUEST_TIMEOUT
          });
        }, 30000); // 30 second manual timeout
      });

      const response = await Promise.race([
        api.post(url, data, { headers }),
        timeoutPromise
      ]);

// const response=await axios.post(`${BASE_URL}${url}`, data,   {headers:{
//     token: APPLICATION_TOKEN   }
//   });
      const endTime = Date.now();
      console.log(`=== API RESPONSE RECEIVED (${endTime - startTime}ms) ===`);
      console.log("Response OK:", response.ok);
      console.log("Response Status:", response.status);
      console.log("Response Problem:", response.problem);
      console.log("Response Data:", JSON.stringify(response.data)?.substring(0, 200));

      if (__DEV__ && API_LOG) {
        console.log("Full Response:", response);
      }

      return new Promise((resolve, reject) => {
        if (response.ok && response.data && !response.data.error) {
          console.log("=== SUCCESS - Resolving ===");
          resolve(response.data);
        } else {
          console.log("=== ERROR - Rejecting ===");
          let error = ERROR_SOMETHING_WENT_WRONG;

          switch (response.problem) {
            case "CLIENT_ERROR":
              error = ERROR_CLIENT;
              break;
            case "TIMEOUT_ERROR":
              error = ERROR_REQUEST_TIMEOUT;
              break;
            case "CONNECTION_ERROR":
              error = ERROR_SERVER_CONNECTION;
              break;
            case "NETWORK_ERROR":
              error = ERROR_NETWORK_NOT_AVAILABLE;
              break;
            case "CANCEL_ERROR":
              error = ERROR_REQUEST_CANCEL;
              break;
            default:
              error = "SERVER_ERROR";
          }

          if (response && response.data && response.data.data) {
            var values = Object.keys(response.data.data).map(key => {
              return response.data.data[key];
            });
            const errorMessage = "• " + values.join("\n• ");
          }

          console.log("Error:", error);
          if (response.status === 500) {
            reject(ERROR_SOMETHING_WENT_WRONG);
          }
          reject(response.data || error);
        }
      });
    } catch (err) {
      console.error("=== EXCEPTION CAUGHT IN POST ===");
      console.error("Error:", err);
      console.error("Error message:", err?.message);
      throw err;
    }
  }

  async get(url, data, headers) {
    const response = await api.get(url, data, { headers });

    if (__DEV__ && API_LOG) {
      console.log(response);
    }
    return new Promise((resolve, reject) => {
      if (response.ok && response.data && !response.data.error) {
        resolve(response.data);
      } else {
        if (response.status === 500) {
          reject(ERROR_SOMETHING_WENT_WRONG);
        }
        reject(response.data || error);
      }
    });
  }
  async postImage(url, data, headers) {
    const response = await api.post(url, data, { headers });

    if (__DEV__ && API_LOG) {
      console.log(response);
    }
    return new Promise((resolve, reject) => {
      if (response.ok && response.data && !response.data.error) {
        resolve(response.data);
      } else {
        if (response.status === 500) {
          reject(ERROR_SOMETHING_WENT_WRONG);
        }
        reject(response.data || ERROR_SOMETHING_WENT_WRONG);
      }
    });
  }
}

export default new ApiSauce();


// import { create } from "apisauce";

// import {
//   API_LOG,
//   BASE_URL,
//   API_TIMEOUT,
//   APPLICATION_TOKEN,
//   ERROR_CLIENT,
//   ERROR_REQUEST_CANCEL,
//   ERROR_REQUEST_TIMEOUT,
//   ERROR_SERVER_CONNECTION,
//   ERROR_SOMETHING_WENT_WRONG,
//   ERROR_NETWORK_NOT_AVAILABLE
  
// } from "./WebService";

// const api = create({
//   baseURL: BASE_URL,
//   headers: {
//     token: APPLICATION_TOKEN,
//     // DO NOT set Content-Type here - let apisauce/axios handle it automatically
//     // for FormData requests (it needs to set the boundary parameter)
//   },
//   timeout: API_TIMEOUT
// });

// // Add request/response interceptors for debugging
// // api.addRequestTransform(request => {
// //   console.log('=== API REQUEST TRANSFORM ===');
// //   console.log('Full URL:', request.url);
// //   console.log('Base URL:', api.getBaseURL());
// //   console.log('Method:', request.method);
// //   console.log('Headers:', JSON.stringify(request.headers));
// //   console.log('Data:', request.data);
// // });

// // api.addResponseTransform(response => {
// //   console.log('=== API RESPONSE TRANSFORM ===');
// //   console.log('Status:', response.status);
// //   console.log('OK:', response.ok);
// //   console.log('Problem:', response.problem);
// // });

// class ApiSauce {

//   async post(url, data, headers) {
//     console.log("=== API SAUCE POST: Starting request ===");
//     console.log("URL:", url);
//     console.log("Headers:", headers);
//     console.log("Data type:", data.constructor.name);

//     try {
//       // Create a timeout promise to prevent infinite hanging
//       const timeoutPromise = new Promise((_, reject) => {
//         setTimeout(() => {
//           console.error("=== API SAUCE: REQUEST TIMEOUT after 30 seconds ===");
//           reject(ERROR_REQUEST_TIMEOUT);
//         }, 30000); // 30 second timeout
//       });

//       console.log("=== API SAUCE: Making API call... ===");

//       // Race between actual API call and timeout
//       const response = await Promise.race([
//         api.post(url, data, { headers }),
//         timeoutPromise
//       ]);

//       console.log("=== API SAUCE: Response received ===");
//       console.log("Response OK:", response.ok);
//       console.log("Response status:", response.status);
//       console.log("Response problem:", response.problem);
//       console.log("Response data:", JSON.stringify(response.data).substring(0, 200));

//       if (__DEV__ && API_LOG) {
//         // Additional logging if needed
//       }

//       // Handle response directly without nested Promise
//       if (response.ok && response.data && !response.data.error) {
//         console.log("=== API SAUCE: Resolving SUCCESS ===");
//         return response.data;
//       } else {
//         let error = ERROR_SOMETHING_WENT_WRONG;

//         switch (response.problem) {
//           case "CLIENT_ERROR":
//             error = ERROR_CLIENT;
//             break;
//           case "TIMEOUT_ERROR":
//             error = ERROR_REQUEST_TIMEOUT;
//             break;
//           case "CONNECTION_ERROR":
//             error = ERROR_SERVER_CONNECTION;
//             break;
//           case "NETWORK_ERROR":
//             error = ERROR_NETWORK_NOT_AVAILABLE;
//             break;
//           case "CANCEL_ERROR":
//             error = ERROR_REQUEST_CANCEL;
//             break;
//           default:
//             error = "SERVER_ERROR";
//         }

//         if (response && response.data && response.data.data) {
//           var values = Object.keys(response.data.data).map(key => {
//             return response.data.data[key];
//           });
//           const errorMessage = "• " + values.join("\n• ");
//         }

//         console.log("=== API SAUCE: Rejecting with error ===", response.problem);

//         if (response.status === 500) {
//           throw ERROR_SOMETHING_WENT_WRONG;
//         }
//         throw response.data || error;
//       }
//     } catch (error) {
//       console.error("=== API SAUCE: Exception caught ===");
//       console.error("Error:", error);
//       // Handle timeout or network errors
//       throw error || ERROR_NETWORK_NOT_AVAILABLE;
//     }
//   }

//   async get(url, data, headers) {
//     try {
//       const response = await api.get(url, data, { headers });

//       if (__DEV__ && API_LOG) {
//         console.log("=== API SAUCE GET: Response received ===");
//         console.log("Response OK:", response.ok);
//         console.log("Response status:", response.status);
//       }

//       // Handle response directly without nested Promise
//       if (response.ok && response.data && !response.data.error) {
//         return response.data;
//       } else {
//         if (response.status === 500) {
//           throw ERROR_SOMETHING_WENT_WRONG;
//         }
//         throw response.data || ERROR_SOMETHING_WENT_WRONG;
//       }
//     } catch (error) {
//       console.error("=== API SAUCE GET: Exception caught ===");
//       console.error("Error:", error);
//       throw error || ERROR_NETWORK_NOT_AVAILABLE;
//     }
//   }
//   async postImage(url, data, headers) {
//     try {
//       const response = await api.post(url, data, { headers });

//       if (__DEV__ && API_LOG) {
//         console.log("=== API SAUCE POST IMAGE: Response received ===");
//         console.log("Response OK:", response.ok);
//         console.log("Response status:", response.status);
//       }

//       // Handle response directly without nested Promise
//       if (response.ok && response.data && !response.data.error) {
//         return response.data;
//       } else {
//         if (response.status === 500) {
//           throw ERROR_SOMETHING_WENT_WRONG;
//         }
//         throw response.data || ERROR_SOMETHING_WENT_WRONG;
//       }
//     } catch (error) {
//       console.error("=== API SAUCE POST IMAGE: Exception caught ===");
//       console.error("Error:", error);
//       throw error || ERROR_NETWORK_NOT_AVAILABLE;
//     }
//   }
// }

// export default new ApiSauce();
