import Fonts from "./Fonts";
import Colors from "./Colors";
import Metrics from "./Metrics";

const roundImage = (radius, resizeMode = "contain") => {
  return {
    width: radius,
    height: radius,
    borderRadius: radius / 2,
    resizeMode
  };
};

const lightShadow = {
  shadowOpacity: 0.3,
  shadowRadius: 3,
  shadowOffset: {
    height: 0,
    width: 0
  },
  elevation: 1
};

const heavyShadow = {
  shadowOpacity: 0.2,
  shadowRadius: 3,
  shadowOffset: {
    height: 0,
    width: 0
  },
  elevation: 5
};

const topRadius = val => {
  return {
    borderTopLeftRadius: val,
    borderTopRightRadius: val
  };
};

const bottomRadius = val => {
  return {
    borderTopLeftRadius: val,
    borderTopRightRadius: val
  };
};

const centerAligned = { alignItems: "center", justifyContent: "center" };

// Fonts
const robotoRe = (size: Number = 18, color = Colors.text.azure) => {
  return {
    fontFamily: Fonts.type.regular,
    fontSize: Metrics.generatedFontSize(size),
    color
  };
};

const robotoBold = (size: Number = 18, color = Colors.text.azure) => {
  return {
    fontFamily: Fonts.type.bold,
    fontSize: Metrics.generatedFontSize(size),
    color
  };
};

const robotoMedium = (size: Number = 18, color = Colors.text.azure) => {
  return {
    fontFamily: Fonts.type.medium,
    fontSize: Metrics.generatedFontSize(size),
    color
  };
};

const poppinSb = (size: Number = 18, color = Colors.text.azure) => {
  return {
    fontFamily: Fonts.type.poppinSb,
    fontSize: Metrics.generatedFontSize(size),
    color
  };
};

export default {
  roundImage,
  centerAligned,
  lightShadow,
  heavyShadow,
  topRadius,
  bottomRadius,

  // Fonts
  robotoRe,
  robotoMedium,
  robotoBold,
  poppinSb
};
