import * as ImagePicker from "react-native-image-picker"
import { Platform, PermissionsAndroid } from "react-native";
import ImageResizer from "react-native-image-resizer";



const IMAGE_PICKER_OPTIONS = {
  title: "Pick Image",
  quality: 0.5
};

class MediaPicker {
  getOsSpecificPaths = imgObj => imgObj;

  showPicker = async (cbOnImagePicked) => {
    // On Android 13+ (API 33+), the photo picker doesn't need permissions
    // On older Android versions, we only need WRITE_EXTERNAL_STORAGE for SDK < 33
    // react-native-image-picker v8+ handles permissions automatically

    ImagePicker.launchImageLibrary(
      IMAGE_PICKER_OPTIONS,
      imgObj => {
        if (imgObj.didCancel) {
          // cancelled by user
        } else if (imgObj.error) {
          // error picking image
          console.log('ImagePicker Error: ', imgObj.error);
        } else if (imgObj.customButton) {
          // custom button tapped by user
        } else {
          if (cbOnImagePicked && imgObj.assets && imgObj.assets.length > 0) {
            cbOnImagePicked(this.getOsSpecificPaths(imgObj.assets[0].uri), imgObj);
          }
        }
      }
    );
  }

  resizeImage(uri) {
    return ImageResizer.createResizedImage(uri, 800, 600, "JPEG", 80).then(
      resizedImage => {
        return { ...resizedImage, uri: this.getOsSpecificPaths(resizedImage) };
      }
    );
  }
}

export default new MediaPicker();
