// import * as React from 'react';

// import {
//     NavigationActions,
//     StackActions,
//     DrawerActions
// } from "react-navigation";

// //import { StackActions,DrawerActions } from '@react-navigation/native';
// import { CommonActions } from '@react-navigation/native';

// let navigatorRef;
// let currentRouteName;

// const setCurrentRouteName = routeName => (currentRouteName = routeName);
// const getCurrentRouteName = () => {
//     return currentRouteName;
// };

// const setNavigatorRef = ref => (navigatorRef = ref);
// const getNavigatorRef = () => navigatorRef;

// const push = (routeName: String, params: Object = {}) => {
//     setCurrentRouteName(routeName);
//     navigatorRef.dispatch(NavigationActions.navigate({ routeName, params }));
// };

// const pop = (popCount = 1, params = {}) =>{
//     navigatorRef.dispatch(StackActions.pop({ n: popCount, params }));
//     ;
// }
// const popToTop = () => navigatorRef.dispatch(StackActions.popToTop());

// const reset = (routeName: String, params: Object = {}) => {
//     popToTop();
//     push(routeName, params);
// };

// const openDrawer = () => navigatorRef.dispatch(DrawerActions.openDrawer());
// const closeDrawer = () => navigatorRef.dispatch(DrawerActions.closeDrawer());

// export {
//     setNavigatorRef,
//     getNavigatorRef,
//     push,
//     pop,
//     reset,
//     openDrawer,
//     closeDrawer,
//     popToTop,
//     setCurrentRouteName,
//     getCurrentRouteName
// };
import * as React from 'react';
import { CommonActions, DrawerActions } from '@react-navigation/native';

let navigatorRef;
let currentRouteName;

/**
 * Store the navigation reference
 */
export const setNavigatorRef = (ref) => {
  navigatorRef = ref;
};

/**
 * Get the stored navigator reference
 */
export const getNavigatorRef = () => navigatorRef;

/**
 * Set and get the current route name
 */
export const setCurrentRouteName = (routeName) => (currentRouteName = routeName);
export const getCurrentRouteName = () => currentRouteName;

/**
 * Navigate (push) to another screen
 */
export const push = (routeName, params = {}) => {
  if (navigatorRef) {
    navigatorRef.dispatch(
      CommonActions.navigate({
        name: routeName,
        params,
      })
    );
    setCurrentRouteName(routeName);
  }
};

/**
 * Go back (pop one screen)
 */
export const pop = () => {
  if (navigatorRef) {
    navigatorRef.dispatch(CommonActions.goBack());
  }
};

/**
 * Pop to top (go back to first screen in the stack)
 */
export const popToTop = () => {
  if (navigatorRef) {
    navigatorRef.dispatch(
      CommonActions.reset({
        index: 0,
        routes: [{ name: getCurrentRouteName() }],
      })
    );
  }
};

/**
 * Reset navigation and navigate to a specific route
 */
export const reset = (routeName, params = {}) => {
  if (navigatorRef) {
    navigatorRef.dispatch(
      CommonActions.reset({
        index: 0,
        routes: [{ name: routeName, params }],
      })
    );
    setCurrentRouteName(routeName);
  }
};

/**
 * Drawer actions (for side menus)
 */
export const openDrawer = () => {
  if (navigatorRef) {
    navigatorRef.dispatch(DrawerActions.openDrawer());
  }
};

export const closeDrawer = () => {
  if (navigatorRef) {
    navigatorRef.dispatch(DrawerActions.closeDrawer());
  }
};
